/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.ui.io.FileSystemUtils;
import com.aptana.ide.ui.io.navigator.actions.FileSystemPasteAction;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class FileSystemCopyAction
extends BaseSelectionListenerAction {
    public static final String ID = "com.aptana.ide.ui.io.CopyAction";
    private Shell fShell;
    private Clipboard fClipboard;
    private List<IFileStore> fFileStores;
    private FileSystemPasteAction fPasteAction;

    public FileSystemCopyAction(Shell shell, Clipboard clipboard) {
        super(Messages.FileSystemCopyAction_TXT);
        this.fShell = shell;
        this.fClipboard = clipboard;
        this.fFileStores = new ArrayList<IFileStore>();
        this.setToolTipText(Messages.FileSystemCopyAction_TTP);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "CopyHelpId");
    }

    public FileSystemCopyAction(Shell shell, Clipboard clipboard, FileSystemPasteAction pasteAction) {
        this(shell, clipboard);
        this.fPasteAction = pasteAction;
    }

    public void run() {
        IFileStore[] fileStores = this.fFileStores.toArray(new IFileStore[this.fFileStores.size()]);
        String[] fileNames = new String[fileStores.length];
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < fileStores.length) {
            fileNames[i] = fileStores[i].toString();
            if (i > 0) {
                buf.append("\n");
            }
            buf.append(fileStores[i].getName());
            ++i;
        }
        this.setClipboard(fileStores, fileNames, buf.toString());
        if (this.fPasteAction != null && this.fPasteAction.getStructuredSelection() != null) {
            this.fPasteAction.selectionChanged(this.fPasteAction.getStructuredSelection());
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object[] elements;
        this.fFileStores.clear();
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object[] objectArray = elements = selection.toArray();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IFileStore fileStore = FileSystemUtils.getFileStore(element);
            if (fileStore != null) {
                this.fFileStores.add(fileStore);
            }
            ++n2;
        }
        if (this.fFileStores.size() == 0) {
            return false;
        }
        IFileStore firstParent = this.fFileStores.get(0).getParent();
        if (firstParent == null) {
            return false;
        }
        for (IFileStore store : this.fFileStores) {
            if (store.getParent().equals(firstParent)) continue;
            return false;
        }
        return true;
    }

    private void setClipboard(IFileStore[] fileStores, String[] fileNames, String names) {
        block5: {
            try {
                LocalSelectionTransfer selectionTransfer = LocalSelectionTransfer.getTransfer();
                selectionTransfer.setSelection((ISelection)new StructuredSelection((Object[])fileStores));
                if (fileNames.length > 0) {
                    this.fClipboard.setContents(new Object[]{fileStores, fileNames, names}, new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                } else {
                    this.fClipboard.setContents(new Object[]{fileStores, names}, new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance()});
                }
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fShell, (String)"Problem with copy title", (String)"Problem with copy.")) break block5;
                this.setClipboard(fileStores, fileNames, names);
            }
        }
    }
}

