/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.LocalRoot;
import com.aptana.ide.ui.io.navigator.actions.FileSystemCopyAction;
import com.aptana.ide.ui.io.navigator.actions.FileSystemDeleteAction;
import com.aptana.ide.ui.io.navigator.actions.FileSystemPasteAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.TextActionHandler;

public class FileSystemEditActionGroup
extends ActionGroup {
    private Clipboard fClipboard;
    private Shell fShell;
    private Tree fTree;
    private FileSystemCopyAction fCopyAction;
    private FileSystemPasteAction fPasteAction;
    private FileSystemDeleteAction fDeleteAction;
    private TextActionHandler fTextActionHandler;

    public FileSystemEditActionGroup(Shell shell, Tree tree) {
        this.fShell = shell;
        this.fTree = tree;
        this.makeActions();
    }

    public void dispose() {
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = this.getSelection();
        this.fCopyAction.selectionChanged(selection);
        this.fPasteAction.selectionChanged(selection);
        if (selection != null && !selection.isEmpty()) {
            Object[] elements = selection.toArray();
            boolean allFileSystemObjects = true;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof LocalRoot || element instanceof IConnectionPoint) {
                    allFileSystemObjects = false;
                    break;
                }
                ++n2;
            }
            if (allFileSystemObjects) {
                menu.appendToGroup("group.edit", (IAction)this.fDeleteAction);
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.fTextActionHandler == null) {
            this.fTextActionHandler = new TextActionHandler(actionBars);
        }
        this.fTextActionHandler.setDeleteAction((IAction)this.fDeleteAction);
        this.updateActionBars();
    }

    public void updateActionBars() {
        IStructuredSelection selection = this.getSelection();
        this.fCopyAction.selectionChanged(selection);
        this.fPasteAction.selectionChanged(selection);
        this.fDeleteAction.selectionChanged(selection);
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            if (this.fDeleteAction.isEnabled()) {
                this.fDeleteAction.run();
            }
            event.doit = false;
        }
    }

    protected void makeActions() {
        this.fClipboard = new Clipboard(this.fShell.getDisplay());
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.fPasteAction = new FileSystemPasteAction(this.fShell, this.fClipboard);
        this.fPasteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.fPasteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.fCopyAction = new FileSystemCopyAction(this.fShell, this.fClipboard, this.fPasteAction);
        this.fCopyAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.fCopyAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.fDeleteAction = new FileSystemDeleteAction(this.fShell, this.fTree);
        this.fDeleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.fDeleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.fDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getContext().getSelection();
    }
}

