/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.ui.io.internal.Utils;
import com.aptana.ide.ui.io.navigator.actions.FileSystemNewAction;
import com.aptana.ide.ui.io.navigator.actions.FileSystemToolbarNewAction;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class FileSystemNewActionProvider
extends CommonActionProvider {
    private FileSystemNewAction fNewAction;
    private FileSystemToolbarNewAction fToolbarNewAction;
    private boolean fContribute;
    private boolean toolbarAdded;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        if (aSite.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite viewSite = (ICommonViewerWorkbenchSite)aSite.getViewSite();
            this.fNewAction = new FileSystemNewAction(viewSite.getWorkbenchWindow());
            this.fToolbarNewAction = new FileSystemToolbarNewAction(viewSite.getWorkbenchWindow());
            this.fContribute = true;
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.fContribute) {
            this.updateSelection();
            if (this.isLocalFile()) {
                menu.insertAfter("group.new", (IAction)this.fNewAction);
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.fContribute) {
            this.updateSelection();
            if (!this.toolbarAdded) {
                IToolBarManager manager = actionBars.getToolBarManager();
                IContributionItem[] items = manager.getItems();
                if (items.length > 0) {
                    manager.insertBefore(items[0].getId(), (IAction)this.fToolbarNewAction);
                    manager.insertBefore(items[0].getId(), (IContributionItem)new Separator());
                } else {
                    manager.add((IAction)this.fToolbarNewAction);
                    manager.add((IContributionItem)new Separator());
                }
                actionBars.updateActionBars();
                this.toolbarAdded = true;
            }
        }
    }

    private boolean isLocalFile() {
        IStructuredSelection selection = this.getSelection();
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object object = selection.getFirstElement();
        if (object instanceof IAdaptable) {
            IFileStore fileStore = Utils.getFileStore((IAdaptable)object);
            if (fileStore == null) {
                return false;
            }
            try {
                return fileStore.toLocalFile(0, null) != null;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getContext().getSelection();
    }

    private void updateSelection() {
        this.fNewAction.selectionChanged(this.getSelection());
        this.fToolbarNewAction.selectionChanged(this.getSelection());
    }
}

