/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.ui.io.navigator.actions.FileSystemRenameAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;

public class FileSystemRefactorActionGroup
extends ActionGroup {
    private FileSystemRenameAction fRenameAction;
    private Shell fShell;
    private Tree fTree;

    public FileSystemRefactorActionGroup(Shell shell, Tree tree) {
        this.fShell = shell;
        this.fTree = tree;
        this.makeActions();
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = this.getSelection();
        if (selection != null && !selection.isEmpty()) {
            this.fRenameAction.selectionChanged(selection);
            menu.appendToGroup("group.reorganize", (IAction)this.fRenameAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.updateActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
    }

    public void updateActionBars() {
        IStructuredSelection selection = this.getSelection();
        this.fRenameAction.selectionChanged(selection);
    }

    protected void makeActions() {
        this.fRenameAction = new FileSystemRenameAction(this.fShell, this.fTree);
        this.fRenameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getContext().getSelection();
    }
}

