/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.ui.UIUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.internal.Utils;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class FileSystemRenameAction
extends BaseSelectionListenerAction {
    private Shell fShell;
    private Tree fTree;

    public FileSystemRenameAction(Shell shell, Tree tree) {
        super(Messages.FileSystemRenameAction_Text);
        this.fShell = shell;
        this.fTree = tree;
        this.setToolTipText(Messages.FileSystemRenameAction_ToolTip);
    }

    public void run() {
        TreeItem[] items = this.fTree.getSelection();
        if (items.length > 0) {
            this.renameFile(items[0]);
        }
    }

    private void renameFile(final TreeItem item) {
        Object data = item.getData();
        if (!(data instanceof IAdaptable)) {
            return;
        }
        final IFileStore fileStore = Utils.getFileStore((IAdaptable)data);
        if (fileStore == null) {
            return;
        }
        TreeItem parentItem = item.getParentItem();
        final Object parentData = parentItem == null ? null : parentItem.getData();
        if ("macosx".equals(Platform.getOS())) {
            InputDialog dialog = new InputDialog(this.fShell, Messages.FileSystemRenameAction_InputTitle, Messages.FileSystemRenameAction_InputMessage, item.getText(), null);
            if (dialog.open() == 0) {
                String newName = dialog.getValue();
                try {
                    FileSystemRenameAction.renameTo(fileStore, newName, null);
                    item.setText(newName);
                    FileSystemRenameAction.refresh(parentData);
                }
                catch (CoreException e) {
                    FileSystemRenameAction.showError((Exception)((Object)e));
                }
            }
        } else {
            TreeEditor editor = new TreeEditor(this.fTree);
            final Text text = new Text((Composite)this.fTree, 2048);
            text.setText(item.getText());
            text.selectAll();
            editor.horizontalAlignment = 16384;
            editor.verticalAlignment = 128;
            editor.grabHorizontal = true;
            editor.setEditor((Control)text, item);
            Listener textListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.detail) {
                        case 4: {
                            String newName = text.getText();
                            try {
                                FileSystemRenameAction.renameTo(fileStore, newName, null);
                                item.setText(newName);
                                FileSystemRenameAction.refresh(parentData);
                            }
                            catch (CoreException ex) {
                                FileSystemRenameAction.showError((Exception)((Object)ex));
                            }
                        }
                        case 2: {
                            text.dispose();
                            e.doit = true;
                            e.detail = 0;
                        }
                    }
                }
            };
            this.fTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileSystemRenameAction.this.fTree.removeSelectionListener((SelectionListener)this);
                    text.dispose();
                }
            });
            FocusAdapter listener = new FocusAdapter(){

                public void focusLost(FocusEvent fe) {
                    String newName = text.getText();
                    try {
                        FileSystemRenameAction.renameTo(fileStore, newName, null);
                        item.setText(newName);
                        FileSystemRenameAction.refresh(parentData);
                    }
                    catch (CoreException ex) {
                        FileSystemRenameAction.showError((Exception)((Object)ex));
                    }
                    text.dispose();
                }
            };
            text.addFocusListener((FocusListener)listener);
            text.addListener(31, textListener);
            text.setFocus();
        }
    }

    private static void refresh(Object element) {
        IOUIPlugin.refreshNavigatorView(element);
    }

    private static void showError(Exception exception) {
        UIUtils.showErrorMessage((String)exception.getLocalizedMessage(), (Throwable)exception);
    }

    private static void renameTo(IFileStore oldStore, String newName, IProgressMonitor monitor) throws CoreException {
        IFileStore parent = oldStore.getParent();
        if (parent == null) {
            return;
        }
        IFileStore newStore = parent.getChild(newName);
        oldStore.move(newStore, 0, monitor);
    }
}

