/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.aptana.ide.core.io.vfs.IExtendedFileInfo;
import com.aptana.ide.ui.UIUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.internal.Utils;
import com.aptana.ide.ui.io.navigator.actions.EditorUtils;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class NewFileAction
extends BaseSelectionListenerAction {
    private IAdaptable fSelectedElement;
    private IWorkbenchWindow fWindow;

    public NewFileAction(IWorkbenchWindow window) {
        super(Messages.NewFileAction_Text);
        this.fWindow = window;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.setToolTipText(Messages.NewFileAction_ToolTip);
    }

    public void run() {
        if (this.fSelectedElement == null) {
            return;
        }
        InputDialog input = new InputDialog(this.fWindow.getShell(), Messages.NewFileAction_InputTitle, Messages.NewFileAction_InputMessage, "", null);
        if (input.open() == 0) {
            this.createFile(input.getValue());
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object element;
        this.fSelectedElement = null;
        if (selection != null && !selection.isEmpty() && (element = selection.getFirstElement()) instanceof IAdaptable) {
            this.fSelectedElement = (IAdaptable)element;
        }
        return super.updateSelection(selection) && this.fSelectedElement != null;
    }

    private void createFile(final String filename) {
        final IFileStore fileStore = Utils.getFileStore(this.fSelectedElement);
        final IFileInfo fileInfo = Utils.getFileInfo(this.fSelectedElement);
        Job job = new Job(Messages.NewFolderAction_JobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IFileStore parentStore = fileStore;
                    IAdaptable element = NewFileAction.this.fSelectedElement;
                    if (!fileInfo.isDirectory() && fileStore.getParent() != null) {
                        parentStore = fileStore.getParent();
                        element = null;
                    }
                    IFileStore newFile = parentStore.getChild(filename);
                    OutputStream out = newFile.openOutputStream(0, monitor);
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                    IFileInfo newInfo = newFile.fetchInfo(0, monitor);
                    if (newInfo instanceof IExtendedFileInfo) {
                        IExtendedFileInfo extendedInfo = (IExtendedFileInfo)newInfo;
                        extendedInfo.setPermissions(PreferenceUtils.getFilePermissions());
                        newFile.putInfo((IFileInfo)extendedInfo, 65536, monitor);
                    }
                    EditorUtils.openFileInEditor(newFile);
                    IOUIPlugin.refreshNavigatorView(element);
                }
                catch (CoreException e) {
                    NewFileAction.this.showError((Exception)((Object)e));
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void showError(Exception exception) {
        UIUtils.showErrorMessage((String)exception.getLocalizedMessage(), (Throwable)exception);
    }
}

