/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.aptana.ide.core.io.vfs.IExtendedFileInfo;
import com.aptana.ide.ui.UIUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.internal.Utils;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class NewFolderAction
extends BaseSelectionListenerAction {
    private IAdaptable fSelectedElement;
    private IWorkbenchWindow fWindow;

    public NewFolderAction(IWorkbenchWindow window) {
        super(Messages.NewFolderAction_Text);
        this.fWindow = window;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        this.setToolTipText(Messages.NewFolderAction_ToolTip);
    }

    public void run() {
        if (this.fSelectedElement == null) {
            return;
        }
        final IFileStore fileStore = Utils.getFileStore(this.fSelectedElement);
        final IFileInfo fileInfo = Utils.getFileInfo(this.fSelectedElement);
        InputDialog input = new InputDialog(this.fWindow.getShell(), Messages.NewFolderAction_InputTitle, Messages.NewFolderAction_InputMessage, "", null);
        if (input.open() == 0) {
            final String name = input.getValue();
            Job job = new Job(Messages.NewFolderAction_JobTitle){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IFileStore parentStore = fileStore;
                        IAdaptable element = NewFolderAction.this.fSelectedElement;
                        if (!fileInfo.isDirectory() && fileStore.getParent() != null) {
                            parentStore = fileStore.getParent();
                            element = null;
                        }
                        IFileStore newFolder = parentStore.getChild(name);
                        newFolder.mkdir(0, monitor);
                        IFileInfo newInfo = newFolder.fetchInfo(0, monitor);
                        if (newInfo instanceof IExtendedFileInfo) {
                            IExtendedFileInfo extendedInfo = (IExtendedFileInfo)newInfo;
                            extendedInfo.setPermissions(PreferenceUtils.getDirectoryPermissions());
                            newFolder.putInfo((IFileInfo)extendedInfo, 65536, monitor);
                        }
                        IOUIPlugin.refreshNavigatorView(element);
                    }
                    catch (CoreException e) {
                        NewFolderAction.this.showError((Exception)((Object)e));
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object element;
        this.fSelectedElement = null;
        if (selection != null && !selection.isEmpty() && (element = selection.getFirstElement()) instanceof IAdaptable) {
            this.fSelectedElement = (IAdaptable)element;
        }
        return super.updateSelection(selection) && this.fSelectedElement != null;
    }

    private void showError(Exception exception) {
        UIUtils.showErrorMessage((String)exception.getLocalizedMessage(), (Throwable)exception);
    }
}

