/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.ui.io.internal.Utils;
import com.aptana.ide.ui.io.navigator.actions.EditorUtils;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenFileAction
extends BaseSelectionListenerAction {
    private List<IFileStore> fFileStores = new ArrayList<IFileStore>();

    public OpenFileAction() {
        super(Messages.OpenFileAction_Text);
    }

    public void run() {
        for (IFileStore fileStore : this.fFileStores) {
            EditorUtils.openFileInEditor(fileStore);
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.fFileStores.clear();
        if (selection != null && !selection.isEmpty()) {
            Object[] elements;
            Object[] objectArray = elements = selection.toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore fileStore;
                Object element = objectArray[n2];
                if (element instanceof IAdaptable && (fileStore = Utils.getFileStore((IAdaptable)element)) != null) {
                    this.fFileStores.add(fileStore);
                }
                ++n2;
            }
        }
        return super.updateSelection(selection) && this.fFileStores.size() > 0;
    }
}

