/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.ui.io.navigator.actions.Messages;
import com.aptana.ide.ui.io.navigator.actions.NewFileAction;
import com.aptana.ide.ui.io.navigator.actions.NewFolderAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class RemoteNewAction
extends BaseSelectionListenerAction {
    private IWorkbenchWindow fWindow;
    private MenuCreator fMenuCreator;

    public RemoteNewAction(IWorkbenchWindow window) {
        super(Messages.FileSystemNewAction_Text);
        this.fWindow = window;
        this.fMenuCreator = new MenuCreator();
        this.setMenuCreator(this.fMenuCreator);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.fMenuCreator.selectionChanged(selection);
        return super.updateSelection(selection);
    }

    private class MenuCreator
    implements IMenuCreator {
        private MenuManager dropDownMenuMgr;
        private NewFolderAction fNewFolderAction;
        private NewFileAction fNewFileAction;

        public MenuCreator() {
            this.fNewFolderAction = new NewFolderAction(RemoteNewAction.this.fWindow);
            this.fNewFileAction = new NewFileAction(RemoteNewAction.this.fWindow);
        }

        public void dispose() {
            if (this.dropDownMenuMgr != null) {
                this.dropDownMenuMgr.dispose();
                this.dropDownMenuMgr = null;
            }
        }

        public Menu getMenu(Control parent) {
            this.createDropDownMenuMgr();
            return this.dropDownMenuMgr.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            IContributionItem[] items;
            this.createDropDownMenuMgr();
            Menu menu = new Menu(parent);
            IContributionItem[] iContributionItemArray = items = this.dropDownMenuMgr.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem) {
                    item = new ActionContributionItem(((ActionContributionItem)item).getAction());
                }
                item.fill(menu, -1);
                ++n2;
            }
            return menu;
        }

        public void selectionChanged(IStructuredSelection selection) {
            this.fNewFolderAction.selectionChanged(selection);
            this.fNewFileAction.selectionChanged(selection);
        }

        private void createDropDownMenuMgr() {
            if (this.dropDownMenuMgr == null) {
                this.dropDownMenuMgr = new MenuManager();
                this.dropDownMenuMgr.add((IAction)this.fNewFolderAction);
                this.dropDownMenuMgr.add((IAction)this.fNewFileAction);
            }
        }
    }
}

