/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.preferences;

import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.aptana.ide.ui.io.preferences.Messages;
import com.aptana.ide.ui.io.preferences.PermissionsGroup;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class PermissionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private PermissionsGroup fFilePermissions;
    private PermissionsGroup fDirectoryPermissions;

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.aptana.ide.core.io");
        prefs.putLong("FilePermission", this.fFilePermissions.getPermissions());
        prefs.putLong("DirectoryPermission", this.fDirectoryPermissions.getPermissions());
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        Label label = new Label(main, 64);
        label.setText(Messages.PermissionPreferencePage_Notes);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fFilePermissions = new PermissionsGroup(main);
        this.fFilePermissions.setText(Messages.PermissionPreferencePage_FileGroupTitle);
        this.fFilePermissions.setPermissions(PreferenceUtils.getFilePermissions());
        this.fFilePermissions.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.fDirectoryPermissions = new PermissionsGroup(main);
        this.fDirectoryPermissions.setText(Messages.PermissionPreferencePage_DirectoryGroupTitle);
        this.fDirectoryPermissions.setPermissions(PreferenceUtils.getDirectoryPermissions());
        this.fDirectoryPermissions.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        return main;
    }

    protected void performDefaults() {
        this.fFilePermissions.setPermissions(438L);
        this.fDirectoryPermissions.setPermissions(511L);
        super.performDefaults();
    }
}

