/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.properties;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.aptana.ide.core.io.vfs.IExtendedFileInfo;
import com.aptana.ide.ui.UIUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.internal.Utils;
import com.aptana.ide.ui.io.preferences.PermissionsGroup;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class FileInfoPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final int MAX_VALUE_WIDTH = 80;
    private PermissionsGroup fPermissionsGroup;
    private IFileInfo fFileInfo;

    protected Control createContents(Composite parent) {
        IFileStore fileStore;
        block9: {
            fileStore = Utils.getFileStore(this.getElement());
            if (fileStore == null) {
                Label label = new Label(parent, 0);
                label.setText(IDEWorkbenchMessages.ResourceInfoPage_noResource);
                return label;
            }
            try {
                if (this.getElement().getAdapter(File.class) != null) {
                    this.fFileInfo = fileStore.fetchInfo(0, (IProgressMonitor)new NullProgressMonitor());
                    break block9;
                }
                final IFileInfo[] result = new IFileInfo[1];
                ProgressMonitorDialog dlg = new ProgressMonitorDialog(parent.getShell());
                try {
                    dlg.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                try {
                                    result[0] = fileStore.fetchInfo(1024, monitor);
                                }
                                catch (CoreException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    throw (CoreException)e.getTargetException();
                }
                catch (InterruptedException interruptedException) {}
                this.fFileInfo = result[0];
            }
            catch (CoreException e) {
                UIUtils.showErrorMessage((String)"Fetch info error", (Throwable)e);
            }
        }
        if (this.fFileInfo == null) {
            Label label = new Label(parent, 0);
            label.setText(IDEWorkbenchMessages.ResourceInfoPage_noResource);
            return label;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite basicInfo = this.createBasicInfoGroup(composite, fileStore, this.fFileInfo);
        basicInfo.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite state = this.createStateGroup(composite, fileStore, this.fFileInfo);
        state.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        if (this.fFileInfo instanceof IExtendedFileInfo) {
            IExtendedFileInfo extendedInfo = (IExtendedFileInfo)this.fFileInfo;
            Composite owner = this.createOwnerGroup(composite, extendedInfo);
            owner.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(0, 10).create());
            Composite permissions = this.createPermissionsGroup(composite, extendedInfo);
            permissions.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(0, 5).create());
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public boolean performOk() {
        IExtendedFileInfo extendedInfo;
        long permissions;
        if (this.fFileInfo != null && this.fFileInfo instanceof IExtendedFileInfo && (permissions = this.fPermissionsGroup.getPermissions()) != (extendedInfo = (IExtendedFileInfo)this.fFileInfo).getPermissions()) {
            extendedInfo.setPermissions(permissions);
            IFileStore fileStore = Utils.getFileStore(this.getElement());
            if (fileStore != null) {
                try {
                    fileStore.putInfo(this.fFileInfo, 65536, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    UIUtils.showErrorMessage((String)"Error storing file info", (Throwable)e);
                }
            }
        }
        return super.performOk();
    }

    protected void performDefaults() {
        if (this.fPermissionsGroup != null) {
            if (this.fFileInfo.isDirectory()) {
                this.fPermissionsGroup.setPermissions(PreferenceUtils.getDirectoryPermissions());
            } else {
                this.fPermissionsGroup.setPermissions(PreferenceUtils.getFilePermissions());
            }
        }
        super.performDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return IOUIPlugin.getDefault().getPreferenceStore();
    }

    private Composite createBasicInfoGroup(Composite parent, IFileStore fileStore, IFileInfo fileInfo) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).create());
        Label label = new Label(container, 0);
        label.setText(IDEWorkbenchMessages.ResourceInfo_path);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 128).create());
        Text pathText = new Text(container, 72);
        pathText.setText(fileStore.toURI().getPath());
        pathText.setBackground(pathText.getDisplay().getSystemColor(22));
        pathText.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).hint(this.convertWidthInCharsToPixels(80), -1).create());
        label = new Label(container, 16384);
        label.setText(IDEWorkbenchMessages.ResourceInfo_type);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 128).create());
        Text typeText = new Text(container, 16392);
        typeText.setText(fileInfo.isDirectory() ? "Folder" : "File");
        typeText.setBackground(typeText.getDisplay().getSystemColor(22));
        typeText.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label = new Label(container, 16384);
        label.setText(IDEWorkbenchMessages.ResourceInfo_location);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 128).create());
        Text locationText = new Text(container, 72);
        locationText.setText(fileStore.toString());
        locationText.setBackground(locationText.getDisplay().getSystemColor(22));
        locationText.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).hint(this.convertWidthInCharsToPixels(80), -1).create());
        if (!fileInfo.isDirectory()) {
            label = new Label(container, 16384);
            label.setText(IDEWorkbenchMessages.ResourceInfo_size);
            label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            Text sizeText = new Text(container, 16392);
            sizeText.setText(String.valueOf(Long.toString(fileInfo.getLength())) + " bytes");
            sizeText.setBackground(sizeText.getDisplay().getSystemColor(22));
            sizeText.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).hint(this.convertWidthInCharsToPixels(80), -1).create());
        }
        return container;
    }

    private Composite createStateGroup(Composite parent, IFileStore fileStore, IFileInfo fileInfo) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).create());
        Label timeStampLabel = new Label(container, 0);
        timeStampLabel.setText(IDEWorkbenchMessages.ResourceInfo_lastModified);
        Text timeStampText = new Text(container, 8);
        DateFormat format = DateFormat.getDateTimeInstance(1, 2);
        timeStampText.setText(format.format(new Date(fileInfo.getLastModified())));
        timeStampText.setBackground(timeStampText.getDisplay().getSystemColor(22));
        timeStampText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        return container;
    }

    private Composite createOwnerGroup(Composite parent, IExtendedFileInfo fileInfo) {
        Group container = new Group(parent, 0);
        container.setText("Owner and Group");
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).create());
        Label label = new Label((Composite)container, 0);
        label.setText(StringUtils.makeFormLabel((String)"Owner"));
        Text text = new Text((Composite)container, 8);
        text.setText(fileInfo.getOwner());
        text.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        label = new Label((Composite)container, 0);
        label.setText(StringUtils.makeFormLabel((String)"Group"));
        text = new Text((Composite)container, 8);
        text.setText(fileInfo.getGroup());
        text.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        return container;
    }

    private Composite createPermissionsGroup(Composite parent, IExtendedFileInfo fileInfo) {
        this.fPermissionsGroup = new PermissionsGroup(parent);
        this.fPermissionsGroup.setText("Permissions");
        this.fPermissionsGroup.setPermissions(fileInfo.getPermissions());
        return (Composite)this.fPermissionsGroup.getControl();
    }
}

