/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.resources.UniformResourceStorage;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.internal.ui.UniformResourceStorageEditorInput;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;

class UniformResourceStorageLocationProvider
implements ILocationProvider {
    private Map<IStorage, String> map = new Hashtable<IStorage, String>();

    UniformResourceStorageLocationProvider() {
    }

    public IPath getPath(Object element) {
        try {
            IStorage storage;
            if (element instanceof IStorageEditorInput && (storage = ((IStorageEditorInput)element).getStorage()) instanceof UniformResourceStorage) {
                File file;
                IPath path = ((UniformResourceStorage)storage).getFullPath();
                if (path != null) {
                    return path;
                }
                this.validateContents((UniformResourceStorage)storage, true);
                String filePath = this.map.get(storage);
                if (filePath == null && (file = this.getLocalFileForRemoteFileStorage((UniformResourceStorage)storage)) != null && file.exists()) {
                    filePath = file.toString();
                    this.map.put(storage, filePath);
                }
                if (filePath != null) {
                    return new Path(filePath);
                }
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
        return null;
    }

    public void validate(UniformResourceStorageEditorInput editorInput) {
        IStorage storage = editorInput.getStorage();
        IPath path = ((UniformResourceStorage)storage).getFullPath();
        if (path != null) {
            return;
        }
        String filePath = this.map.get(storage);
        if (filePath != null && !this.validateContents((UniformResourceStorage)storage, false)) {
            try {
                this.loadRemoteFileStorage((UniformResourceStorage)storage, new File(filePath));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (String)"", (Throwable)e);
            }
        }
    }

    private File getLocalFileForRemoteFileStorage(UniformResourceStorage storage) throws CoreException {
        File file = null;
        try {
            String name = storage.getName();
            if (name.length() < 3) {
                name = "file" + name;
            }
            if (this.loadRemoteFileStorage(storage, file = File.createTempFile(name, null))) {
                file.deleteOnExit();
                return file;
            }
        }
        catch (IOException iOException) {}
        if (file != null) {
            file.delete();
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadRemoteFileStorage(UniformResourceStorage storage, File file) throws CoreException {
        int n;
        InputStream in = storage.getContents();
        OutputStream out = null;
        if (!file.canWrite()) {
            file.delete();
        }
        out = new FileOutputStream(file);
        byte[] buffer = new byte[1024];
        while ((n = in.read(buffer)) > 0) {
            out.write(buffer, 0, n);
        }
        out.close();
        out = null;
        file.setReadOnly();
        if (out == null) return true;
        try {
            out.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException iOException) {
            try {
                if (out == null) return false;
            }
            catch (Throwable throwable) {
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                out.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    private boolean validateContents(UniformResourceStorage storage, boolean remove) {
        try {
            Method method = storage.getClass().getDeclaredMethod("isValid", new Class[0]);
            Boolean result = (Boolean)method.invoke((Object)storage, new Object[0]);
            if (remove && !result.booleanValue()) {
                this.map.remove(storage);
            }
            return result;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (String)"", (Throwable)e);
            return false;
        }
    }
}

