/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.launchConfigurations;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.EclipseUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.core.JSLaunchConfigurationHelper;
import com.aptana.ide.debug.internal.ui.ActiveResourcePathGetterAdapter;
import com.aptana.ide.debug.internal.ui.launchConfigurations.Messages;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.ui.ServerImagesRegistry;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class LaunchBrowserSettingsTab
extends AbstractLaunchConfigurationTab {
    private Listener dirtyListener;
    private Image image;
    private Text fBrowserExeText;
    private Text fCommandArgsText;
    private Button rbCurrentPage;
    private Button rbSpecificPage;
    private Button bSpecificPageBrowse;
    private Text fSpecificPageText;
    private Button rbStartUrl;
    private Text fStartUrlText;
    private Button rbInternalServer;
    private Button rbCustomServer;
    private Text fbaseUrlText;
    private Button fAddProjectName;
    private Button useServer;
    private Composite serverImage;
    private Label serverText;
    private ToolBar serversBar;
    private ToolItem selectedServer;
    private Menu serverMenu;
    private Image serverImg;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        this.dirtyListener = new Listener(){

            public void handleEvent(Event event) {
                LaunchBrowserSettingsTab.this.updateEnablement();
                LaunchBrowserSettingsTab.this.setDirty(true);
                LaunchBrowserSettingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.createBrowserSection(composite);
        this.createStartActionSection(composite);
        this.createServerSection(composite);
        this.hookListeners(true);
    }

    private void createBrowserSection(Composite parent) {
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.LaunchBrowserSettingsTab_WebBrowser);
        group.setFont(parent.getFont());
        GridData gData = new GridData(4, 4, true, false);
        gData.widthHint = 500;
        group.setLayoutData((Object)gData);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 3;
        layout.marginWidth *= 2;
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.LaunchBrowserSettingsTab_BrowserExecutable);
        GridData data = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.fBrowserExeText = new Text((Composite)group, 2052);
        data = new GridData(4, 0x1000000, true, false);
        this.fBrowserExeText.setLayoutData((Object)data);
        Button bBrowserExeBrowse = new Button((Composite)group, 8);
        bBrowserExeBrowse.setText(StringUtils.ellipsify((String)CoreStrings.BROWSE));
        data = new GridData(16384, 0x1000000, false, false);
        bBrowserExeBrowse.setLayoutData((Object)data);
        label = new Label((Composite)group, 0);
        label.setText(Messages.LaunchBrowserSettingsTab_Arguments);
        data = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.fCommandArgsText = new Text((Composite)group, 2052);
        data = new GridData(4, 0x1000000, true, false);
        this.fCommandArgsText.setLayoutData((Object)data);
        bBrowserExeBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text;
                FileDialog fileDialog = new FileDialog(LaunchBrowserSettingsTab.this.getShell(), 4096);
                fileDialog.setFileName(LaunchBrowserSettingsTab.this.fBrowserExeText.getText());
                if ("win32".equals(Platform.getOS())) {
                    fileDialog.setFilterExtensions(new String[]{"*.exe"});
                    fileDialog.setFilterNames(new String[]{Messages.LaunchBrowserSettingsTab_ExecutableFiles});
                }
                if ((text = fileDialog.open()) != null) {
                    LaunchBrowserSettingsTab.this.fBrowserExeText.setText(text);
                }
            }
        });
    }

    private void createStartActionSection(Composite parent) {
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.LaunchBrowserSettingsTab_StartAction);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 3;
        layout.marginWidth *= 2;
        group.setLayout((Layout)layout);
        this.rbCurrentPage = new Button((Composite)group, 16);
        this.rbCurrentPage.setText(Messages.LaunchBrowserSettingsTab_UseCurrentPage);
        GridData data = new GridData(16384, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.rbCurrentPage.setLayoutData((Object)data);
        this.rbSpecificPage = new Button((Composite)group, 16);
        this.rbSpecificPage.setText(Messages.LaunchBrowserSettingsTab_SpecificPage);
        data = new GridData(16384, 0x1000000, false, false);
        this.rbSpecificPage.setLayoutData((Object)data);
        this.fSpecificPageText = new Text((Composite)group, 2052);
        data = new GridData(4, 0x1000000, true, false);
        this.fSpecificPageText.setLayoutData((Object)data);
        this.bSpecificPageBrowse = new Button((Composite)group, 8);
        this.bSpecificPageBrowse.setText(StringUtils.ellipsify((String)CoreStrings.BROWSE));
        data = new GridData(16384, 0x1000000, false, false);
        this.bSpecificPageBrowse.setLayoutData((Object)data);
        this.rbStartUrl = new Button((Composite)group, 16);
        this.rbStartUrl.setText(Messages.LaunchBrowserSettingsTab_StartURL);
        data = new GridData(16384, 0x1000000, false, false);
        this.rbStartUrl.setLayoutData((Object)data);
        this.fStartUrlText = new Text((Composite)group, 2052);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        this.fStartUrlText.setLayoutData((Object)data);
        this.bSpecificPageBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource = LaunchBrowserSettingsTab.this.chooseWorkspaceLocation();
                if (resource != null) {
                    LaunchBrowserSettingsTab.this.fSpecificPageText.setText(resource.getFullPath().toPortableString());
                }
            }
        });
    }

    private void createServerSection(Composite parent) {
        Group group = new Group(parent, 0x800000);
        group.setText(Messages.LaunchBrowserSettingsTab_Server);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 3;
        layout.marginWidth *= 2;
        group.setLayout((Layout)layout);
        this.rbInternalServer = new Button((Composite)group, 16);
        this.rbInternalServer.setText(Messages.LaunchBrowserSettingsTab_UseBuiltInWebServer);
        GridData data = new GridData(4, 4, false, false);
        data.horizontalSpan = 2;
        this.rbInternalServer.setLayoutData((Object)data);
        this.rbCustomServer = new Button((Composite)group, 16);
        this.rbCustomServer.setText(Messages.LaunchBrowserSettingsTab_UseExternalWebServer);
        data = new GridData(4, 4, false, false);
        this.rbCustomServer.setLayoutData((Object)data);
        this.fbaseUrlText = new Text((Composite)group, 2052);
        data = new GridData(4, 4, true, false);
        this.fbaseUrlText.setLayoutData((Object)data);
        this.useServer = new Button((Composite)group, 16);
        this.useServer.setText(Messages.LaunchBrowserSettingsTab_Use_Selected_Server);
        GridData usData = new GridData(4, 4, false, false);
        this.useServer.setLayoutData((Object)usData);
        this.createServersViewSection((Composite)group);
        this.fAddProjectName = new Button((Composite)group, 32);
        this.fAddProjectName.setText(Messages.LaunchBrowserSettingsTab_AppendProjectName);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.fAddProjectName.setLayoutData((Object)data);
    }

    private void createServersViewSection(Composite parent) {
        final Composite serverComposite = new Composite(parent, 0);
        GridLayout scLayout = new GridLayout(2, false);
        scLayout.marginHeight = 0;
        scLayout.marginWidth = 0;
        scLayout.horizontalSpacing = 0;
        scLayout.verticalSpacing = 0;
        serverComposite.setLayout((Layout)scLayout);
        GridData scData = new GridData(4, 4, true, false);
        serverComposite.setLayoutData((Object)scData);
        final Composite inner = new Composite(serverComposite, 2048);
        inner.setBackground(inner.getDisplay().getSystemColor(1));
        GridLayout iLayout = new GridLayout(3, false);
        iLayout.marginHeight = 0;
        iLayout.marginWidth = 0;
        GridData iData = new GridData(4, 4, false, false);
        iData.widthHint = 200;
        inner.setLayout((Layout)iLayout);
        inner.setLayoutData((Object)iData);
        this.serverImage = new Composite(inner, 0);
        this.serverImage.setBackground(inner.getDisplay().getSystemColor(1));
        this.serverImage.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (LaunchBrowserSettingsTab.this.serverImg != null) {
                    e.gc.drawImage(LaunchBrowserSettingsTab.this.serverImg, 2, 2);
                }
            }
        });
        GridData siData = new GridData(4, 4, false, false);
        siData.heightHint = 16;
        siData.widthHint = 20;
        this.serverImage.setLayoutData((Object)siData);
        this.serverText = new Label(inner, 16384);
        this.serverText.setBackground(inner.getDisplay().getSystemColor(1));
        GridData stData = new GridData(4, 0x1000000, true, false);
        this.serverText.setLayoutData((Object)stData);
        this.serversBar = new ToolBar(inner, 0x800000);
        this.serversBar.setBackground(inner.getDisplay().getSystemColor(1));
        GridLayout sbLayout = new GridLayout(1, false);
        sbLayout.marginHeight = 0;
        sbLayout.marginWidth = 0;
        sbLayout.horizontalSpacing = 0;
        scLayout.verticalSpacing = 0;
        this.serversBar.setLayout((Layout)sbLayout);
        this.serversBar.setLayoutData((Object)new GridData(4, 4, false, false));
        this.selectedServer = new ToolItem(this.serversBar, 8);
        Image arrow = EclipseUtils.getArrowImage();
        this.selectedServer.setImage(arrow);
        this.serverMenu = new Menu((Control)serverComposite);
        this.selectedServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = inner.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = serverComposite.toDisplay(pt);
                LaunchBrowserSettingsTab.this.serverMenu.setLocation(pt.x, pt.y);
                LaunchBrowserSettingsTab.this.serverMenu.setVisible(true);
            }
        });
        IServer[] servers = ServerCore.getServerManager().getServers();
        int i = 0;
        while (i < servers.length) {
            final IServer curr = servers[i];
            if (curr.isWebServer()) {
                final MenuItem server = new MenuItem(this.serverMenu, 8);
                server.setText(curr.getName());
                Image img = ServerImagesRegistry.getInstance().getImage((Object)curr);
                if (img != null) {
                    server.setImage(img);
                }
                server.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        LaunchBrowserSettingsTab.this.serverText.setText(server.getText());
                        LaunchBrowserSettingsTab.this.serverText.setData((Object)curr);
                        LaunchBrowserSettingsTab.this.serverImg = server.getImage();
                        LaunchBrowserSettingsTab.this.serverImage.redraw();
                        LaunchBrowserSettingsTab.this.serverImage.update();
                        LaunchBrowserSettingsTab.this.updateEnablement();
                        LaunchBrowserSettingsTab.this.setDirty(true);
                        LaunchBrowserSettingsTab.this.updateLaunchConfigurationDialog();
                    }
                });
            }
            ++i;
        }
    }

    private void hookListeners(boolean hook) {
        if (hook) {
            this.fBrowserExeText.addListener(24, this.dirtyListener);
            this.fCommandArgsText.addListener(24, this.dirtyListener);
            this.fSpecificPageText.addListener(24, this.dirtyListener);
            this.fStartUrlText.addListener(24, this.dirtyListener);
            this.rbCurrentPage.addListener(13, this.dirtyListener);
            this.rbSpecificPage.addListener(13, this.dirtyListener);
            this.rbStartUrl.addListener(13, this.dirtyListener);
            this.fbaseUrlText.addListener(24, this.dirtyListener);
            this.rbInternalServer.addListener(13, this.dirtyListener);
            this.rbCustomServer.addListener(13, this.dirtyListener);
            this.fAddProjectName.addListener(13, this.dirtyListener);
            this.useServer.addListener(13, this.dirtyListener);
        } else {
            this.fBrowserExeText.removeListener(24, this.dirtyListener);
            this.fCommandArgsText.removeListener(24, this.dirtyListener);
            this.fSpecificPageText.removeListener(24, this.dirtyListener);
            this.fStartUrlText.removeListener(24, this.dirtyListener);
            this.rbCurrentPage.removeListener(13, this.dirtyListener);
            this.rbSpecificPage.removeListener(13, this.dirtyListener);
            this.rbStartUrl.removeListener(13, this.dirtyListener);
            this.fbaseUrlText.removeListener(24, this.dirtyListener);
            this.rbInternalServer.removeListener(13, this.dirtyListener);
            this.rbCustomServer.removeListener(13, this.dirtyListener);
            this.fAddProjectName.removeListener(13, this.dirtyListener);
            this.useServer.removeListener(13, this.dirtyListener);
        }
    }

    private void updateEnablement() {
        this.fSpecificPageText.setEnabled(this.rbSpecificPage.getSelection());
        this.bSpecificPageBrowse.setEnabled(this.rbSpecificPage.getSelection());
        this.fStartUrlText.setEnabled(this.rbStartUrl.getSelection());
        this.fbaseUrlText.setEnabled(this.rbCustomServer.getSelection());
        this.fAddProjectName.setEnabled(!(!this.rbCustomServer.getSelection() && !this.useServer.getSelection() || !this.rbCurrentPage.getSelection() && !this.rbSpecificPage.getSelection()));
        this.serversBar.setEnabled(this.useServer.getSelection());
        this.serverText.setEnabled(this.useServer.getSelection());
    }

    private IResource chooseWorkspaceLocation() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.setMessage(Messages.LaunchBrowserSettingsTab_ChooseFile);
        if (dialog.open() == 0) {
            return (IResource)dialog.getFirstResult();
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        JSLaunchConfigurationHelper.setBrowserDefaults((ILaunchConfigurationWorkingCopy)configuration, null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        block8: {
            this.hookListeners(false);
            try {
                try {
                    String serverID;
                    this.fBrowserExeText.setText(configuration.getAttribute("browserExecutable", ""));
                    this.fCommandArgsText.setText(configuration.getAttribute("browserCmdLine", ""));
                    int startActionType = configuration.getAttribute("startActionType", 1);
                    this.rbCurrentPage.setSelection(startActionType == 1);
                    this.rbSpecificPage.setSelection(startActionType == 2);
                    this.fSpecificPageText.setText(configuration.getAttribute("startPagePath", ""));
                    this.rbStartUrl.setSelection(startActionType == 3);
                    this.fStartUrlText.setText(configuration.getAttribute("startPageUrl", ""));
                    int serverType = configuration.getAttribute("serverType", 1);
                    this.rbInternalServer.setSelection(serverType == 1);
                    this.rbCustomServer.setSelection(serverType == 2);
                    this.fbaseUrlText.setText(configuration.getAttribute("externalBaseUrl", ""));
                    this.fAddProjectName.setSelection(configuration.getAttribute("appendProjectName", false));
                    this.useServer.setSelection(serverType == 3);
                    if (serverType != 3 || (serverID = configuration.getAttribute("serverName", "")).length() <= 0) break block8;
                    IServer[] servers = ServerCore.getServerManager().getServers();
                    int i = 0;
                    while (i < servers.length) {
                        IServer curr = servers[i];
                        if (curr.isWebServer() && curr.getId().equals(serverID)) {
                            this.serverText.setText(curr.getName());
                            this.serverText.setData((Object)curr);
                            Image img = ServerImagesRegistry.getInstance().getImage((Object)curr);
                            if (img != null) {
                                this.serverImg = img;
                                this.serverImage.redraw();
                                this.serverImage.update();
                            }
                            break;
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"Reading launch configuration fails", (Throwable)e);
                    this.hookListeners(true);
                    this.updateEnablement();
                }
            }
            finally {
                this.hookListeners(true);
                this.updateEnablement();
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String value = this.fBrowserExeText.getText();
        configuration.setAttribute("browserExecutable", value);
        value = this.fCommandArgsText.getText();
        configuration.setAttribute("browserCmdLine", value);
        int startActionType = 0;
        if (this.rbCurrentPage.getSelection()) {
            startActionType = 1;
        } else if (this.rbSpecificPage.getSelection()) {
            startActionType = 2;
        } else if (this.rbStartUrl.getSelection()) {
            startActionType = 3;
        }
        configuration.setAttribute("startActionType", startActionType);
        value = this.fSpecificPageText.getText();
        configuration.setAttribute("startPagePath", value);
        value = this.fStartUrlText.getText();
        configuration.setAttribute("startPageUrl", value);
        int serverType = 0;
        if (this.rbInternalServer.getSelection()) {
            serverType = 1;
        } else if (this.rbCustomServer.getSelection()) {
            serverType = 2;
        } else if (this.useServer.getSelection()) {
            serverType = 3;
        }
        configuration.setAttribute("serverType", serverType);
        value = this.fbaseUrlText.getText();
        configuration.setAttribute("externalBaseUrl", value);
        Object data = this.serverText.getData();
        if (data instanceof IServer) {
            configuration.setAttribute("serverName", ((IServer)data).getId());
        }
        configuration.setAttribute("appendProjectName", this.fAddProjectName.getSelection());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        Object data;
        IPath activeResource;
        this.setErrorMessage(null);
        this.setMessage(null);
        String value = this.fBrowserExeText.getText();
        if (!new File(value).exists()) {
            this.setErrorMessage(Messages.LaunchBrowserSettingsTab_BrowserExecutableShouldBeSpecified);
            return false;
        }
        if (this.rbSpecificPage.getSelection()) {
            value = this.fSpecificPageText.getText();
            if (value.length() == 0 || ResourcesPlugin.getWorkspace().getRoot().findMember(value) == null) {
                this.setErrorMessage(Messages.LaunchBrowserSettingsTab_StartPageShouldBeSpecified);
                return false;
            }
        } else if (this.rbStartUrl.getSelection()) {
            value = this.fStartUrlText.getText();
            try {
                new URL(value);
            }
            catch (MalformedURLException malformedURLException) {
                this.setErrorMessage(Messages.LaunchBrowserSettingsTab_ValidStartPageURLShouldBeSpecified);
                return false;
            }
        }
        if (this.rbCustomServer.getSelection()) {
            value = this.fbaseUrlText.getText();
            try {
                new URL(value);
            }
            catch (MalformedURLException malformedURLException) {
                this.setErrorMessage(Messages.LaunchBrowserSettingsTab_ValidBaseURLShouldBeSpecified);
                return false;
            }
        }
        if (this.rbCurrentPage.getSelection() && (activeResource = new ActiveResourcePathGetterAdapter().getActiveResourcePath()) == null) {
            this.setMessage(Messages.LaunchBrowserSettingsTab_NoFilesOpenedInEditor);
            return false;
        }
        if (this.useServer.getSelection() && ((data = this.serverText.getData()) == null || !(data instanceof IServer))) {
            this.setErrorMessage(Messages.LaunchBrowserSettingsTab_Server_Must_Be_Selected);
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.LaunchBrowserSettingsTab_Main;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = DebugUiPlugin.getImageDescriptor("icons/full/obj16/launch-main.gif").createImage();
        }
        return this.image;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }
}

