/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.preferences;

import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.internal.ui.preferences.Messages;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JSDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Preferences store = this.getPreferences();
    private Button suspendOnFirstLine;
    private Button suspendOnExceptions;
    private Button suspendOnErrors;
    private Button suspendOnDebuggerKeyword;
    private Button confirmExitDebugger;

    public JSDebugPreferencePage() {
    }

    public JSDebugPreferencePage(String title) {
        super(title);
    }

    public JSDebugPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Group debugGroup = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        debugGroup.setLayout((Layout)gridLayout);
        debugGroup.setLayoutData((Object)new GridData(768));
        debugGroup.setText(Messages.JSDebugPreferencePage_JavascriptDebugOptions);
        this.suspendOnFirstLine = new Button((Composite)debugGroup, 32);
        this.suspendOnFirstLine.setText(Messages.JSDebugPreferencePage_SuspendAtStart);
        this.suspendOnExceptions = new Button((Composite)debugGroup, 32);
        this.suspendOnExceptions.setText(Messages.JSDebugPreferencePage_SuspendOnExceptions);
        this.suspendOnErrors = new Button((Composite)debugGroup, 32);
        this.suspendOnErrors.setText(Messages.JSDebugPreferencePage_SuspendOnErrors);
        this.suspendOnDebuggerKeyword = new Button((Composite)debugGroup, 32);
        this.suspendOnDebuggerKeyword.setText(Messages.JSDebugPreferencePage_SuspendOnDebuggerKeyword);
        this.confirmExitDebugger = new Button(composite, 32);
        this.confirmExitDebugger.setText(Messages.JSDebugPreferencePage_ConfirmExitWhenDebuggerActive);
        this.setInitialValues();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.setDefaultValues();
    }

    public boolean performOk() {
        this.setValues();
        return super.performOk();
    }

    protected Preferences getPreferences() {
        return JSDebugPlugin.getDefault().getPluginPreferences();
    }

    private void setInitialValues() {
        this.suspendOnFirstLine.setSelection(this.store.getBoolean("com.aptana.ide.debug.core.suspend_on_first_line"));
        this.suspendOnExceptions.setSelection(this.store.getBoolean("com.aptana.ide.debug.core.suspend_on_exceptions"));
        this.suspendOnErrors.setSelection(this.store.getBoolean("com.aptana.ide.debug.core.suspend_on_errors"));
        this.suspendOnDebuggerKeyword.setSelection(this.store.getBoolean("com.aptana.ide.debug.core.suspend_on_debugger_keyword"));
        IPreferenceStore uiStore = DebugUiPlugin.getDefault().getPreferenceStore();
        if (!uiStore.contains("com.aptana.ide.debug.ui.confirm_exit_debugger")) {
            this.confirmExitDebugger.setSelection(true);
        } else {
            this.confirmExitDebugger.setSelection(uiStore.getBoolean("com.aptana.ide.debug.ui.confirm_exit_debugger"));
        }
    }

    private void setDefaultValues() {
        this.suspendOnFirstLine.setSelection(this.store.getDefaultBoolean("com.aptana.ide.debug.core.suspend_on_first_line"));
        this.suspendOnExceptions.setSelection(this.store.getDefaultBoolean("com.aptana.ide.debug.core.suspend_on_exceptions"));
        this.suspendOnErrors.setSelection(this.store.getDefaultBoolean("com.aptana.ide.debug.core.suspend_on_errors"));
        this.suspendOnDebuggerKeyword.setSelection(this.store.getDefaultBoolean("com.aptana.ide.debug.core.suspend_on_debugger_keyword"));
        IPreferenceStore uiStore = DebugUiPlugin.getDefault().getPreferenceStore();
        if (uiStore.contains("com.aptana.ide.debug.ui.confirm_exit_debugger")) {
            this.confirmExitDebugger.setSelection(uiStore.getDefaultBoolean("com.aptana.ide.debug.ui.confirm_exit_debugger"));
        } else {
            this.confirmExitDebugger.setSelection(true);
        }
    }

    private void setValues() {
        this.store.setValue("com.aptana.ide.debug.core.suspend_on_first_line", this.suspendOnFirstLine.getSelection());
        this.store.setValue("com.aptana.ide.debug.core.suspend_on_exceptions", this.suspendOnExceptions.getSelection());
        this.store.setValue("com.aptana.ide.debug.core.suspend_on_errors", this.suspendOnErrors.getSelection());
        this.store.setValue("com.aptana.ide.debug.core.suspend_on_debugger_keyword", this.suspendOnDebuggerKeyword.getSelection());
        JSDebugPlugin.getDefault().savePluginPreferences();
        IPreferenceStore uiStore = DebugUiPlugin.getDefault().getPreferenceStore();
        uiStore.setValue("com.aptana.ide.debug.ui.confirm_exit_debugger", this.confirmExitDebugger.getSelection());
        DebugUiPlugin.getDefault().savePluginPreferences();
    }
}

