/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.ui;

import com.aptana.ide.core.resources.UniformResourceStorage;
import com.aptana.ide.debug.core.model.IJSDebugTarget;
import com.aptana.ide.debug.internal.ui.DebugUIImages;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.BundleContext;

public class DebugUiPlugin
extends AbstractUIPlugin {
    public static final String ID = "com.aptana.ide.debug.ui";
    private static DebugUiPlugin plugin;
    private IDebugModelPresentation fUtilPresentation;
    private IDebugEventSetListener debugEventListener;

    public DebugUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (this.debugEventListener == null) {
            this.debugEventListener = new IDebugEventSetListener(){

                public void handleDebugEvents(DebugEvent[] events) {
                    int i = 0;
                    while (i < events.length) {
                        DebugEvent event = events[i];
                        if (event.getSource() instanceof IJSDebugTarget && event.getKind() == 8) {
                            WorkbenchJob job = new WorkbenchJob("Close Temporary Debug Editors"){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    DebugUiPlugin.this.closeDebugEditors();
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setPriority(10);
                            job.setSystem(true);
                            job.schedule();
                        }
                        ++i;
                    }
                }
            };
        }
        DebugPlugin.getDefault().addDebugEventListener(this.debugEventListener);
    }

    public void stop(BundleContext context) throws Exception {
        DebugPlugin.getDefault().removeDebugEventListener(this.debugEventListener);
        super.stop(context);
        plugin = null;
    }

    public static DebugUiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    protected ImageRegistry createImageRegistry() {
        return DebugUIImages.getImageRegistry();
    }

    public static void log(IStatus status) {
        DebugUiPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        Status status = new Status(4, ID, 0, "Error", t);
        DebugUiPlugin.log((IStatus)status);
    }

    public static String getUniqueIdentifier() {
        return ID;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return DebugUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = DebugUiPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = DebugUiPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void errorDialog(String message, Throwable t) {
        DebugUiPlugin.log(t);
        Shell shell = DebugUiPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, DebugUiPlugin.getUniqueIdentifier(), 4, "Error logged from Aptana Debug UI: ", t);
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)message, (IStatus)status);
        }
    }

    public IDebugModelPresentation getModelPresentation() {
        if (this.fUtilPresentation == null) {
            this.fUtilPresentation = DebugUITools.newDebugModelPresentation((String)"com.aptana.ide.debug.core");
        }
        return this.fUtilPresentation;
    }

    private void closeDebugEditors() {
        IWorkbenchPage page = DebugUiPlugin.getActivePage();
        if (page != null) {
            IEditorReference[] editorRefs = page.getEditorReferences();
            ArrayList<IEditorReference> closeEditors = new ArrayList<IEditorReference>();
            int i = 0;
            while (i < editorRefs.length) {
                try {
                    URI uri;
                    IEditorInput input = editorRefs[i].getEditorInput();
                    UniformResourceStorage storage = (UniformResourceStorage)input.getAdapter(UniformResourceStorage.class);
                    if (storage != null && "dbgsource".equals((uri = storage.getURI()).getScheme())) {
                        closeEditors.add(editorRefs[i]);
                    }
                }
                catch (PartInitException e) {
                    DebugUiPlugin.log(e.getStatus());
                }
                ++i;
            }
            if (!closeEditors.isEmpty()) {
                page.closeEditors(closeEditors.toArray(new IEditorReference[closeEditors.size()]), false);
            }
        }
    }
}

