/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.Trace;
import com.aptana.ide.scripting.Messages;
import com.aptana.ide.scripting.ScriptingEngine;
import com.aptana.ide.scripting.ScriptingPlugin;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Plugin;

public final class FileUtilities {
    private FileUtilities() {
    }

    public static File createDirectory(String parentDirectory, String directoryName) {
        File newDirectory = new File(String.valueOf(parentDirectory) + File.separator + directoryName);
        if (!newDirectory.exists()) {
            newDirectory.mkdir();
        }
        return newDirectory;
    }

    public static String appendPaths(String parentDirectory, String directoryName) {
        if (parentDirectory.endsWith(File.separator)) {
            return String.valueOf(parentDirectory) + directoryName;
        }
        return String.valueOf(parentDirectory) + File.separator + directoryName;
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static boolean directoryExists(String parentDirectory, String directoryName) {
        return FileUtilities.fileExists(parentDirectory, directoryName);
    }

    public static boolean fileExists(String parentDirectory, String filename) {
        return new File(String.valueOf(parentDirectory) + File.separator + filename).exists();
    }

    public static boolean fileExists(String filename) {
        return new File(filename).exists();
    }

    public static String getResourceText(String name) {
        InputStream stream = ScriptingEngine.class.getResourceAsStream(name);
        return FileUtilities.getStreamText(stream);
    }

    public static void extractFiles(String zipFilePath, String destinationDirectory, String prefix) {
        if (zipFilePath == null || zipFilePath.length() == 0) {
            throw new IllegalArgumentException(Messages.FileUtilities_Zip_File_Path_Undefined);
        }
        if (destinationDirectory == null || destinationDirectory.length() == 0) {
            throw new IllegalArgumentException(Messages.FileUtilities_Destination_Directory_Undefined);
        }
        if (prefix == null || prefix.length() == 0) {
            throw new IllegalArgumentException(Messages.FileUtilities_Prefix_Undefined);
        }
        try {
            ZipFile zipFile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.startsWith(prefix)) continue;
                entryName = entryName.substring(prefix.length());
                String endPath = FileUtilities.appendPaths(destinationDirectory, entryName);
                if (entry.isDirectory()) {
                    File newDir = new File(endPath);
                    newDir.mkdir();
                    continue;
                }
                FileUtilities.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(endPath)));
                String message = StringUtils.format((String)Messages.FileUtilities_Extracted_File, (String)new File(endPath).getName());
                Trace.info((String)message);
            }
            zipFile.close();
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.FileUtilities_Error, (Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCRC(File file) {
        FilterInputStream input = null;
        String result = null;
        try {
            try {
                input = new DataInputStream(new FileInputStream(file));
                CRC32 crc = new CRC32();
                byte[] data = new byte[(int)file.length()];
                crc.update(((DataInputStream)input).read(data));
                result = String.valueOf(crc.getValue());
                return result;
            }
            catch (FileNotFoundException e) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.FileUtilities_Error, (Throwable)e);
                if (input == null) return result;
                try {
                    input.close();
                    return result;
                }
                catch (IOException e2) {
                    IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.FileUtilities_Error, (Throwable)e2);
                }
                return result;
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.FileUtilities_Error, (Throwable)e);
                if (input == null) return result;
                try {
                    input.close();
                    return result;
                }
                catch (IOException e3) {
                    IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.FileUtilities_Error, (Throwable)e3);
                }
                return result;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.FileUtilities_Error, (Throwable)e);
                }
            }
        }
    }

    public static String getStreamText(InputStream stream) {
        try {
            StringWriter sw = new StringWriter();
            try {
                InputStreamReader isr = new InputStreamReader(stream);
                BufferedReader reader = new BufferedReader(isr);
                char[] buf = new char[1024];
                int numRead = reader.read(buf);
                while (numRead != -1) {
                    sw.write(buf, 0, numRead);
                    numRead = reader.read(buf);
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            return sw.toString();
        }
        catch (Exception e) {
            if (!(e instanceof InterruptedException)) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.FileUtilities_Error, (Throwable)e);
            }
            return null;
        }
    }
}

