/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.xml.XMLPlugin;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.preferences.IPreferenceConstants;
import com.aptana.ide.editors.views.actions.ActionsViewEventTypes;
import com.aptana.ide.editors.views.profiles.ProfilesViewEventTypes;
import com.aptana.ide.scripting.FileUtilities;
import com.aptana.ide.scripting.Messages;
import com.aptana.ide.scripting.ScriptClassLoader;
import com.aptana.ide.scripting.ScriptInfo;
import com.aptana.ide.scripting.ScriptThread;
import com.aptana.ide.scripting.ScriptingEngine;
import com.aptana.ide.scripting.ScriptingPlugin;
import com.aptana.ide.scripting.editors.Editors;
import com.aptana.ide.scripting.editors.Region;
import com.aptana.ide.scripting.io.File;
import com.aptana.ide.scripting.io.PrintStream;
import com.aptana.ide.scripting.io.WebRequest;
import com.aptana.ide.scripting.menus.Menus;
import com.aptana.ide.scripting.parsing.CSSTokenTypes;
import com.aptana.ide.scripting.parsing.HTMLTokenTypes;
import com.aptana.ide.scripting.parsing.JSTokenTypes;
import com.aptana.ide.scripting.parsing.ScriptDocTokenTypes;
import com.aptana.ide.scripting.parsing.TokenCategories;
import com.aptana.ide.scripting.parsing.XMLTokenTypes;
import com.aptana.ide.scripting.swt.Button;
import com.aptana.ide.scripting.swt.Label;
import com.aptana.ide.scripting.swt.Shell;
import com.aptana.ide.scripting.swt.Text;
import com.aptana.ide.scripting.views.Views;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Global
extends ScriptableObject {
    private static final long serialVersionUID = 1996593475808707552L;
    private static int scriptIndex = 0;
    public static final String idPropertyName = "__sid__";
    private Menus _menus;
    private Editors _editors;
    private Views _views;
    private PrintStream _err;
    private HashMap _scriptInfo = new HashMap();
    private HashMap _idXref = new HashMap();
    private HashMap _runningSetTimeouts = new HashMap();
    private int _setTimeoutIndex;

    public String getClassName() {
        return "Global";
    }

    public Global(Context cx) {
        this._menus = new Menus((Scriptable)this);
        this._editors = new Editors((Scriptable)this);
        this._views = new Views((Scriptable)this);
        this._err = new PrintStream((Scriptable)this, System.err);
        cx.initStandardObjects((ScriptableObject)this, false);
        String[] names = new String[]{"alert", "clearTimeout", "confirm", "execute", "getPreference", "getProperty", "include", "loadBundle", "loadLibrary", "parseXML", "prompt", "reloadLibrary", "runOnUIThread", "setPreference", "setTimeout", "share"};
        this.defineFunctionProperties(names, Global.class, 5);
        this.defineProperty("global", (Object)this, 5);
        this.defineProperty("editors", (Object)this._editors, 5);
        this.defineProperty("window", (Object)this, 5);
        this.defineProperty("menus", (Object)this._menus, 5);
        this.defineProperty("views", this._views, 5);
        MessageConsoleStream stream = ScriptingEngine.getInstance().getConsoleStream();
        this.defineProperty("err", (Object)this._err, 5);
        this.defineProperty("out", stream, 5);
        this.defineProperty("TokenCategories", (Object)new TokenCategories((Scriptable)this), 5);
        this.defineProperty("CSSTokenTypes", (Object)new CSSTokenTypes((Scriptable)this), 5);
        this.defineProperty("HTMLTokenTypes", (Object)new HTMLTokenTypes((Scriptable)this), 5);
        this.defineProperty("JSTokenTypes", (Object)new JSTokenTypes((Scriptable)this), 5);
        this.defineProperty("ScriptDocTokenTypes", (Object)new ScriptDocTokenTypes((Scriptable)this), 5);
        this.defineProperty("XMLTokenTypes", (Object)new XMLTokenTypes((Scriptable)this), 5);
        this.defineProperty("IPreferenceConstants", new IPreferenceConstants(){}, 5);
        this.defineProperty("ProfilesViewEventTypes", new ProfilesViewEventTypes(), 5);
        this.defineProperty("ActionsViewEventTypes", new ActionsViewEventTypes(), 5);
        this.defineProperty("SWT", new SWT(), 5);
        this.defineProperty("GridData", new GridData(), 5);
        try {
            ScriptableObject.defineClass((Scriptable)this, File.class);
            ScriptableObject.defineClass((Scriptable)this, WebRequest.class);
            ScriptableObject.defineClass((Scriptable)this, Region.class);
            ScriptableObject.defineClass((Scriptable)this, Shell.class);
            ScriptableObject.defineClass((Scriptable)this, Button.class);
            ScriptableObject.defineClass((Scriptable)this, Text.class);
            ScriptableObject.defineClass((Scriptable)this, Label.class);
        }
        catch (IllegalAccessException e) {
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Global_Error, (Throwable)e);
        }
        catch (InstantiationException e) {
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Global_Error, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Global_Error, (Throwable)e);
        }
    }

    public static Scriptable execute(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Scriptable result = null;
        if (args.length > 0) {
            String command = args[0].toString();
            String input = "";
            if (args.length > 1) {
                input = args[1].toString();
            }
            Process p = null;
            int retCode = 0;
            String stdout = "";
            String stderr = "";
            try {
                p = Runtime.getRuntime().exec(command);
                p.getOutputStream().write(input.getBytes());
                p.getOutputStream().flush();
                p.getOutputStream().close();
                retCode = p.waitFor();
                stdout = Global.getText(p.getInputStream());
                stderr = Global.getText(p.getErrorStream());
            }
            catch (IOException iOException) {
                if (p != null) {
                    retCode = p.exitValue();
                }
            }
            catch (InterruptedException e) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Global_Error, (Throwable)e);
            }
            Scriptable scope = ScriptableObject.getTopLevelScope((Scriptable)thisObj);
            result = cx.newObject(scope, "Object");
            result.put("code", result, (Object)new Integer(retCode));
            result.put("stdout", result, (Object)stdout);
            result.put("stderr", result, (Object)stderr);
        }
        return result;
    }

    public void share(ScriptableObject obj) {
        if (obj != null) {
            Object[] ids = obj.getIds();
            int i = 0;
            while (i < ids.length) {
                Object id = ids[i];
                if (id instanceof String) {
                    String propertyName = (String)id;
                    this.put(propertyName, (Scriptable)this, obj.get(propertyName, (Scriptable)obj));
                }
                ++i;
            }
        }
    }

    public static void runOnUIThread(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length > 0 && args[0] instanceof Function) {
            Function f = (Function)args[0];
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.syncExec((Runnable)new ScriptThread(f.getParentScope(), f, new Object[0]));
        }
    }

    public static void runOnUIThreadAsync(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length > 0 && args[0] instanceof Function) {
            Function f = (Function)args[0];
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.asyncExec((Runnable)new ScriptThread(f.getParentScope(), f, new Object[0]));
        }
    }

    public Document parseXML(String xml) {
        Document result = null;
        if (xml != null && xml.length() > 0) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                result = builder.parse(in);
            }
            catch (ParserConfigurationException e) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Global_Error, (Throwable)e);
            }
            catch (SAXException e) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Global_Error, (Throwable)e);
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Global_Error, (Throwable)e);
            }
        }
        return result;
    }

    public String[] getScriptIds() {
        Set keySet = this._scriptInfo.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public ScriptInfo getScriptInfo(String id) {
        ScriptInfo result = null;
        if (this._scriptInfo.containsKey(id)) {
            result = (ScriptInfo)this._scriptInfo.get(id);
        }
        return result;
    }

    public boolean hasScriptInfo(String id) {
        return this._scriptInfo.containsKey(id);
    }

    protected static String getText(InputStream stream) throws IOException {
        StringWriter sw = new StringWriter();
        try {
            InputStreamReader isr = new InputStreamReader(stream);
            BufferedReader reader = new BufferedReader(isr);
            char[] buf = new char[1024];
            int numRead = reader.read(buf);
            while (numRead != -1) {
                sw.write(buf, 0, numRead);
                numRead = reader.read(buf);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return sw.toString();
    }

    public void shutdown() {
        this._scriptInfo.clear();
    }

    public void alert(final String message) {
        final Display currentDisplay = Display.getCurrent();
        if (currentDisplay != null) {
            currentDisplay.syncExec(new Runnable(){

                public void run() {
                    org.eclipse.swt.widgets.Shell shell = currentDisplay.getActiveShell();
                    if (shell != null) {
                        MessageDialog.openWarning((org.eclipse.swt.widgets.Shell)shell, (String)"Aptana Studio", (String)message);
                    }
                }
            });
        }
    }

    public boolean confirm(final String message) {
        class Answer {
            public boolean result = false;

            Answer() {
            }
        }
        final Answer a = new Answer();
        final Display currentDisplay = Display.getCurrent();
        if (currentDisplay != null) {
            currentDisplay.syncExec(new Runnable(){
                {
                }

                public void run() {
                    org.eclipse.swt.widgets.Shell shell = currentDisplay.getActiveShell();
                    if (shell != null) {
                        a.result = MessageDialog.openConfirm((org.eclipse.swt.widgets.Shell)shell, (String)"Aptana Studio", (String)message);
                    }
                }
            });
        }
        return a.result;
    }

    public static Object prompt(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        final Display currentDisplay = Display.getCurrent();
        String messageArg = Messages.Global_Prompt;
        String defaultValueArg = "";
        if (args.length > 0) {
            messageArg = Context.toString((Object)args[0]);
        }
        if (args.length > 1) {
            defaultValueArg = Context.toString((Object)args[1]);
        }
        final String message = messageArg;
        final String defaultValue = defaultValueArg;
        class Answer {
            public Object result = "";

            Answer() {
            }
        }
        final Answer a = new Answer();
        if (currentDisplay != null) {
            currentDisplay.syncExec(new Runnable(){
                {
                }

                public void run() {
                    org.eclipse.swt.widgets.Shell shell = currentDisplay.getActiveShell();
                    if (shell != null) {
                        InputDialog dialog = new InputDialog(null, "Aptana Prompt", message, defaultValue, null);
                        int dialogResult = dialog.open();
                        a.result = dialogResult == 0 ? dialog.getValue() : Context.getUndefinedValue();
                    }
                }
            });
        }
        return a.result;
    }

    public String getProperty(String property) {
        String result = null;
        if (property != null && property.length() > 0) {
            result = System.getProperty(property, "undefined");
        }
        return result;
    }

    public static String getPreference(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String result = "";
        if (args.length > 0) {
            IPreferenceStore prefStore;
            String name = Context.toString((Object)args[0]);
            int pluginIndex = 0;
            if (args.length > 1) {
                pluginIndex = (int)Context.toNumber((Object)args[1]);
            }
            switch (pluginIndex) {
                case 1: {
                    prefStore = CSSPlugin.getDefault().getPreferenceStore();
                    break;
                }
                case 2: {
                    prefStore = HTMLPlugin.getDefault().getPreferenceStore();
                    break;
                }
                case 3: {
                    prefStore = JSPlugin.getDefault().getPreferenceStore();
                    break;
                }
                case 4: {
                    prefStore = XMLPlugin.getDefault().getPreferenceStore();
                    break;
                }
                default: {
                    prefStore = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
                }
            }
            result = prefStore.getString(name);
        }
        return result;
    }

    public void setPreference(String name, String value) {
        if (name != null && name.length() > 0 && value != null && value.length() > 0) {
            IPreferenceStore prefStore = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
            prefStore.setValue(name, value);
            UnifiedEditorsPlugin.getDefault().savePluginPreferences();
        }
    }

    public static void include(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length > 0) {
            String id = Context.toString((Object)thisObj.get(idPropertyName, thisObj.getParentScope()));
            Global global = (Global)funObj.getParentScope();
            ScriptInfo info = global.getScriptInfo(id);
            String libraryName = Context.toString((Object)args[0]);
            java.io.File library = new java.io.File(libraryName);
            if (!library.exists()) {
                java.io.File parent = info.getFile().getParentFile();
                String name = String.valueOf(parent.getAbsolutePath()) + java.io.File.separator + libraryName;
                library = new java.io.File(name);
            }
            if (library.exists()) {
                try {
                    String source = FileUtilities.getStreamText(new FileInputStream(library));
                    Scriptable scope = info.getScope();
                    Script script = cx.compileString(source, library.getAbsolutePath(), 1, null);
                    script.exec(cx, scope);
                }
                catch (FileNotFoundException e) {
                    IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Global_Error, (Throwable)e);
                }
            } else {
                String message = StringUtils.format((String)Messages.Global_Cannot_Locate_File, (Object[])new Object[]{info.getFile().getAbsolutePath(), libraryName});
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message);
            }
        } else {
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Global_Filename_Not_Defined);
        }
    }

    public static void loadBundle(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length > 0) {
            String id = Context.toString((Object)thisObj.get(idPropertyName, thisObj.getParentScope()));
            Global global = (Global)funObj.getParentScope();
            ScriptInfo info = global.getScriptInfo(id);
            String bundleName = Context.toString((Object)args[0]);
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                throw new RuntimeException(String.valueOf(Messages.Global_Bundle_Not_Found) + bundleName);
            }
            ScriptClassLoader classLoader = info.getClassLoader();
            classLoader.addBundle(bundle);
        }
    }

    public static Object loadLibrary(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object result = null;
        if (args.length > 0) {
            Global instance = ScriptingEngine.getInstance().getGlobal();
            String libraryPath = Context.toString((Object)args[0]);
            String onLoadFunction = args.length > 1 ? Context.toString((Object)args[1]) : "onload";
            try {
                String source = FileUtilities.getStreamText(new FileInputStream(libraryPath));
                Script script = cx.compileString(source, libraryPath, 1, null);
                Scriptable scope = cx.newObject((Scriptable)instance);
                scope.setPrototype((Scriptable)instance);
                scope.setParentScope(null);
                String id = instance.storeScriptState(libraryPath, script, scope);
                scope.put("location", scope, (Object)libraryPath);
                Context.toBoolean((Object)script.exec(cx, scope));
                Object fObj = scope.get(onLoadFunction, scope);
                if (fObj instanceof Function) {
                    Function f = (Function)fObj;
                    ScriptInfo info = instance.getScriptInfo(id);
                    ClassLoader oldClassLoader = cx.getApplicationClassLoader();
                    cx.setApplicationClassLoader((ClassLoader)info.getClassLoader());
                    try {
                        f.call(cx, scope, scope, new Object[0]);
                    }
                    catch (Exception exception) {
                        cx.setApplicationClassLoader(oldClassLoader);
                    }
                } else {
                    IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)(String.valueOf(onLoadFunction) + Messages.Global_Function_Does_Not_Exist + libraryPath));
                }
                result = scope;
            }
            catch (FileNotFoundException e) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Global_Error, (Throwable)e);
            }
        }
        if (result == null) {
            result = Context.getUndefinedValue();
        }
        return result;
    }

    public void reloadLibrary(String filename) {
        String key;
        ScriptInfo info;
        Scriptable scope;
        Object onunload;
        if (filename != null && filename.length() > 0 && (onunload = (scope = (info = this.getScriptInfo(key = this.getXrefId(filename))).getScope()).get("onunload", scope)) instanceof Function) {
            Function unloadFunction = (Function)onunload;
            Context cx = Context.enter();
            try {
                unloadFunction.call(cx, scope, scope, new Object[0]);
                this.removeScriptInfo(key);
                this.removeXrefId(filename);
                Global.loadLibrary(cx, (Scriptable)this, new Object[]{filename, "onload"}, null);
            }
            catch (Exception e1) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Global_Error, (Throwable)e1);
            }
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTimeout(int timeoutId) {
        HashMap hashMap = this._runningSetTimeouts;
        synchronized (hashMap) {
            Integer id = new Integer(timeoutId);
            if (this._runningSetTimeouts.containsKey(id)) {
                this._runningSetTimeouts.remove(id);
            }
        }
    }

    public int setTimeout(final Function f, final int timeout) {
        final Global self = this;
        final int timeoutIndex = self._setTimeoutIndex++;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean active = true;
                try {
                    Thread.sleep(timeout);
                    HashMap hashMap = self._runningSetTimeouts;
                    synchronized (hashMap) {
                        active = self._runningSetTimeouts.containsKey(new Integer(timeoutIndex));
                    }
                    if (active) {
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        if (workbench == null) {
                            return;
                        }
                        Display display = workbench.getDisplay();
                        if (display == null || display.isDisposed()) {
                            return;
                        }
                        display.asyncExec(new Runnable(){

                            public void run() {
                                Scriptable scope = f.getParentScope();
                                Context cx = Context.enter();
                                f.call(cx, scope, scope, new Object[0]);
                                Context.exit();
                                self.clearTimeout(timeoutIndex);
                            }
                        });
                    }
                }
                catch (InterruptedException e) {
                    IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.Global_Error, (Throwable)e);
                }
            }
        }, "Aptana: Script setTimeout");
        this._runningSetTimeouts.put(new Integer(timeoutIndex), thread);
        thread.setDaemon(true);
        thread.start();
        return timeoutIndex;
    }

    public void removeScriptInfo(String id) {
        if (this._scriptInfo.containsKey(id)) {
            this._scriptInfo.remove(id);
        }
    }

    public synchronized String storeScriptState(String uri, Script script, Scriptable scope) {
        String id = "_" + ++scriptIndex + "_";
        ScriptableObject.defineProperty((Scriptable)scope, (String)idPropertyName, (Object)id, (int)3);
        ScriptInfo info = new ScriptInfo(script, id, new java.io.File(uri), scope);
        this._scriptInfo.put(id, info);
        this._idXref.put(uri, id);
        return id;
    }

    public String getXrefId(String path) {
        String result = null;
        if (this._idXref.containsKey(path)) {
            result = (String)this._idXref.get(path);
        }
        return result;
    }

    public void removeXrefId(String path) {
        if (this._idXref.containsKey(path)) {
            this._idXref.remove(path);
        }
    }

    public Editors getEditors() {
        return this._editors;
    }

    public Menus getMenus() {
        return this._menus;
    }

    public Views getViews() {
        return this._views;
    }
}

