/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.scripting.Messages;
import com.aptana.ide.scripting.ScriptClassLoader;
import com.aptana.ide.scripting.ScriptingPlugin;
import org.eclipse.core.runtime.Plugin;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class ScriptThread
implements Runnable {
    private Scriptable _scope;
    private Object[] _args;
    private Object _callback;
    private Object _result;
    private ScriptClassLoader _classLoader;

    public Object getResult() {
        return this._result;
    }

    public ScriptThread(Scriptable scope, Object callback, Object[] args) {
        this(scope, callback, args, null);
    }

    public ScriptThread(Scriptable scope, Object callback, Object[] args, ScriptClassLoader classLoader) {
        this._scope = scope;
        this._callback = callback;
        this._args = args;
        this._classLoader = classLoader;
    }

    public void run() {
        block9: {
            Context cx = Context.enter();
            try {
                if (this._callback instanceof Function) {
                    ClassLoader oldClassLoader = null;
                    if (this._classLoader != null) {
                        oldClassLoader = cx.getApplicationClassLoader();
                        cx.setApplicationClassLoader((ClassLoader)this._classLoader);
                    }
                    Function f = (Function)this._callback;
                    try {
                        this._result = f.call(cx, this._scope, this._scope, this._args);
                        break block9;
                    }
                    finally {
                        if (this._classLoader != null) {
                            cx.setApplicationClassLoader(oldClassLoader);
                        }
                    }
                }
                String message = StringUtils.format((String)Messages.ScriptThread_Callback_Does_Not_Exist, (Object)this._callback);
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message);
                return;
            }
            finally {
                Context.exit();
            }
        }
    }
}

