/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting.views;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.profiles.Profile;
import com.aptana.ide.editors.views.profiles.IProfilesViewEventListener;
import com.aptana.ide.editors.views.profiles.ProfilesViewEvent;
import com.aptana.ide.scripting.events.Event;
import com.aptana.ide.scripting.events.ProfilesAddCurrentEvent;
import com.aptana.ide.scripting.events.ProfilesAddDropEvent;
import com.aptana.ide.scripting.events.ProfilesAddProfileEvent;
import com.aptana.ide.scripting.events.ProfilesDeleteEvent;
import com.aptana.ide.scripting.events.ProfilesDeleteProfileEvent;
import com.aptana.ide.scripting.events.ProfilesLinkStateChangedEvent;
import com.aptana.ide.scripting.events.ProfilesMakeCurrentEvent;
import com.aptana.ide.scripting.events.ProfilesMakeStaticEvent;
import com.aptana.ide.scripting.events.ProfilesMoveDownEvent;
import com.aptana.ide.scripting.events.ProfilesMoveUpEvent;
import com.aptana.ide.scripting.events.ProfilesOpenProfileEvent;
import com.aptana.ide.scripting.views.View;
import org.eclipse.ui.IWorkbenchPart;
import org.mozilla.javascript.Scriptable;

public class ProfilesView
extends View
implements IProfilesViewEventListener {
    private static final long serialVersionUID = -8939508057673096880L;

    public ProfilesView(Scriptable scope, IWorkbenchPart view) {
        super(scope, view);
        this.defineProperty("currentProfile", ProfilesView.class, 4);
        this.defineProperty("isLinked", ProfilesView.class, 5);
        this.defineProperty("profiles", ProfilesView.class, 5);
        String[] names = new String[]{"addProfile", "createProfile", "createDynamicProfile", "expandAll", "expandProfile", "getPathFromURI", "getProfile", "getProfilePaths", "getProfiles", "getURIFromPath", "removeProfile"};
        this.defineFunctionProperties(names, ProfilesView.class, 5);
        if (view != null && view instanceof com.aptana.ide.editors.views.profiles.ProfilesView) {
            com.aptana.ide.editors.views.profiles.ProfilesView profileView = (com.aptana.ide.editors.views.profiles.ProfilesView)view;
            profileView.addProfilesViewEventListener((IProfilesViewEventListener)this);
        }
    }

    public void onProfilesViewEvent(ProfilesViewEvent e) {
        Event event = null;
        int eventType = e.getEventType();
        switch (eventType) {
            case 1: 
            case 2: {
                event = new ProfilesAddDropEvent(this.getView(), eventType, e.getProfile(), e.getURIs());
                break;
            }
            case 4: {
                event = new ProfilesAddProfileEvent(this.getView(), eventType, e.getProfile());
                break;
            }
            case 6: {
                event = new ProfilesDeleteProfileEvent(this.getView(), eventType, e.getProfile());
                break;
            }
            case 0: {
                event = new ProfilesOpenProfileEvent(this.getView(), eventType, e.getProfile());
                break;
            }
            case 3: {
                event = new ProfilesAddCurrentEvent(this.getView(), eventType, e.getProfile());
                break;
            }
            case 9: {
                event = new ProfilesMakeStaticEvent(this.getView(), eventType, e.getProfile());
                break;
            }
            case 5: {
                event = new ProfilesDeleteEvent(this.getView(), eventType, e.getURIs());
                break;
            }
            case 7: {
                event = new ProfilesMoveUpEvent(this.getView(), eventType, e.getURIs());
                break;
            }
            case 8: {
                event = new ProfilesMoveDownEvent(this.getView(), eventType, e.getURIs());
                break;
            }
            case 10: {
                event = new ProfilesLinkStateChangedEvent(this.getView(), eventType, true);
                break;
            }
            case 11: {
                event = new ProfilesLinkStateChangedEvent(this.getView(), eventType, false);
                break;
            }
            case 12: {
                event = new ProfilesMakeCurrentEvent(this.getView(), eventType, e.getProfile());
                break;
            }
        }
        if (event != null) {
            this.fireEventListeners(event);
        }
    }

    public boolean getIsLinked() {
        IWorkbenchPart part = this.getView();
        if (part != null) {
            com.aptana.ide.editors.views.profiles.ProfilesView profileView = (com.aptana.ide.editors.views.profiles.ProfilesView)part;
            return profileView.getLinkWithEditorState();
        }
        return true;
    }

    public String getURIFromPath(String path) {
        return CoreUIUtils.getURI((String)path);
    }

    public String getPathFromURI(String uri) {
        return CoreUIUtils.getPathFromURI((String)uri);
    }

    public void expandAll() {
        IWorkbenchPart part = this.getView();
        if (part != null) {
            com.aptana.ide.editors.views.profiles.ProfilesView profileView = (com.aptana.ide.editors.views.profiles.ProfilesView)part;
            profileView.expandAll();
        }
    }

    public void expandProfile(String profilePath) {
        IWorkbenchPart part = this.getView();
        if (part != null) {
            com.aptana.ide.editors.views.profiles.ProfilesView profileView = (com.aptana.ide.editors.views.profiles.ProfilesView)part;
            profileView.expandProfile(profilePath);
        }
    }

    public void addProfile(Object profile) {
        if (profile instanceof Profile) {
            UnifiedEditorsPlugin.getDefault().getProfileManager().addProfile((Profile)profile);
        }
    }

    public Profile createProfile(String name, String path) {
        return UnifiedEditorsPlugin.getDefault().getProfileManager().createProfile(name, path, false);
    }

    public Profile createDynamicProfile(String name, String path) {
        return UnifiedEditorsPlugin.getDefault().getProfileManager().createProfile(name, path, true);
    }

    public void removeProfile(String name) {
        UnifiedEditorsPlugin.getDefault().getProfileManager().removeProfile(name);
    }

    public void setCurrentProfile(String name) {
        UnifiedEditorsPlugin.getDefault().getProfileManager().setCurrentProfile(name);
    }

    public Profile getCurrentProfile() {
        return UnifiedEditorsPlugin.getDefault().getProfileManager().getCurrentProfile();
    }

    public String[] getProfilePaths() {
        return UnifiedEditorsPlugin.getDefault().getProfileManager().getProfilePaths();
    }

    public Profile getProfile(String name) {
        return UnifiedEditorsPlugin.getDefault().getProfileManager().getProfile(name);
    }

    public Profile[] getProfiles() {
        return UnifiedEditorsPlugin.getDefault().getProfileManager().getProfiles();
    }
}

