/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.desktop.integration.server;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.MutexJobRule;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.WorkbenchHelper;
import com.aptana.ide.desktop.integration.server.DesktopIntegrationServerActivator;
import com.aptana.ide.desktop.integration.server.Messages;
import com.aptana.ide.update.Activator;
import com.aptana.ide.update.manager.IPlugin;
import com.aptana.ide.update.manager.PluginManagerException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.progress.UIJob;

public class LaunchHelper {
    private static final String HANDLE_URL_FLAG = "-handleURL";
    private String dotAptanaFile = null;
    private String[] initialFiles;
    private List<FeatureURL> featuresToInstall = new LinkedList<FeatureURL>();
    private static LaunchHelper _instance;

    public void openStartupFiles(IWorkbenchWindow window) {
        if (this.initialFiles != null) {
            if (this.initialFiles.length > 0) {
                try {
                    IntroPlugin.closeIntro();
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)Messages.LaunchHelper_UnableToCLoseWelcome, (Throwable)ex);
                }
            }
            int i = 0;
            while (i < this.initialFiles.length) {
                File file = new File(this.initialFiles[i]);
                try {
                    if (file.exists()) {
                        String editorID = this.getEditorID(file);
                        if (editorID == null) {
                            WorkbenchHelper.openFile((File)file, (IWorkbenchWindow)window);
                        } else {
                            WorkbenchHelper.openFile((String)editorID, (File)file, (IWorkbenchWindow)window);
                        }
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_ErrorOpeningFileOnStartup, (String)this.initialFiles[i]), (Throwable)e);
                }
                ++i;
            }
            this.initialFiles = null;
        }
        if (this.featuresToInstall.size() > 0) {
            UIJob uiJob = new UIJob("Installing features"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        Activator.getDefault().getPluginManager().install((IPlugin[])LaunchHelper.this.featuresToInstall.toArray(new FeatureURL[0]), (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (PluginManagerException e) {
                        IdeLog.logError((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)e.getMessage());
                    }
                    return Status.OK_STATUS;
                }
            };
            uiJob.setSystem(true);
            uiJob.setRule((ISchedulingRule)MutexJobRule.getInstance());
            uiJob.schedule(10000L);
        }
    }

    private String getEditorID(File file) {
        String name = file.getName().toLowerCase();
        if (name.endsWith(".js") || name.endsWith(".css")) {
            return null;
        }
        String contents = this.getFileContents(file);
        if (contents == null) {
            return null;
        }
        if ((contents = contents.toLowerCase()).indexOf("<!doctype html") != -1 || contents.indexOf("<html") != -1) {
            return "com.aptana.ide.editors.HTMLEditor";
        }
        return null;
    }

    private String getFileContents(File file) {
        int fileLength = (int)file.length();
        if (fileLength == 0) {
            return null;
        }
        if (fileLength > 100) {
            fileLength = 100;
        }
        char[] chars = new char[fileLength];
        try {
            FileReader fr = new FileReader(file);
            fr.read(chars);
            fr.close();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_UnableToGetFileContents, (String)file.getAbsolutePath()), (Throwable)e);
            return null;
        }
        return new String(chars);
    }

    public LaunchHelper getInstance() {
        if (_instance == null) {
            _instance = new LaunchHelper();
        }
        return _instance;
    }

    public void setLaunchFileCmdLineArgs(String[] args) {
        int startIndex = 0;
        String[] argList = args;
        if (argList.length > 0 && argList[0].toLowerCase().matches(".*?(aptana.exe|aptanastudio.exe)")) {
            startIndex = 1;
            String newDotAptanaFile = LaunchHelper.computeDotAptanaFileName();
            if (this.dotAptanaFile == null) {
                this.dotAptanaFile = newDotAptanaFile;
                IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_AptanaPortCachedInFile, (String)this.dotAptanaFile));
            } else {
                IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_PortCacheFile, (Object[])new String[]{this.dotAptanaFile, newDotAptanaFile}));
            }
        }
        this.featuresToInstall.clear();
        ArrayList<String> filesList = new ArrayList<String>();
        int i = startIndex;
        while (i < argList.length) {
            if (argList[i].startsWith("-")) {
                if (argList[i].equals(HANDLE_URL_FLAG) && i < argList.length - 1) {
                    IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)("Received install request : " + argList[i + 1]));
                    try {
                        URL url;
                        String id;
                        String urlString = argList[i + 1];
                        if (urlString.startsWith("aptanaplugininstaller:")) {
                            urlString = urlString.substring("aptanaplugininstaller:".length());
                        }
                        if ((id = (url = new URL(urlString)).getQuery()) != null && id.length() > 0) {
                            ++i;
                            URL updateSiteUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
                            this.featuresToInstall.add(new FeatureURL(updateSiteUrl, id));
                        }
                    }
                    catch (MalformedURLException e) {
                        IdeLog.logError((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)e.getMessage());
                    }
                }
            } else {
                File file = new File(argList[i]);
                if (file.exists()) {
                    filesList.add(argList[i]);
                }
            }
            ++i;
        }
        String[] fileList = filesList.toArray(new String[0]);
        this.initialFiles = fileList;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int checkForRunningInstance() {
        int port = this.readCurrentPort();
        if (port < 0) {
            return port;
        }
        ServerSocket serverSocket = null;
        serverSocket = new ServerSocket(port, 0, null);
        if (serverSocket == null) return -1;
        try {
            serverSocket.close();
            return -1;
        }
        catch (IOException iOException) {}
        return -1;
        catch (IOException e) {
            try {
                IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)e.getMessage());
                if (serverSocket == null) return port;
            }
            catch (Throwable throwable) {
                if (serverSocket == null) throw throwable;
                try {
                    serverSocket.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                serverSocket.close();
                return port;
            }
            catch (IOException iOException) {}
            return port;
        }
    }

    public void startServer() {
        if (this.dotAptanaFile == null) {
            this.dotAptanaFile = LaunchHelper.computeDotAptanaFileName();
        }
        try {
            CommandLineArgsServer server = new CommandLineArgsServer(this);
            server.start();
        }
        catch (IOException e) {
            IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)Messages.LaunchHelper_ErrorInChdeckingForCurrentInstance, (Throwable)e);
        }
    }

    public void doShutdownCleanup() {
        if (this.dotAptanaFile != null) {
            new File(this.dotAptanaFile).delete();
        }
    }

    private int readCurrentPort() {
        FileReader fr = null;
        if (this.dotAptanaFile == null) {
            this.dotAptanaFile = LaunchHelper.computeDotAptanaFileName();
        }
        try {
            fr = new FileReader(this.dotAptanaFile);
            BufferedReader br = new BufferedReader(fr);
            String sPort = br.readLine().trim();
            if (sPort.length() == 0) {
                return -1;
            }
            int n = Integer.parseInt(sPort);
            return n;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return -1;
        }
        catch (Exception e) {
            IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)Messages.LaunchHelper_UnableToFindCurrentPort, (Throwable)e);
            return 9980;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)Messages.LaunchHelper_ErrorInClosingFileReader, (Throwable)e);
                }
            }
        }
    }

    private static String computeDotAptanaFileName() {
        URL locationURL;
        File dotAptanaParent = new File(System.getProperty("user.dir"));
        Location location = Platform.getInstallLocation();
        if (!(location != null && !location.isReadOnly() || (location = Platform.getConfigurationLocation()) != null && !location.isReadOnly() || (location = Platform.getUserLocation()) != null && !location.isReadOnly())) {
            location = null;
        }
        if (location != null && (locationURL = location.getURL()) != null && "file".equals(locationURL.getProtocol())) {
            try {
                dotAptanaParent = new File(locationURL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                dotAptanaParent = new File(locationURL.getPath());
            }
        }
        String computedDotAptanaFile = new File(dotAptanaParent, ".aptana").getAbsolutePath();
        IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)(".aptana file " + computedDotAptanaFile));
        return computedDotAptanaFile;
    }

    public boolean sendInitialFilesAndInstallFeatures(int port, String[] args) {
        Socket socket = null;
        DataOutputStream os = null;
        try {
            socket = new Socket(InetAddress.getByName(null), port);
            os = new DataOutputStream(socket.getOutputStream());
        }
        catch (UnknownHostException unknownHostException) {
            IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)Messages.LaunchHelper_UnknownLocalHost);
            return false;
        }
        catch (IOException iOException) {
            IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)Messages.LaunchHelper_CouldNotGetIOConnection);
            return false;
        }
        if (socket != null && os != null) {
            try {
                StringBuilder sb = new StringBuilder();
                String[] stringArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append("\"" + arg + "\"");
                    ++n2;
                }
                PrintWriter ps = new PrintWriter(os);
                ps.println(sb.toString());
                ps.flush();
                ps.close();
                socket.close();
                return true;
            }
            catch (UnknownHostException unknownHostException) {
                IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)Messages.LaunchHelper_TryingToConnectToUnknownHost);
            }
            catch (IOException iOException) {
                IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)Messages.LaunchHelper_IOExceptionEncountered);
            }
        }
        return false;
    }

    public void hookStartupListener() {
        try {
            Class<?> cls = ClassLoader.getSystemClassLoader().loadClass("com.aptana.ide.startup.WorkbenchStartupManager");
            Method startupListener = cls.getMethod("setStartupListener", Object.class);
            startupListener.invoke(null, this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)Messages.LaunchHelper_TheStartupListenerClassIsNotAvailable);
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)Messages.LaunchHelper_ErrorHookingStartupListener, (Throwable)e);
        }
    }

    public void startupPerformed(String args) {
        String[] startupArgs = this.parseCommandLineArgs(args);
        this.setLaunchFileCmdLineArgs(startupArgs);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                LaunchHelper.this.openStartupFiles(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
        });
    }

    private String[] parseCommandLineArgs(String cmdLine) {
        char quote = '\"';
        char flagStart = '-';
        ArrayList<String> args = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        try {
            char[] chars = cmdLine.toCharArray();
            boolean quoteMode = false;
            int i = 0;
            while (i < chars.length) {
                boolean endWord = false;
                char ch = chars[i];
                if (ch == quote) {
                    if (quoteMode) {
                        quoteMode = false;
                        endWord = true;
                    } else {
                        quoteMode = true;
                    }
                } else if (Character.isWhitespace(ch) && !quoteMode) {
                    endWord = true;
                } else {
                    word.append(ch);
                }
                if (endWord) {
                    if (word.length() > 0 && (word.toString().equals(HANDLE_URL_FLAG) || word.charAt(0) != flagStart)) {
                        args.add(word.toString());
                    }
                    word.setLength(0);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            IdeLog.logError((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_UnableToRecognizeCommandLineLaunchArguments, (String)cmdLine));
        }
        if (word.length() > 0 && (word.toString().equals(HANDLE_URL_FLAG) || word.charAt(0) != flagStart)) {
            args.add(word.toString());
        }
        String[] argArray = args.toArray(new String[0]);
        return argArray;
    }

    class CommandLineArgsServer
    extends Thread {
        public static final int STARTING_PORT = 9980;
        LaunchHelper helper;
        ServerSocket server;
        String line;
        DataInputStream is;
        PrintStream os;
        Socket clientSocket;

        public CommandLineArgsServer(LaunchHelper helper) throws IOException {
            super("CommandLineArgsServer");
            this.server = null;
            this.clientSocket = null;
            this.helper = helper;
            int port = this.getPort();
            if (port == -1) {
                throw new IOException(StringUtils.format((String)Messages.LaunchHelper_CouldNotFindOpenPort, (Object[])new String[]{String.valueOf(9980), String.valueOf(9990)}));
            }
            IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_BoundAptanaToPort, (int)port));
            try {
                FileWriter f = new FileWriter(LaunchHelper.this.dotAptanaFile);
                BufferedWriter out = new BufferedWriter(f);
                out.write("" + port);
                out.close();
                new File(LaunchHelper.this.dotAptanaFile).deleteOnExit();
            }
            catch (IOException iOException) {}
        }

        public int getPort() {
            int tries = 10;
            int port = 9980;
            while (tries > 0) {
                try {
                    this.server = new ServerSocket(port, 0, null);
                    this.server.setSoTimeout(1000);
                    return port;
                }
                catch (IOException iOException) {
                    IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_UnableToBindToPort, (int)port));
                    --tries;
                    ++port;
                }
            }
            return -1;
        }

        public void run() {
            while (!this.server.isClosed()) {
                try {
                    this.clientSocket = this.server.accept();
                    BufferedReader r = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                    BufferedWriter w = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
                    this.line = r.readLine().trim();
                    w.write("pong");
                    w.flush();
                    this.clientSocket.close();
                    if (this.line.length() <= 0) continue;
                    this.helper.startupPerformed(this.line);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (Exception e) {
                    IdeLog.logInfo((Plugin)DesktopIntegrationServerActivator.getDefault(), (String)CoreStrings.ERROR, (Throwable)e);
                }
            }
        }
    }

    private static class FeatureURL
    implements IPlugin {
        private final URL url;
        private final String id;

        FeatureURL(URL url, String id) {
            this.url = url;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.id;
        }

        public URL getURL() {
            return this.url;
        }

        public String getVersion() {
            return null;
        }
    }
}

