/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.ILoggable;
import com.aptana.ide.core.ILogger;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.efs.EFSUtils;
import com.aptana.ide.core.io.syncing.VirtualFileSyncPair;
import com.aptana.ide.syncing.core.Messages;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.core.events.ISyncEventHandler;
import com.aptana.ide.syncing.core.internal.SyncUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

public class Synchronizer
implements ILoggable {
    public static final QualifiedName SYNC_IN_PROGRESS = new QualifiedName(Synchronizer.class.getPackage().getName(), "SYNC_IN_PROGRESS");
    private static final int DEFAULT_TIME_TOLERANCE = 1000;
    private boolean _useCRC;
    private boolean _includeCloakedFiles = false;
    private long _timeTolerance;
    private int _clientDirectoryCreatedCount;
    private int _clientDirectoryDeletedCount;
    private int _clientFileDeletedCount;
    private int _clientFileTransferedCount;
    private int _serverDirectoryCreatedCount;
    private int _serverDirectoryDeletedCount;
    private int _serverFileDeletedCount;
    private int _serverFileTransferedCount;
    private IConnectionPoint _clientFileManager;
    private IConnectionPoint _serverFileManager;
    private IFileStore _clientFileRoot;
    private IFileStore _serverFileRoot;
    private ISyncEventHandler _eventHandler;
    private ILogger logger;
    private List<IFileStore> _newFilesDownloaded;
    private List<IFileStore> _newFilesUploaded;

    public Synchronizer() {
        this(false, 1000, false);
    }

    public Synchronizer(boolean calculateCrc, int timeTolerance) {
        this(calculateCrc, timeTolerance, false);
    }

    public Synchronizer(boolean calculateCrc, int timeTolerance, boolean includeCloakedFiles) {
        if (timeTolerance < 0) {
            timeTolerance = -timeTolerance;
        }
        this._useCRC = calculateCrc;
        this._includeCloakedFiles = includeCloakedFiles;
        this._timeTolerance = timeTolerance;
        this._newFilesDownloaded = new ArrayList<IFileStore>();
        this._newFilesUploaded = new ArrayList<IFileStore>();
    }

    protected void log(String message) {
        if (this.logger != null) {
            this.logger.logInfo(message, null);
        }
    }

    public static String getCanonicalPath(IFileStore root, IFileStore file) {
        String basePath = null;
        String result = null;
        try {
            basePath = EFSUtils.getAbsolutePath((IFileStore)root);
            result = EFSUtils.getAbsolutePath((IFileStore)file).substring(basePath.length());
            if (result.indexOf(92) != -1) {
                result = result.replace('\\', '/');
            }
            if (result.startsWith("/")) {
                result = result.substring(1);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IllegalArgumentException(StringUtils.format((String)Messages.Synchronizer_FileNotContained, (Object[])new String[]{EFSUtils.getAbsolutePath((IFileStore)file), basePath}));
        }
        return result;
    }

    public int getClientDirectoryCreatedCount() {
        return this._clientDirectoryCreatedCount;
    }

    public int getClientDirectoryDeletedCount() {
        return this._clientDirectoryDeletedCount;
    }

    public int getClientFileDeletedCount() {
        return this._clientFileDeletedCount;
    }

    public int getClientFileTransferedCount() {
        return this._clientFileTransferedCount;
    }

    public ISyncEventHandler getEventHandler() {
        return this._eventHandler;
    }

    public void setEventHandler(ISyncEventHandler eventHandler) {
        this._eventHandler = eventHandler;
    }

    public int getServerDirectoryCreatedCount() {
        return this._serverDirectoryCreatedCount;
    }

    public int getServerDirectoryDeletedCount() {
        return this._serverDirectoryDeletedCount;
    }

    public int getServerFileDeletedCount() {
        return this._serverFileDeletedCount;
    }

    public int getServerFileTransferedCount() {
        return this._serverFileTransferedCount;
    }

    public IFileStore[] getNewFilesDownloaded() {
        return this._newFilesDownloaded.toArray(new IFileStore[this._newFilesDownloaded.size()]);
    }

    public IFileStore[] getNewFilesUploaded() {
        return this._newFilesUploaded.toArray(new IFileStore[this._newFilesUploaded.size()]);
    }

    public void setClientFileRoot(IFileStore client) {
        this._clientFileRoot = client;
    }

    public void setServerFileRoot(IFileStore server) {
        this._serverFileRoot = server;
    }

    public VirtualFileSyncPair[] getSyncItems(IConnectionPoint clientPoint, IConnectionPoint serverPoint, IFileStore client, IFileStore server, IProgressMonitor monitor) throws IOException, CoreException {
        this.setClientFileManager(clientPoint);
        this.setServerFileManager(serverPoint);
        this.setClientFileRoot(client);
        this.setServerFileRoot(server);
        IFileStore[] clientFiles = new IFileStore[]{};
        IFileStore[] serverFiles = new IFileStore[]{};
        IFileInfo clientInfo = client.fetchInfo();
        IFileInfo serverInfo = server.fetchInfo();
        try {
            this.setClientEventHandler(client, server);
            if (!clientInfo.isDirectory() || !serverInfo.isDirectory()) {
                if (clientInfo.exists()) {
                    clientFiles = new IFileStore[]{client};
                }
                if (serverInfo.exists()) {
                    serverFiles = new IFileStore[]{server};
                }
            } else {
                this.log(String.valueOf(FileUtils.NEW_LINE) + "Gathering list of source files from '" + client.toString() + "'. ");
                long start = System.currentTimeMillis();
                clientFiles = EFSUtils.getFiles((IFileStore)client, (boolean)true, (boolean)this._includeCloakedFiles, (IProgressMonitor)monitor);
                this.log(MessageFormat.format("Completed in {0} ms.", System.currentTimeMillis() - start));
                start = System.currentTimeMillis();
                this.log(String.valueOf(FileUtils.NEW_LINE) + "Gathering list of destination files from '" + server.toString() + "'. ");
                serverFiles = EFSUtils.getFiles((IFileStore)server, (boolean)true, (boolean)this._includeCloakedFiles, (IProgressMonitor)monitor);
                this.log(MessageFormat.format("Completed in {0} ms.", System.currentTimeMillis() - start));
                this.log(String.valueOf(FileUtils.NEW_LINE) + "File listing complete.");
            }
        }
        finally {
            this.removeClientEventHandler(client, server);
        }
        if (!this.syncContinue(monitor)) {
            return null;
        }
        return this.createSyncItems(clientFiles, serverFiles, monitor);
    }

    public VirtualFileSyncPair[] createSyncItems(IFileStore[] clientFiles, IFileStore[] serverFiles, IProgressMonitor monitor) throws IOException, CoreException {
        this.log(String.valueOf(FileUtils.NEW_LINE) + "Generating comparison.");
        HashMap<String, VirtualFileSyncPair> fileList = new HashMap<String, VirtualFileSyncPair>();
        this.reset();
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        Policy.checkCanceled((IProgressMonitor)monitor);
        int i = 0;
        while (i < clientFiles.length) {
            if (!this.syncContinue(monitor)) {
                return null;
            }
            Policy.checkCanceled((IProgressMonitor)monitor);
            monitor.worked(1);
            IFileStore clientFile = clientFiles[i];
            if (!clientFile.fetchInfo().getAttribute(32)) {
                String relativePath = Synchronizer.getCanonicalPath(this._clientFileRoot, clientFile);
                VirtualFileSyncPair item = new VirtualFileSyncPair(clientFile, null, relativePath, 6);
                fileList.put(item.getRelativePath(), item);
            }
            ++i;
        }
        i = 0;
        while (i < serverFiles.length) {
            VirtualFileSyncPair item;
            if (!this.syncContinue(monitor)) {
                return null;
            }
            Policy.checkCanceled((IProgressMonitor)monitor);
            monitor.worked(1);
            IFileStore serverFile = serverFiles[i];
            IFileInfo serverFileInfo = serverFile.fetchInfo(1024, null);
            String relativePath = Synchronizer.getCanonicalPath(this._serverFileRoot, serverFile);
            this.logDebug(String.valueOf(FileUtils.NEW_LINE) + "Comparing '" + relativePath + "' with file from destination. ");
            if (!fileList.containsKey(relativePath)) {
                if (!serverFileInfo.getAttribute(32)) {
                    item = new VirtualFileSyncPair(null, serverFile, relativePath, 7);
                    fileList.put(relativePath, item);
                    this.logDebug("Item not on destination.");
                }
            } else {
                item = (VirtualFileSyncPair)fileList.get(relativePath);
                item.setDestinationFile(serverFile);
                if (item.getSourceFileInfo().isDirectory() != serverFileInfo.isDirectory()) {
                    item.setSyncState(8);
                    this.logDebug("Incompatible types.");
                } else if (serverFile.fetchInfo().isDirectory()) {
                    fileList.remove(relativePath);
                    this.logDebug("Directory.");
                } else {
                    long serverFileTime = serverFileInfo.getLastModified();
                    long clientFileTime = item.getSourceFileInfo(null).getLastModified();
                    long timeDiff = serverFileTime - clientFileTime;
                    this.logDebug("Source modified: " + clientFileTime + " Destination modified: " + serverFileTime + ". ");
                    if (-this._timeTolerance <= timeDiff && timeDiff <= this._timeTolerance) {
                        if (this._useCRC && !serverFileInfo.isDirectory()) {
                            item.setSyncState(this.compareCRC(item));
                        } else {
                            item.setSyncState(2);
                            this.logDebug("Items identical.");
                        }
                    } else if (timeDiff < 0L) {
                        item.setSyncState(4);
                        this.logDebug("Source Newer by " + Math.round(Math.abs(timeDiff / 1000L)) + " seconds.");
                    } else {
                        item.setSyncState(5);
                        this.logDebug("Destination Newer by " + Math.round(timeDiff / 1000L) + " seconds.");
                    }
                }
            }
            ++i;
        }
        Set keySet = fileList.keySet();
        Object[] keys = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keys);
        VirtualFileSyncPair[] syncItems = new VirtualFileSyncPair[keys.length];
        int i2 = 0;
        while (i2 < keys.length) {
            syncItems[i2] = (VirtualFileSyncPair)fileList.get(keys[i2]);
            ++i2;
        }
        return syncItems;
    }

    private void setClientEventHandler(IFileStore client, IFileStore server) {
    }

    private void removeClientEventHandler(IFileStore client, IFileStore server) {
    }

    public long getTimeTolerance() {
        return this._timeTolerance;
    }

    public void setTimeTolerance(int timeTolerance) {
        this._timeTolerance = timeTolerance;
    }

    public void setUseCRC(boolean calculateCrc) {
        this._useCRC = calculateCrc;
    }

    public boolean getUseCRC() {
        return this._useCRC;
    }

    private int compareCRC(VirtualFileSyncPair item) throws IOException, CoreException {
        int result;
        InputStream clientStream = item.getSourceInputStream();
        InputStream serverStream = item.getDestinationInputStream();
        if (clientStream != null && serverStream != null) {
            long clientCRC = this.getCRC(clientStream);
            long serverCRC = this.getCRC(serverStream);
            try {
                clientStream.close();
                serverStream.close();
            }
            catch (IOException e) {
                SyncingPlugin.logError(MessageFormat.format(Messages.Synchronizer_ErrorClosingStreams, item.getRelativePath()), e);
            }
            result = clientCRC == serverCRC ? 2 : 3;
        } else {
            result = clientStream == serverStream ? 2 : 3;
        }
        return result;
    }

    private long getCRC(InputStream stream) {
        CRC32 crc = new CRC32();
        try {
            int length;
            byte[] buffer = new byte[1024];
            while ((length = stream.read(buffer)) != -1) {
                crc.update(buffer, 0, length);
            }
        }
        catch (IOException e) {
            SyncingPlugin.logError(Messages.Synchronizer_ErrorRetrievingCRC, e);
        }
        return crc.getValue();
    }

    public boolean download(VirtualFileSyncPair[] fileList, IProgressMonitor monitor) throws CoreException {
        return this.downloadAndDelete(fileList, false, monitor);
    }

    public boolean downloadAndDelete(VirtualFileSyncPair[] fileList, IProgressMonitor monitor) throws CoreException {
        return this.downloadAndDelete(fileList, true, monitor);
    }

    public boolean downloadAndDelete(VirtualFileSyncPair[] fileList, boolean delete, IProgressMonitor monitor) throws CoreException {
        this.checkFileManagers();
        this.logBeginDownloading();
        boolean result = true;
        int totalItems = fileList.length;
        this.reset();
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        Policy.checkCanceled((IProgressMonitor)monitor);
        int i = 0;
        block11: while (i < fileList.length) {
            VirtualFileSyncPair item = fileList[i];
            IFileStore clientFile = item.getSourceFile();
            IFileInfo clientFileInfo = item.getSourceFileInfo();
            IFileStore serverFile = item.getDestinationFile();
            IFileInfo serverFileInfo = item.getDestinationFileInfo();
            Synchronizer.setSyncItemDirection(item, false, false);
            if (!this.syncEvent(item, i, totalItems, monitor)) {
                delete = false;
                break;
            }
            Policy.checkCanceled((IProgressMonitor)monitor);
            switch (item.getSyncState()) {
                case 6: {
                    if (delete) {
                        boolean wasDirectory = clientFileInfo.isDirectory();
                        clientFile.delete(0, null);
                        if (wasDirectory) {
                            ++this._clientDirectoryDeletedCount;
                        } else {
                            ++this._clientFileDeletedCount;
                        }
                    }
                    this.syncDone(item, monitor);
                    break;
                }
                case 7: {
                    IFileStore targetClientFile = EFSUtils.createFile((IFileStore)this._serverFileRoot, (IFileStore)item.getDestinationFile(), (IFileStore)this._clientFileRoot);
                    if (serverFileInfo.isDirectory()) {
                        this.logCreatedDirectory(targetClientFile);
                        if (!targetClientFile.fetchInfo().exists()) {
                            targetClientFile.mkdir(0, null);
                            ++this._clientDirectoryCreatedCount;
                            this._newFilesDownloaded.add(targetClientFile);
                        }
                        this.logSuccess();
                        this.syncDone(item, monitor);
                        break;
                    }
                    this.logDownloading(serverFile);
                    try {
                        SyncUtils.copy(serverFile, serverFileInfo, targetClientFile, 0, monitor);
                        ++this._serverFileTransferedCount;
                        this._newFilesDownloaded.add(targetClientFile);
                        this.logSuccess();
                        this.syncDone(item, monitor);
                        break;
                    }
                    catch (CoreException e) {
                        this.logError((Exception)((Object)e));
                        if (this.syncError(item, (Exception)((Object)e), monitor)) break;
                        result = false;
                        break block11;
                    }
                }
                case 3: 
                case 5: {
                    this.logDownloading(serverFile);
                    if (serverFileInfo.isDirectory()) {
                        try {
                            EFSUtils.setModificationTime((long)serverFileInfo.getLastModified(), (IFileStore)clientFile);
                        }
                        catch (CoreException e) {
                            this.logError((Exception)((Object)e));
                        }
                        this.logSuccess();
                        this.syncDone(item, monitor);
                        break;
                    }
                    try {
                        SyncUtils.copy(serverFile, serverFileInfo, clientFile, 0, monitor);
                        ++this._serverFileTransferedCount;
                        this.logSuccess();
                        this.syncDone(item, monitor);
                        break;
                    }
                    catch (CoreException e) {
                        this.logError((Exception)((Object)e));
                        if (this.syncError(item, (Exception)((Object)e), monitor)) break;
                        result = false;
                        break block11;
                    }
                }
                default: {
                    this.syncDone(item, monitor);
                }
            }
            ++i;
        }
        return result;
    }

    public boolean fullSync(VirtualFileSyncPair[] fileList, IProgressMonitor monitor) {
        return this.fullSyncAndDelete(fileList, false, false, monitor);
    }

    public boolean fullSyncAndDelete(VirtualFileSyncPair[] fileList, IProgressMonitor monitor) {
        return this.fullSyncAndDelete(fileList, true, true, monitor);
    }

    public boolean fullSyncAndDelete(VirtualFileSyncPair[] fileList, boolean deleteLocal, boolean deleteRemote, IProgressMonitor monitor) {
        this.logBeginFullSyncing();
        boolean result = true;
        int totalItems = fileList.length;
        this.reset();
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        Policy.checkCanceled((IProgressMonitor)monitor);
        int i = 0;
        block18: while (i < fileList.length) {
            VirtualFileSyncPair item = fileList[i];
            IFileStore clientFile = item.getSourceFile();
            IFileInfo clientFileInfo = item.getSourceFileInfo();
            IFileStore serverFile = item.getDestinationFile();
            IFileInfo serverFileInfo = item.getDestinationFileInfo();
            try {
                Synchronizer.setSyncItemDirection(item, false, true);
                if (!this.syncEvent(item, i, totalItems, monitor)) {
                    result = false;
                    break;
                }
                Policy.checkCanceled((IProgressMonitor)monitor);
                switch (item.getSyncState()) {
                    case 4: {
                        this.logUploading(serverFile);
                        if (clientFileInfo.isDirectory()) {
                            EFSUtils.setModificationTime((long)clientFileInfo.getLastModified(), (IFileStore)serverFile);
                            this.logSuccess();
                            this.syncDone(item, monitor);
                            break;
                        }
                        try {
                            SyncUtils.copy(clientFile, clientFileInfo, serverFile, 0, monitor);
                            ++this._clientFileTransferedCount;
                            this.logSuccess();
                            this.syncDone(item, monitor);
                            break;
                        }
                        catch (CoreException e) {
                            this.logError((Exception)((Object)e));
                            if (!this.syncError(item, (Exception)((Object)e), monitor)) {
                                result = false;
                                break block18;
                            }
                            break;
                        }
                    }
                    case 6: {
                        if (deleteLocal) {
                            boolean wasDirectory = clientFileInfo.isDirectory();
                            clientFile.delete(0, null);
                            if (wasDirectory) {
                                ++this._clientDirectoryDeletedCount;
                            } else {
                                ++this._clientFileDeletedCount;
                            }
                            this.logSuccess();
                            this.syncDone(item, monitor);
                            break;
                        }
                        IFileStore targetServerFile = EFSUtils.createFile((IFileStore)this._clientFileRoot, (IFileStore)item.getSourceFile(), (IFileStore)this._serverFileRoot);
                        if (clientFileInfo.isDirectory()) {
                            this.logCreatedDirectory(targetServerFile);
                            if (!targetServerFile.fetchInfo().exists()) {
                                targetServerFile.mkdir(0, null);
                                ++this._serverDirectoryCreatedCount;
                                this._newFilesUploaded.add(targetServerFile);
                            }
                            this.logSuccess();
                            this.syncDone(item, monitor);
                            break;
                        }
                        this.logUploading(clientFile);
                        try {
                            SyncUtils.copy(clientFile, clientFileInfo, targetServerFile, 0, monitor);
                            ++this._clientFileTransferedCount;
                            this._newFilesUploaded.add(targetServerFile);
                            this.logSuccess();
                            this.syncDone(item, monitor);
                            break;
                        }
                        catch (CoreException e) {
                            this.logError((Exception)((Object)e));
                            if (!this.syncError(item, (Exception)((Object)e), monitor)) {
                                result = false;
                                break block18;
                            }
                            break;
                        }
                    }
                    case 5: {
                        this.logDownloading(clientFile);
                        if (serverFileInfo.isDirectory()) {
                            EFSUtils.setModificationTime((long)serverFileInfo.getLastModified(), (IFileStore)clientFile);
                            this.logSuccess();
                            this.syncDone(item, monitor);
                            break;
                        }
                        try {
                            SyncUtils.copy(serverFile, serverFileInfo, clientFile, 0, monitor);
                            ++this._serverFileTransferedCount;
                            this.logSuccess();
                            this.syncDone(item, monitor);
                            break;
                        }
                        catch (CoreException e) {
                            this.logError((Exception)((Object)e));
                            if (!this.syncError(item, (Exception)((Object)e), monitor)) {
                                result = false;
                                break block18;
                            }
                            break;
                        }
                    }
                    case 7: {
                        if (deleteRemote) {
                            boolean wasDirectory = serverFileInfo.isDirectory();
                            serverFile.delete(0, null);
                            if (wasDirectory) {
                                ++this._serverDirectoryDeletedCount;
                            } else {
                                ++this._serverFileDeletedCount;
                            }
                            this.logSuccess();
                            this.syncDone(item, monitor);
                            break;
                        }
                        IFileStore targetClientFile = EFSUtils.createFile((IFileStore)this._serverFileRoot, (IFileStore)item.getDestinationFile(), (IFileStore)this._clientFileRoot);
                        if (serverFileInfo.isDirectory()) {
                            this.logCreatedDirectory(targetClientFile);
                            if (!targetClientFile.fetchInfo().exists()) {
                                targetClientFile.mkdir(0, null);
                                ++this._clientDirectoryCreatedCount;
                                this._newFilesDownloaded.add(targetClientFile);
                            }
                            this.logSuccess();
                            this.syncDone(item, monitor);
                            break;
                        }
                        this.logDownloading(targetClientFile);
                        try {
                            SyncUtils.copy(serverFile, serverFileInfo, targetClientFile, 0, monitor);
                            ++this._serverFileTransferedCount;
                            this._newFilesDownloaded.add(targetClientFile);
                            this.logSuccess();
                            this.syncDone(item, monitor);
                            break;
                        }
                        catch (CoreException e) {
                            this.logError((Exception)((Object)e));
                            if (!this.syncError(item, (Exception)((Object)e), monitor)) {
                                result = false;
                                break block18;
                            }
                            break;
                        }
                    }
                    case 3: {
                        result = false;
                        SyncingPlugin.logError(StringUtils.format((String)Messages.Synchronizer_FullSyncCRCMismatches, (String)item.getRelativePath()), null);
                        if (!this.syncError(item, null, monitor)) {
                            break block18;
                        }
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
            }
            catch (Exception ex) {
                SyncingPlugin.logError(Messages.Synchronizer_ErrorDuringSync, ex);
                result = false;
                if (!this.syncError(item, ex, monitor)) break;
            }
            ++i;
        }
        return result;
    }

    private void reset() {
        this._clientDirectoryCreatedCount = 0;
        this._clientDirectoryDeletedCount = 0;
        this._clientFileDeletedCount = 0;
        this._clientFileTransferedCount = 0;
        this._serverDirectoryCreatedCount = 0;
        this._serverDirectoryDeletedCount = 0;
        this._serverFileDeletedCount = 0;
        this._serverFileTransferedCount = 0;
        this._newFilesDownloaded.clear();
        this._newFilesUploaded.clear();
    }

    public boolean upload(VirtualFileSyncPair[] fileList, IProgressMonitor monitor) throws CoreException {
        return this.uploadAndDelete(fileList, false, monitor);
    }

    public boolean uploadAndDelete(VirtualFileSyncPair[] fileList, IProgressMonitor monitor) throws CoreException {
        return this.uploadAndDelete(fileList, true, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public boolean uploadAndDelete(VirtualFileSyncPair[] fileList, boolean delete, IProgressMonitor monitor) throws CoreException {
        this.checkFileManagers();
        this.logBeginUploading();
        result = true;
        totalItems = fileList.length;
        this.reset();
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        Policy.checkCanceled((IProgressMonitor)monitor);
        i = 0;
        block11: while (i < fileList.length) {
            item = fileList[i];
            clientFile = item.getSourceFile();
            clientFileInfo = item.getSourceFileInfo();
            serverFile = item.getDestinationFile();
            serverFileInfo = item.getDestinationFileInfo();
            Synchronizer.setSyncItemDirection(item, true, false);
            if (!this.syncEvent(item, i, totalItems, monitor)) {
                result = false;
                break;
            }
            Policy.checkCanceled((IProgressMonitor)monitor);
            switch (item.getSyncState()) {
                case 6: {
                    targetServerFile = EFSUtils.createFile((IFileStore)this._clientFileRoot, (IFileStore)item.getSourceFile(), (IFileStore)this._serverFileRoot);
                    if (clientFileInfo.isDirectory()) {
                        if (!targetServerFile.fetchInfo().exists()) {
                            targetServerFile.mkdir(0, null);
                            ++this._serverDirectoryCreatedCount;
                            this._newFilesUploaded.add(targetServerFile);
                        }
                        this.syncDone(item, monitor);
                        break;
                    }
                    this.logUploading(clientFile);
                    try {
                        SyncUtils.copy(clientFile, clientFileInfo, targetServerFile, 0, monitor);
                        ++this._clientFileTransferedCount;
                        this._newFilesUploaded.add(targetServerFile);
                        this.logSuccess();
                        this.syncDone(item, monitor);
                        break;
                    }
                    catch (CoreException e) {
                        this.logError((Exception)e);
                        if (this.syncError(item, (Exception)e, monitor)) break;
                        result = false;
                        break block11;
                    }
                }
                case 7: {
                    if (delete) {
                        wasDirectory = serverFileInfo.isDirectory();
                        serverFile.delete(0, monitor);
                        if (wasDirectory) {
                            ++this._serverDirectoryDeletedCount;
                        } else {
                            ++this._serverFileDeletedCount;
                        }
                    }
                    this.syncDone(item, monitor);
                    break;
                }
                case 3: 
                case 4: {
                    this.logUploading(clientFile);
                    if (!clientFileInfo.isDirectory()) ** GOTO lbl70
                    try {
                        EFSUtils.setModificationTime((long)clientFileInfo.getLastModified(), (IFileStore)serverFile);
                    }
                    catch (CoreException e) {
                        this.logError((Exception)e);
                        if (this.syncError(item, (Exception)e, monitor)) ** GOTO lbl67
                        result = false;
                        break block11;
                    }
lbl67:
                    // 2 sources

                    this.logSuccess();
                    this.syncDone(item, monitor);
                    break;
lbl70:
                    // 1 sources

                    try {
                        SyncUtils.copy(clientFile, clientFileInfo, serverFile, 0, monitor);
                        ++this._clientFileTransferedCount;
                        this.logSuccess();
                        this.syncDone(item, monitor);
                        break;
                    }
                    catch (CoreException e) {
                        this.logError((Exception)e);
                        if (this.syncError(item, (Exception)e, monitor)) break;
                        result = false;
                        break block11;
                    }
                }
                default: {
                    this.syncDone(item, monitor);
                }
            }
            ++i;
        }
        return result;
    }

    private static void setSyncItemDirection(VirtualFileSyncPair item, boolean upload, boolean full) {
        int direction = 0;
        switch (item.getSyncState()) {
            case 0: 
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                if (upload) {
                    direction = 1;
                    break;
                }
                if (full) break;
                direction = 2;
                break;
            }
            case 4: 
            case 6: {
                if (!upload && !full) break;
                direction = 1;
                break;
            }
            case 5: 
            case 7: {
                if (upload && !full) break;
                direction = 2;
            }
        }
        item.setSyncDirection(direction);
    }

    public IConnectionPoint getClientFileManager() {
        return this._clientFileManager;
    }

    public void setClientFileManager(IConnectionPoint fileManager) {
        this._clientFileManager = fileManager;
    }

    public IConnectionPoint getServerFileManager() {
        return this._serverFileManager;
    }

    public void setServerFileManager(IConnectionPoint fileManager) {
        this._serverFileManager = fileManager;
    }

    public void resetTimeTolerance() {
        this._timeTolerance = 1000L;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    private void checkFileManagers() {
        if (this.getClientFileManager() == null) {
            throw new NullPointerException(Messages.Synchronizer_ClientFileManagerCannotBeNull);
        }
        if (this.getServerFileManager() == null) {
            throw new NullPointerException(Messages.Synchronizer_ServerFileManagerCannotBeNull);
        }
    }

    private void logBeginDownloading() {
        this.log(String.valueOf(FileUtils.NEW_LINE) + FileUtils.NEW_LINE + StringUtils.format((String)Messages.Synchronizer_BeginningDownload, (String)Synchronizer.getTimestamp()));
    }

    private void logBeginFullSyncing() {
        this.log(String.valueOf(FileUtils.NEW_LINE) + FileUtils.NEW_LINE + StringUtils.format((String)Messages.Synchronizer_BeginningFullSync, (String)Synchronizer.getTimestamp()));
    }

    private void logBeginUploading() {
        this.log(String.valueOf(FileUtils.NEW_LINE) + FileUtils.NEW_LINE + StringUtils.format((String)Messages.Synchronizer_BeginningUpload, (String)Synchronizer.getTimestamp()));
    }

    private void logCreatedDirectory(IFileStore file) {
        this.log(String.valueOf(FileUtils.NEW_LINE) + StringUtils.format((String)Messages.Synchronizer_CreatedDirectory, (String)EFSUtils.getAbsolutePath((IFileStore)file)));
    }

    private void logDownloading(IFileStore file) {
        this.log(String.valueOf(FileUtils.NEW_LINE) + StringUtils.format((String)Messages.Synchronizer_Downloading, (String)EFSUtils.getAbsolutePath((IFileStore)file)));
    }

    private void logDebug(String message) {
    }

    private void logError(Exception e) {
        if (this.logger != null) {
            if (e.getCause() != null) {
                this.log(StringUtils.format((String)Messages.Synchronizer_Error, (String)(String.valueOf(e.getLocalizedMessage()) + " (" + e.getCause().getLocalizedMessage() + ")")));
            } else {
                this.log(StringUtils.format((String)Messages.Synchronizer_Error, (String)e.getLocalizedMessage()));
            }
        }
    }

    private void logSuccess() {
        this.log(Messages.Synchronizer_Success);
    }

    private void logUploading(IFileStore file) {
        this.log(String.valueOf(FileUtils.NEW_LINE) + StringUtils.format((String)Messages.Synchronizer_Uploading, (String)EFSUtils.getAbsolutePath((IFileStore)file)));
    }

    private void syncDone(VirtualFileSyncPair item, IProgressMonitor monitor) {
        if (this._eventHandler != null) {
            this._eventHandler.syncDone(item);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }

    private boolean syncError(VirtualFileSyncPair item, Exception e, IProgressMonitor monitor) {
        return this._eventHandler == null || this._eventHandler.syncErrorEvent(item, e);
    }

    private boolean syncEvent(VirtualFileSyncPair item, int index, int totalItems, IProgressMonitor monitor) {
        return this._eventHandler == null || this._eventHandler.syncEvent(item, index, totalItems);
    }

    private boolean syncContinue(IProgressMonitor monitor) {
        return this._eventHandler == null || this._eventHandler.syncContinue();
    }

    private static String getTimestamp() {
        Date d = new Date();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2);
        return df.format(d);
    }

    public void disconnect() {
        try {
            this.getClientFileManager().disconnect(null);
            this.getServerFileManager().disconnect(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

