/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.syncing.core.DefaultSiteConnection;
import com.aptana.ide.syncing.core.ISiteConnectionManager;
import com.aptana.ide.syncing.core.SiteConnectionManager;
import java.io.File;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class SyncingPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.ide.syncing.core";
    private static SyncingPlugin plugin;

    public void start(BundleContext context) throws Exception {
        IPath location;
        super.start(context);
        plugin = this;
        ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, (ISaveParticipant)new WorkspaceSaveParticipant());
        if (lastState != null) {
            location = lastState.lookup((IPath)new Path("sites"));
            if (location != null) {
                SiteConnectionManager.getInstance().loadState(this.getStateLocation().append(location));
            }
            if ((location = lastState.lookup((IPath)new Path("defaultConnection"))) != null) {
                DefaultSiteConnection.getInstance().loadState(this.getStateLocation().append(location));
            }
        }
        if ((lastState = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)AptanaCorePlugin.getDefault(), new ISaveParticipant(){

            public void doneSaving(ISaveContext context) {
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
            }

            public void rollback(ISaveContext context) {
            }

            public void saving(ISaveContext context) throws CoreException {
            }
        })) != null && (location = lastState.lookup((IPath)new Path("save"))) != null) {
            IPath absoluteLocation = AptanaCorePlugin.getDefault().getStateLocation().append(location);
            SiteConnectionManager.getInstance().loadState(absoluteLocation);
            File file = absoluteLocation.toFile();
            if (!file.renameTo(new File(String.valueOf(absoluteLocation.toOSString()) + ".bak"))) {
                file.delete();
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)this);
        ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)AptanaCorePlugin.getDefault());
        plugin = null;
        super.stop(context);
    }

    public static SyncingPlugin getDefault() {
        return plugin;
    }

    public static ISiteConnectionManager getSiteConnectionManager() {
        return SiteConnectionManager.getInstance();
    }

    public static void log(IStatus status) {
        SyncingPlugin.getDefault().getLog().log(status);
    }

    public static void logError(String msg, Exception e) {
        SyncingPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    private class WorkspaceSaveParticipant
    implements ISaveParticipant {
        private WorkspaceSaveParticipant() {
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void saving(ISaveContext context) throws CoreException {
            int saveNum = context.getSaveNumber();
            IPath savePath = new Path("sites").addFileExtension(Integer.toString(saveNum));
            SiteConnectionManager.getInstance().saveState(SyncingPlugin.this.getStateLocation().append(savePath));
            context.map((IPath)new Path("sites"), savePath);
            savePath = new Path("defaultConnection").addFileExtension(Integer.toString(saveNum));
            DefaultSiteConnection.getInstance().saveState(SyncingPlugin.this.getStateLocation().append(savePath));
            context.map((IPath)new Path("defaultConnection"), savePath);
            context.needSaveNumber();
        }

        public void doneSaving(ISaveContext context) {
            int prevNum = context.getPreviousSaveNumber();
            IPath prevSavePath = new Path("sites").addFileExtension(Integer.toString(prevNum));
            SyncingPlugin.this.getStateLocation().append(prevSavePath).toFile().delete();
            prevSavePath = new Path("defaultConnection").addFileExtension(Integer.toString(prevNum));
            SyncingPlugin.this.getStateLocation().append(prevSavePath).toFile().delete();
        }

        public void rollback(ISaveContext context) {
            int saveNum = context.getSaveNumber();
            IPath savePath = new Path("sites").addFileExtension(Integer.toString(saveNum));
            SyncingPlugin.this.getStateLocation().append(savePath).toFile().delete();
            savePath = new Path("defaultConnection").addFileExtension(Integer.toString(saveNum));
            SyncingPlugin.this.getStateLocation().append(savePath).toFile().delete();
        }
    }
}

