/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public final class SyncUtils {
    private SyncUtils() {
    }

    public static void copy(IFileStore source, IFileInfo sourceInfo, IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = monitor == null ? new NullProgressMonitor() : monitor;
            SyncUtils.checkCanceled(monitor);
            monitor.beginTask("", sourceInfo == null ? 3 : 2);
            if (sourceInfo == null) {
                sourceInfo = source.fetchInfo(1024, SyncUtils.subMonitorFor(monitor, 1));
            }
            SyncUtils.checkCanceled(monitor);
            if (sourceInfo.isDirectory()) {
                destination.mkdir(0, SyncUtils.subMonitorFor(monitor, 2));
            } else {
                byte[] buffer = new byte[8192];
                long length = sourceInfo.getLength();
                int totalWork = length == -1L ? -1 : 1 + (int)(length / (long)buffer.length);
                InputStream in = null;
                OutputStream out = null;
                try {
                    in = source.openInputStream(0, SyncUtils.subMonitorFor(monitor, 0));
                    out = destination.openOutputStream(0, SyncUtils.subMonitorFor(monitor, 0));
                    IProgressMonitor subMonitor = SyncUtils.subMonitorFor(monitor, 2);
                    subMonitor.beginTask(MessageFormat.format("Copying {0}", source.toString()), totalWork);
                    while (true) {
                        int bytesRead = -1;
                        try {
                            bytesRead = in.read(buffer);
                        }
                        catch (IOException e) {
                            SyncUtils.error(MessageFormat.format("Failed reading {0}", source.toString()), e);
                        }
                        if (bytesRead == -1) break;
                        try {
                            out.write(buffer, 0, bytesRead);
                        }
                        catch (IOException e) {
                            SyncUtils.error(MessageFormat.format("Failed writing to {0}", destination.toString()), e);
                        }
                        subMonitor.worked(1);
                    }
                    subMonitor.done();
                }
                catch (Throwable throwable) {
                    SyncUtils.safeClose(in);
                    SyncUtils.safeClose(out);
                    throw throwable;
                }
                SyncUtils.safeClose(in);
                SyncUtils.safeClose(out);
            }
            destination.putInfo(sourceInfo, 0xC00 | options, SyncUtils.subMonitorFor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    private static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    private static void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static void error(String message, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "com.aptana.ide.syncing.core", message, (Throwable)e));
    }

    private static void safeClose(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static void safeClose(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {}
    }
}

