/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.ide.core.io.ConnectionPointManager;
import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.IConnectionPointCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ConnectionPointCategory
implements IConnectionPointCategory {
    private final String id;
    private final String name;
    private final int order;
    private List<ConnectionPointType> types = new ArrayList<ConnectionPointType>();

    public ConnectionPointCategory(String id, String name, int order) {
        this.id = id;
        this.name = name;
        this.order = order;
    }

    public int compareTo(Object o) {
        if (this.order != ((ConnectionPointCategory)o).order) {
            return this.order - ((ConnectionPointCategory)o).order;
        }
        return this.name.compareTo(((ConnectionPointCategory)o).name);
    }

    void addType(ConnectionPointType type) {
        this.types.add(type);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public IConnectionPoint[] getConnectionPoints() {
        ArrayList<IConnectionPoint> list = new ArrayList<IConnectionPoint>();
        for (ConnectionPointType type : this.types) {
            list.addAll(Arrays.asList(ConnectionPointManager.getInstance().getConnectionPointsForType(type.getType())));
        }
        return list.toArray(new IConnectionPoint[list.size()]);
    }

    public String toString() {
        return this.getName();
    }
}

