/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.ide.core.epl.IMemento;
import com.aptana.ide.core.epl.XMLMemento;
import com.aptana.ide.core.io.ConnectionPoint;
import com.aptana.ide.core.io.ConnectionPointCategory;
import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.IConnectionPointCategory;
import com.aptana.ide.core.io.IConnectionPointManager;
import com.aptana.ide.core.io.events.ConnectionPointEvent;
import com.aptana.ide.core.io.events.IConnectionPointListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

final class ConnectionPointManager
extends PlatformObject
implements IConnectionPointManager {
    protected static final String STATE_FILENAME = "connections";
    private static final String EXTENSION_POINT_ID = "com.aptana.ide.core.io.connectionPoint";
    protected static final String TAG_CONNECTION_POINT_TYPE = "connectionPointType";
    protected static final String TAG_CONNECTION_POINT_CATEGORY = "connectionPointCategory";
    protected static final String ATT_ID = "id";
    protected static final String ATT_NAME = "name";
    protected static final String ATT_ORDER = "order";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_CATEGORY = "category";
    private static final String ELEMENT_ROOT = "connections";
    private static final String ELEMENT_CONNECTION = "connection";
    private static final String ATTR_ID = "id";
    private static final String ATTR_TYPE = "type";
    private static ConnectionPointManager instance;
    private List<ConnectionPoint> connections = Collections.synchronizedList(new ArrayList());
    private Map<String, ConnectionPointCategory> categories = new HashMap<String, ConnectionPointCategory>();
    private List<ConnectionPointType> types = new ArrayList<ConnectionPointType>();
    private Map<String, IConfigurationElement> configurationElements = new HashMap<String, IConfigurationElement>();
    private List<IMemento> unresolvedConnections = Collections.synchronizedList(new ArrayList());
    private boolean dirty = false;
    private ListenerList listeners = new ListenerList();

    private ConnectionPointManager() {
        this.readExtensionRegistry();
    }

    public static ConnectionPointManager getInstance() {
        if (instance == null) {
            instance = new ConnectionPointManager();
        }
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadState(IPath path) {
        File file = path.toFile();
        if (!file.exists()) return;
        this.connections.clear();
        this.unresolvedConnections.clear();
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
            IMemento[] iMementoArray = memento.getChildren(ELEMENT_CONNECTION);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                ConnectionPoint connectionPoint = this.restoreConnectionPoint(child, null);
                if (connectionPoint != null) {
                    this.connections.add(connectionPoint);
                } else {
                    this.unresolvedConnections.add(child);
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (IOException iOException2) {}
            return;
        }
        catch (CoreException coreException) {
            try {
                if (reader == null) return;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(IPath path) {
        block22: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"connections");
            List<ConnectionPoint> list = this.connections;
            synchronized (list) {
                for (ConnectionPoint connectionPoint : this.connections) {
                    if (!connectionPoint.isPersistent()) continue;
                    IMemento child = memento.createChild(ELEMENT_CONNECTION);
                    child.putMemento(this.storeConnectionPoint(connectionPoint));
                }
            }
            list = this.unresolvedConnections;
            synchronized (list) {
                for (IMemento child : this.unresolvedConnections) {
                    memento.copyChild(child);
                }
            }
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(path.toFile());
                    memento.save((Writer)writer);
                    this.isChanged();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isChanged() {
        for (ConnectionPoint connectionPoint : this.connections) {
            if (!connectionPoint.isChanged()) continue;
            this.dirty = true;
        }
        try {
            boolean bl = this.dirty;
            return bl;
        }
        finally {
            this.dirty = false;
        }
    }

    private void broadcastEvent(ConnectionPointEvent event) {
        Object[] list;
        Object[] objectArray = list = this.listeners.getListeners();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IConnectionPointListener)listener).connectionPointChanged(event);
            ++n2;
        }
    }

    IConnectionPoint[] getConnectionPointsForType(String type) {
        ArrayList<ConnectionPoint> list = new ArrayList<ConnectionPoint>();
        for (ConnectionPoint connectionPoint : this.connections) {
            if (!type.equals(connectionPoint.getType())) continue;
            list.add(connectionPoint);
        }
        return list.toArray(new IConnectionPoint[list.size()]);
    }

    public void addConnectionPoint(IConnectionPoint connectionPoint) {
        if (!(connectionPoint instanceof ConnectionPoint)) {
            throw new IllegalArgumentException();
        }
        if (!this.connections.contains(connectionPoint)) {
            this.connections.add((ConnectionPoint)connectionPoint);
            this.dirty = true;
            this.broadcastEvent(new ConnectionPointEvent(this, 1, connectionPoint));
        }
    }

    public void removeConnectionPoint(IConnectionPoint connectionPoint) {
        if (this.connections.contains(connectionPoint)) {
            this.connections.remove(connectionPoint);
            this.dirty = true;
            this.broadcastEvent(new ConnectionPointEvent(this, 2, connectionPoint));
        }
    }

    public void connectionPointChanged(IConnectionPoint connectionPoint) {
        if (this.connections.contains(connectionPoint)) {
            this.dirty = true;
            this.broadcastEvent(new ConnectionPointEvent(this, 4, connectionPoint));
        }
    }

    public IConnectionPoint cloneConnectionPoint(IConnectionPoint connectionPoint) throws CoreException {
        IMemento memento;
        if (!(connectionPoint instanceof ConnectionPoint)) {
            throw new IllegalArgumentException();
        }
        try {
            memento = this.storeConnectionPoint((ConnectionPoint)connectionPoint);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.core.io", "Store connection properties failed", (Throwable)e));
        }
        ConnectionPoint clonedConnectionPoint = this.restoreConnectionPoint(memento, UUID.randomUUID().toString());
        return clonedConnectionPoint;
    }

    public ConnectionPointType[] getTypes() {
        return this.types.toArray(new ConnectionPointType[this.types.size()]);
    }

    public ConnectionPointType getType(String typeId) {
        for (ConnectionPointType type : this.types) {
            if (!type.getType().equals(typeId)) continue;
            return type;
        }
        return null;
    }

    public ConnectionPointType getType(IConnectionPoint connectionPoint) {
        if (!(connectionPoint instanceof ConnectionPoint)) {
            throw new IllegalArgumentException();
        }
        return this.getType(((ConnectionPoint)connectionPoint).getType());
    }

    public IConnectionPointCategory[] getConnectionPointCategories() {
        return this.categories.values().toArray(new IConnectionPointCategory[this.categories.size()]);
    }

    public IConnectionPointCategory getConnectionPointCategory(String categoryId) {
        return this.categories.get(categoryId);
    }

    public IConnectionPoint[] getConnectionPoints() {
        return this.connections.toArray(new IConnectionPoint[this.connections.size()]);
    }

    private IMemento storeConnectionPoint(ConnectionPoint connectionPoint) {
        IMemento saveMemento = XMLMemento.createWriteRoot((String)"connections").createChild(ELEMENT_CONNECTION);
        connectionPoint.saveState(saveMemento);
        saveMemento.putString("id", connectionPoint.getId());
        saveMemento.putString(ATTR_TYPE, connectionPoint.getType());
        return saveMemento;
    }

    private ConnectionPoint restoreConnectionPoint(IMemento memento, String id) throws CoreException {
        Object object;
        IConfigurationElement element;
        ConnectionPoint connectionPoint = null;
        String typeId = memento.getString(ATTR_TYPE);
        if (typeId != null && (element = this.configurationElements.get(typeId)) != null && (object = element.createExecutableExtension(ATT_CLASS)) instanceof ConnectionPoint) {
            connectionPoint = (ConnectionPoint)object;
            connectionPoint.setId(id != null ? id : memento.getString("id"));
            connectionPoint.loadState(memento);
        }
        return connectionPoint;
    }

    public ConnectionPoint restore15ConnectionPoint(String type, String data) throws CoreException {
        Object object;
        IConfigurationElement element;
        ConnectionPoint connectionPoint = null;
        String typeId = null;
        if (type.equals("com.aptana.ide.core.ui.io.file.LocalFileManager")) {
            typeId = "local";
        } else if (type.equals("com.aptana.ide.core.ui.io.file.ProjectFileManager")) {
            typeId = "workspace";
        } else if (type.equals("com.aptana.ide.io.ftp.FtpVirtualFileManager")) {
            typeId = "ftp";
        } else if (type.equals("com.aptana.ide.io.sftp.SftpVirtualFileManager")) {
            typeId = "sftp";
        } else if (type.equals("com.aptana.ide.io.ftps.FtpsVirtualFileManager")) {
            typeId = "ftps";
        }
        if (typeId != null && (element = this.configurationElements.get(typeId)) != null && (object = element.createExecutableExtension(ATT_CLASS)) instanceof ConnectionPoint && !(connectionPoint = (ConnectionPoint)object).load15Data(data)) {
            return null;
        }
        return connectionPoint;
    }

    public IConnectionPoint createConnectionPoint(ConnectionPointType type) throws CoreException {
        if (type != null) {
            return this.createConnectionPoint(type.getType());
        }
        return null;
    }

    public IConnectionPoint createConnectionPoint(String typeId) throws CoreException {
        Object object;
        ConnectionPoint connectionPoint = null;
        IConfigurationElement element = this.configurationElements.get(typeId);
        if (element != null && (object = element.createExecutableExtension(ATT_CLASS)) instanceof ConnectionPoint) {
            connectionPoint = (ConnectionPoint)object;
        }
        return connectionPoint;
    }

    public void addConnectionPointListener(IConnectionPointListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeConnectionPointListener(IConnectionPointListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void readExtensionRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < elements.length) {
            this.readElement(elements[i], TAG_CONNECTION_POINT_CATEGORY);
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            this.readElement(elements[i], TAG_CONNECTION_POINT_TYPE);
            ++i;
        }
    }

    private void readElement(IConfigurationElement element, String elementName) {
        if (!elementName.equals(element.getName())) {
            return;
        }
        if (TAG_CONNECTION_POINT_CATEGORY.equals(element.getName())) {
            String id = element.getAttribute("id");
            if (id == null || id.length() == 0) {
                return;
            }
            String name = element.getAttribute(ATT_NAME);
            if (name == null || name.length() == 0) {
                return;
            }
            int order = 127;
            try {
                order = Integer.parseInt(element.getAttribute(ATT_ORDER));
            }
            catch (NumberFormatException numberFormatException) {}
            this.categories.put(id, new ConnectionPointCategory(id, name, order));
        } else if (TAG_CONNECTION_POINT_TYPE.equals(element.getName())) {
            String defaultCategoryId;
            String clazz;
            String typeId = element.getAttribute("id");
            if (typeId == null || typeId.length() == 0) {
                return;
            }
            String name = element.getAttribute(ATT_NAME);
            if (name == null || name.length() == 0) {
                return;
            }
            String categoryId = element.getAttribute(ATT_CATEGORY);
            if (categoryId == null || categoryId.length() == 0) {
                categoryId = "";
            }
            if ((clazz = element.getAttribute(ATT_CLASS)) == null || clazz.length() == 0) {
                return;
            }
            this.configurationElements.put(typeId, element);
            ConnectionPointCategory category = this.categories.get(categoryId);
            if (category == null && (category = this.categories.get(defaultCategoryId = "unknown")) == null) {
                category = new ConnectionPointCategory(defaultCategoryId, "Unknown", Integer.MAX_VALUE);
                this.categories.put(defaultCategoryId, category);
            }
            ConnectionPointType type = new ConnectionPointType(typeId, name, category);
            this.types.add(type);
            category.addType(type);
        }
    }
}

