/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.ide.core.PlatformUtils;
import com.aptana.ide.core.io.efs.LocalFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;

public final class LocalRoot
extends PlatformObject {
    private static final String HOME_DIR = PlatformUtils.expandEnvironmentStrings((String)PlatformUtils.HOME_DIRECTORY);
    private static final String DESKTOP = PlatformUtils.expandEnvironmentStrings((String)"%DesktopDirectory%");
    private static final boolean ON_WINDOWS = "win32".equals(Platform.getOS());
    private final String name;
    private final File root;

    private LocalRoot(String name, File root) {
        this.name = name;
        this.root = root;
    }

    public String getName() {
        return this.name;
    }

    public URI getRootURI() {
        return new LocalFile(this.root).toURI();
    }

    public IFileStore getRoot() {
        return new LocalFile(this.root);
    }

    public Object getAdapter(Class adapter) {
        if (File.class == adapter) {
            return this.getFile();
        }
        if (IFileStore.class == adapter) {
            return this.getRoot();
        }
        return super.getAdapter(adapter);
    }

    public File getFile() {
        return this.root;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalRoot)) {
            return false;
        }
        return this.root.equals(((LocalRoot)((Object)obj)).root);
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public String toString() {
        return this.getFile().toString();
    }

    public static LocalRoot[] createRoots() {
        Path docsPath;
        File docsFile;
        File desktopFile;
        File homeFile;
        File root;
        int n;
        ArrayList<LocalRoot> list = new ArrayList<LocalRoot>();
        if ("macosx".equals(Platform.getOS())) {
            File[] fileArray = new File("/Volumes").listFiles();
            int n2 = fileArray.length;
            n = 0;
            while (n < n2) {
                root = fileArray[n];
                try {
                    if (root.listFiles() != null) {
                        LocalRoot localRoot = new LocalRoot(root.getName(), root.getCanonicalFile());
                        if ("/".equals(localRoot.getFile().getCanonicalPath())) {
                            list.add(0, localRoot);
                        } else {
                            list.add(localRoot);
                        }
                    }
                }
                catch (IOException iOException) {}
                ++n;
            }
        } else if (!ON_WINDOWS) {
            File[] fileArray = File.listRoots();
            int n3 = fileArray.length;
            n = 0;
            while (n < n3) {
                root = fileArray[n];
                try {
                    list.add(new LocalRoot(root.getName(), root.getCanonicalFile()));
                }
                catch (IOException iOException) {}
                ++n;
            }
        }
        if (ON_WINDOWS) {
            homeFile = LocalRoot.getWindowsHomeFile();
        } else {
            Path homePath = new Path(HOME_DIR);
            homeFile = homePath.toFile();
        }
        if (homeFile != null && homeFile.exists() && homeFile.isDirectory()) {
            try {
                list.add(new LocalRoot(homeFile.getName(), homeFile.getCanonicalFile()));
            }
            catch (IOException iOException) {}
        }
        if (ON_WINDOWS) {
            desktopFile = LocalRoot.getWindowsDesktopFile();
        } else {
            Path desktopPath = new Path(DESKTOP);
            desktopFile = desktopPath.toFile();
        }
        if (desktopFile != null && desktopFile.exists() && desktopFile.isDirectory()) {
            try {
                list.add(new LocalRoot(desktopFile.getName(), desktopFile.getCanonicalFile()));
            }
            catch (IOException iOException) {}
        }
        if ((docsFile = (docsPath = new Path(PlatformUtils.expandEnvironmentStrings((String)"%DocumentsDirectory%"))).toFile()).exists() && docsFile.isDirectory()) {
            try {
                list.add(new LocalRoot(docsPath.lastSegment(), docsFile.getCanonicalFile()));
            }
            catch (IOException iOException) {}
        }
        return list.toArray(new LocalRoot[list.size()]);
    }

    public static LocalRoot[] createWindowsSubroots(File root) {
        File[] drives = FileSystemView.getFileSystemView().getFiles(root, false);
        ArrayList<LocalRoot> subroots = new ArrayList<LocalRoot>();
        File[] fileArray = drives;
        int n = drives.length;
        int n2 = 0;
        while (n2 < n) {
            File drive = fileArray[n2];
            try {
                subroots.add(new LocalRoot(FileSystemView.getFileSystemView().getSystemDisplayName(drive), drive.getCanonicalFile()));
            }
            catch (IOException iOException) {}
            ++n2;
        }
        return subroots.toArray(new LocalRoot[subroots.size()]);
    }

    private static File getWindowsHomeFile() {
        File[] files;
        File desktop = LocalRoot.getWindowsDesktopFile();
        if (desktop == null) {
            return null;
        }
        Path homePath = new Path(HOME_DIR);
        String homeFilename = homePath.lastSegment();
        File[] fileArray = files = FileSystemView.getFileSystemView().getFiles(desktop, false);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().equals(homeFilename)) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    private static File getWindowsDesktopFile() {
        File[] files;
        Path desktopPath = new Path(DESKTOP);
        String desktopFilename = desktopPath.lastSegment();
        File[] fileArray = files = FileSystemView.getFileSystemView().getRoots();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().equals(desktopFilename)) {
                return file;
            }
            ++n2;
        }
        return null;
    }
}

