/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.efs;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.URLEncoder;
import com.aptana.ide.core.io.InfiniteProgressMonitor;
import com.aptana.ide.core.io.efs.FileTree;
import com.aptana.ide.core.io.preferences.CloakingUtils;
import com.aptana.ide.core.io.vfs.IConnectionFileManager;
import com.aptana.ide.core.io.vfs.IExtendedFileInfo;
import com.aptana.ide.core.io.vfs.IExtendedFileStore;
import com.aptana.ide.core.io.vfs.IFileTreeVisitor;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileTree;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

class VirtualFile
extends FileStore
implements IExtendedFileStore {
    private IConnectionFileManager fileManager;
    private URI baseURI;
    private IPath path;

    public VirtualFile(IConnectionFileManager fileManager, URI baseURI, IPath path) {
        this.fileManager = fileManager;
        this.baseURI = baseURI;
        this.path = path;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return this.fileManager.childNames(this.path, options, monitor);
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        return this.fileManager.childInfos(this.path, options, monitor);
    }

    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        return super.childStores(options, monitor);
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return this.fileManager.fetchInfo(this.path, options, monitor);
    }

    public IFileStore getChild(String name) {
        return new VirtualFile(this.fileManager, this.baseURI, this.path.append(name));
    }

    public String getName() {
        return this.path.segmentCount() == 0 ? this.path.toPortableString() : this.path.lastSegment();
    }

    public IFileStore getParent() {
        if (this.path.isRoot()) {
            return null;
        }
        return new VirtualFile(this.fileManager, this.baseURI, this.path.removeLastSegments(1));
    }

    public boolean isParentOf(IFileStore other) {
        if (other instanceof VirtualFile) {
            VirtualFile otherFile = (VirtualFile)other;
            return this.baseURI.equals(otherFile.baseURI) && (this.path.isRoot() && !otherFile.path.isRoot() || this.path.matchingFirstSegments(otherFile.path) == this.path.segmentCount() && this.path.segmentCount() <= otherFile.path.segmentCount());
        }
        return false;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.fileManager.openInputStream(this.path, options, monitor);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.fileManager.openOutputStream(this.path, options, monitor);
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        this.fileManager.delete(this.path, options, monitor);
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        this.fileManager.mkdir(this.path, options, monitor);
        return this;
    }

    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if (CloakingUtils.isFileCloaked(this)) {
            return;
        }
        if (destination instanceof VirtualFile && ((VirtualFile)destination).toCanonicalURI().equals(this.toCanonicalURI())) {
            return;
        }
        super.copy(destination, options, monitor);
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if (destination instanceof VirtualFile) {
            if (((VirtualFile)destination).toCanonicalURI().equals(this.toCanonicalURI())) {
                return;
            }
            if (((VirtualFile)destination).fileManager == this.fileManager) {
                this.fileManager.move(this.path, ((VirtualFile)destination).path, options, monitor);
                return;
            }
        }
        super.move(destination, options, monitor);
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        this.fileManager.putInfo(this.path, info, options &= 0xFFFFFBFF, monitor);
    }

    public URI toURI() {
        return this.baseURI.resolve(URLEncoder.encode((String)this.path.toPortableString(), null, null));
    }

    public URI toCanonicalURI() {
        return this.fileManager.getCanonicalURI(this.path);
    }

    public IFileTree fetchFileTree(IFileTreeVisitor visitor, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            FileTree fileTree = new FileTree(this);
            VirtualFile.buildFileTree(fileTree, this, visitor, (IProgressMonitor)new InfiniteProgressMonitor(monitor));
            FileTree fileTree2 = fileTree;
            return fileTree2;
        }
        finally {
            monitor.done();
        }
    }

    public String toString() {
        return this.toCanonicalURI().toString();
    }

    private static void buildFileTree(FileTree fileTree, VirtualFile parent, IFileTreeVisitor visitor, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(StringUtils.format((String)"Listing directory {0}", (Object)parent.path), 20);
        IFileInfo[] infos = parent.fileManager.childInfos(parent.path, 1024, monitor);
        ArrayList<IFileStore> stores = new ArrayList<IFileStore>();
        ArrayList<IFileStore> dirs = new ArrayList<IFileStore>();
        IFileInfo[] iFileInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IExtendedFileInfo fileInfo = iFileInfoArray[n2];
            IFileStore store = parent.getChild(fileInfo.getName());
            if (visitor == null || visitor.include(store)) {
                stores.add(store);
                if (fileInfo.isDirectory()) {
                    dirs.add(store);
                }
            }
            ++n2;
        }
        fileTree.addChildren(parent, stores.toArray(new IFileStore[stores.size()]), infos);
        monitor.worked(1);
        for (IFileStore store : dirs) {
            VirtualFile.buildFileTree(fileTree, (VirtualFile)store, visitor, monitor);
        }
    }
}

