/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.efs;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.efs.LocalFile;
import com.aptana.ide.core.io.efs.WorkspaceFileSystem;
import com.aptana.ide.core.io.preferences.CloakingUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;

class WorkspaceFile
extends FileStore {
    private static final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private IResource resource;
    private final IPath path;
    private IFileStore localFileStore;
    private static boolean refreshed = false;

    public WorkspaceFile(IResource resource) {
        this(resource, resource.getFullPath());
    }

    public WorkspaceFile(IPath path) {
        this(null, path);
    }

    private WorkspaceFile(IResource resource, IPath path) {
        this.resource = resource;
        this.path = path;
    }

    public Object getAdapter(Class adapter) {
        if (IResource.class == adapter) {
            try {
                this.ensureResource();
            }
            catch (CoreException coreException) {}
            return this.resource;
        }
        return super.getAdapter(adapter);
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureResource();
        if (this.resource instanceof IContainer) {
            IContainer container = (IContainer)this.resource;
            if (!container.isSynchronized(1)) {
                container.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            final ArrayList childNames = new ArrayList();
            final boolean[] skipSelf = new boolean[]{true};
            container.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (skipSelf[0]) {
                        skipSelf[0] = false;
                        return true;
                    }
                    childNames.add(proxy.getName());
                    return false;
                }
            }, 8);
            return childNames.toArray(new String[childNames.size()]);
        }
        return EMPTY_STRING_ARRAY;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureLocalFileStore();
        if (this.localFileStore != null) {
            return this.localFileStore.fetchInfo(options, monitor);
        }
        FileInfo info = new FileInfo(this.path.lastSegment());
        info.setExists(false);
        return info;
    }

    public IFileStore getChild(String name) {
        return new WorkspaceFile(this.path.append(name));
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public IFileStore getParent() {
        return new WorkspaceFile(this.path.removeLastSegments(1));
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureLocalFileStore();
        if (this.localFileStore != null) {
            return this.localFileStore.openInputStream(options, monitor);
        }
        Policy.error((int)271, (String)NLS.bind((String)Messages.fileNotFound, (Object)this.path));
        return null;
    }

    public URI toURI() {
        try {
            return new URI("workspace", this.path.toPortableString(), null);
        }
        catch (URISyntaxException e) {
            IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if (CloakingUtils.isFileCloaked((IFileStore)this)) {
            return;
        }
        this.ensureLocalFileStore();
        if (this.localFileStore != null) {
            this.localFileStore.copy(destination, options, monitor);
        } else {
            super.copy(destination, options, monitor);
        }
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureLocalFileStore();
        if (this.localFileStore != null) {
            this.localFileStore.delete(options, monitor);
        }
    }

    public IFileStore getFileStore(IPath path) {
        return new WorkspaceFile(this.path.append(path));
    }

    public IFileSystem getFileSystem() {
        return WorkspaceFileSystem.getInstance();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WorkspaceFile)) {
            return false;
        }
        return this.path.equals((Object)((WorkspaceFile)((Object)obj)).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureLocalFileStore(true);
        if (this.localFileStore != null) {
            try {
                this.localFileStore.mkdir(options, monitor);
            }
            finally {
                this.localFileStore = null;
            }
        }
        return this;
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if (!(destination instanceof WorkspaceFile)) {
            this.ensureLocalFileStore();
            if (this.localFileStore != null) {
                this.localFileStore.move(destination, options, monitor);
                return;
            }
            Policy.error((int)269, (String)NLS.bind((String)Messages.fileNotFound, (Object)this.path));
        }
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        monitor.beginTask(NLS.bind((String)Messages.moving, (Object)destination.toString()), 100);
        WorkspaceFile destinationFile = (WorkspaceFile)destination;
        try {
            boolean overwrite;
            Object destinationResource;
            this.ensureResource();
            if (this.resource == null) {
                Policy.error((int)269, (String)NLS.bind((String)Messages.fileNotFound, (Object)this.path));
            }
            if ((destinationResource = (IResource)destinationFile.getAdapter(IResource.class)) == null) {
                destinationResource = this.resource instanceof IContainer ? workspaceRoot.getFolder(destinationFile.path) : workspaceRoot.getFile(destinationFile.path);
            }
            boolean sourceEqualsDest = this.resource.equals(destinationResource);
            boolean bl = overwrite = (options & 2) != 0;
            if (!sourceEqualsDest && !overwrite && destinationResource.exists()) {
                Policy.error((int)268, (String)NLS.bind((String)Messages.fileExists, (Object)destinationResource.getFullPath()));
            }
            try {
                this.resource.move(destinationResource.getFullPath(), true, Policy.subMonitorFor((IProgressMonitor)monitor, (int)100));
            }
            catch (CoreException e) {
                Policy.error((int)272, (String)NLS.bind((String)Messages.failedMove, (Object)this.toString(), (Object)destination.toString()), (Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        this.ensureLocalFileStore();
        if (this.localFileStore != null) {
            this.localFileStore.putInfo(info, options, monitor);
        } else {
            Policy.error((int)269, (String)NLS.bind((String)Messages.fileNotFound, (Object)this.path));
        }
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureLocalFileStore();
        if (this.localFileStore != null) {
            return this.localFileStore.toLocalFile(options, monitor);
        }
        return null;
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        this.ensureLocalFileStore(true);
        if (this.localFileStore != null) {
            return this.localFileStore.openOutputStream(options, monitor);
        }
        return null;
    }

    public String toString() {
        return this.path.toString();
    }

    private void ensureResource() throws CoreException {
        if (!refreshed) {
            workspaceRoot.refreshLocal(2, null);
            refreshed = true;
        }
        if (!(this.resource == null || this.resource.isSynchronized(0) && this.resource.exists())) {
            this.resource = null;
            this.localFileStore = null;
        }
        if (this.resource == null) {
            IWorkspaceRoot res = workspaceRoot;
            String[] stringArray = this.path.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (!(res instanceof IContainer)) {
                    res = null;
                    break;
                }
                IContainer container = (IContainer)res;
                res = container.findMember(name);
                ++n2;
            }
            this.resource = res;
        }
    }

    private void ensureLocalFileStore() throws CoreException {
        this.ensureLocalFileStore(false);
    }

    private void ensureLocalFileStore(boolean force) throws CoreException {
        this.ensureResource();
        if (this.localFileStore == null) {
            if (this.resource != null && this.resource.exists()) {
                this.localFileStore = new LocalFile(this.resource.getLocation().toFile());
            } else if (force) {
                IWorkspaceRoot parent = workspaceRoot;
                IPath relativePath = null;
                int i = 0;
                while (i < this.path.segmentCount()) {
                    IResource member;
                    if (parent instanceof IContainer) {
                        member = ((IContainer)parent).findMember(this.path.segment(i));
                        if (member == null) {
                            relativePath = this.path.removeFirstSegments(i);
                            break;
                        }
                    } else {
                        parent = null;
                        break;
                    }
                    parent = member;
                    ++i;
                }
                if (parent != null & relativePath != null) {
                    this.localFileStore = new LocalFile(parent.getLocation().toFile()).getFileStore(relativePath);
                }
            }
        }
    }

    public static IFileStore fromLocalFile(File file) {
        IContainer resource = null;
        if (file.isDirectory()) {
            resource = workspaceRoot.getContainerForLocation(Path.fromOSString((String)file.getAbsolutePath()));
        } else if (file.isFile()) {
            resource = workspaceRoot.getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()));
        }
        if (resource != null) {
            return new WorkspaceFile((IResource)resource);
        }
        return null;
    }
}

