/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.efs;

import com.aptana.ide.core.io.efs.WorkspaceFile;
import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WorkspaceFileSystem
extends FileSystem {
    public static final String SCHEME_WORKSPACE = "workspace";
    private static WorkspaceFileSystem instance;

    public WorkspaceFileSystem() {
        instance = this;
    }

    public static IFileSystem getInstance() {
        if (instance == null) {
            try {
                EFS.getFileSystem((String)SCHEME_WORKSPACE);
            }
            catch (CoreException e) {
                throw new Error(e);
            }
        }
        return instance;
    }

    public int attributes() {
        return EFS.getLocalFileSystem().attributes();
    }

    public boolean canDelete() {
        return EFS.getLocalFileSystem().canDelete();
    }

    public boolean canWrite() {
        return EFS.getLocalFileSystem().canWrite();
    }

    public IFileStore fromLocalFile(File file) {
        return WorkspaceFile.fromLocalFile(file);
    }

    public IFileStore getStore(IPath path) {
        return new WorkspaceFile(path);
    }

    public IFileStore getStore(URI uri) {
        return new WorkspaceFile((IPath)new Path(uri.getPath()));
    }

    public boolean isCaseSensitive() {
        return EFS.getLocalFileSystem().isCaseSensitive();
    }
}

