/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.preferences;

import com.aptana.ide.core.StringUtils;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class CloakingUtils {
    public static void addCloakFileType(String filetype) {
        ArrayList<String> newList = new ArrayList<String>();
        String[] filetypes = CloakingUtils.getCloakedFileTypes();
        boolean found = false;
        String[] stringArray = filetypes;
        int n = filetypes.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (extension.equals(filetype)) {
                found = true;
            }
            newList.add(extension);
            ++n2;
        }
        if (!found) {
            newList.add(filetype);
        }
        CloakingUtils.setCloakedFileTypes(newList.toArray(new String[newList.size()]));
    }

    public static void removeCloakFileType(String filetype) {
        String[] filetypes;
        ArrayList<String> newList = new ArrayList<String>();
        String[] stringArray = filetypes = CloakingUtils.getCloakedFileTypes();
        int n = filetypes.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (!extension.equals(filetype)) {
                newList.add(extension);
            }
            ++n2;
        }
        CloakingUtils.setCloakedFileTypes(newList.toArray(new String[newList.size()]));
    }

    public static void cloakFileName(IFileStore fileStore) {
        CloakingUtils.addCloakFileType(fileStore.getName());
    }

    public static boolean isFileCloaked(IFileStore fileStore) {
        String[] expressions;
        String filename = fileStore.getName();
        String[] stringArray = expressions = CloakingUtils.getCloakedExpressions();
        int n = expressions.length;
        int n2 = 0;
        while (n2 < n) {
            String expression = stringArray[n2];
            if (filename.matches(expression)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String[] getCloakedExpressions() {
        String[] filetypes = CloakingUtils.getCloakedFileTypes();
        String[] expressions = new String[filetypes.length];
        int i = 0;
        while (i < expressions.length) {
            expressions[i] = CloakingUtils.convertCloakExpressionToRegex(filetypes[i]);
            ++i;
        }
        return expressions;
    }

    private static String convertCloakExpressionToRegex(String expression) {
        if (expression == null) {
            return null;
        }
        String result = null;
        if (expression.startsWith("/") && expression.endsWith("/")) {
            return expression.substring(1, expression.length() - 1);
        }
        if (expression.contains("\\")) {
            expression = expression.replaceAll("\\\\", "/");
        }
        result = expression.replaceAll("\\.(?=[^\\*])", "\\\\.");
        result = "(?i)" + result.replaceAll("(?<!\\.)\\*", ".*");
        return result;
    }

    private static String[] getCloakedFileTypes() {
        String extensions = Platform.getPreferencesService().getString("com.aptana.ide.core.io", "GLOBAL_CLOAKING_EXTENSIONS", ".svn;.tmp*~;.settings;CVS;.git;.DS_Store", null);
        if (extensions.equals("")) {
            return new String[0];
        }
        return extensions.split(";");
    }

    private static void setCloakedFileTypes(String[] filetypes) {
        String value = StringUtils.join((String)";", (String[])filetypes);
        IEclipsePreferences prefs = new InstanceScope().getNode("com.aptana.ide.core.io");
        prefs.put("GLOBAL_CLOAKING_EXTENSIONS", value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }
}

