/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.text.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.EclipseUIUtils;
import com.aptana.ide.editor.text.TextPlugin;
import com.aptana.ide.editor.text.preferences.Messages;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.preferences.PreferenceMastHead;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.colorizer.ColorizerReader;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizationWidget;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.colorizer.LanguageStructureProvider;
import com.aptana.ide.lexer.TokenList;
import com.aptana.sax.AttributeSniffer;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.FileExtensionDialog;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.progress.UIJob;

public class TextEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite displayArea;
    private PreferenceMastHead header;
    private Label description;
    private Button add;
    private Button remove;
    private Table typesTable;
    private Text grammarText;
    private Button browseGrammar;
    private Button applyChanges;
    private EditorDescriptor descriptor;
    private List<FileEditorMapping> mappings;
    private List<Image> imagesToDispose;
    private boolean changed;
    private Group grammarGroup;
    private Group colorizerGroup;
    private IPreferenceStore store;
    private Map<String, String> mappingsToGrammars;
    private Map<String, LanguageStructureProvider> activeProviders;
    private LanguageColorizationWidget colorizer;
    private SelectionAdapter tableSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableItem item = TextEditorPreferencePage.this.typesTable.getSelection()[0];
            TextEditorPreferencePage.this.browseGrammar.setEnabled(true);
            String gText = TextEditorPreferencePage.this.mappingsToGrammars.containsKey(item.getText()) ? (String)TextEditorPreferencePage.this.mappingsToGrammars.get(item.getText()) : "";
            TextEditorPreferencePage.this.grammarText.setText(gText);
            String colorizerId = TextPlugin.getColorizerPreference(item.getText());
            if (TextEditorPreferencePage.this.activeProviders.containsKey(colorizerId)) {
                LanguageStructureProvider provider = (LanguageStructureProvider)TextEditorPreferencePage.this.activeProviders.get(colorizerId);
                TextEditorPreferencePage.this.colorizer.setProvider(provider);
            } else {
                AttributeSniffer sniffer = new AttributeSniffer("lexer", "language");
                try {
                    sniffer.read(gText);
                    String language = sniffer.getMatchedValue();
                    if (language != null) {
                        ColorizerReader reader;
                        LanguageColorizer lc;
                        if (!LanguageRegistry.hasTokenList((String)language)) {
                            FileInputStream input = new FileInputStream(gText);
                            TokenList tokenList = LanguageRegistry.createTokenList((InputStream)input);
                            LanguageRegistry.registerTokenList((TokenList)tokenList);
                        }
                        if ((lc = (reader = new ColorizerReader()).loadColorization(colorizerId, true)) == null) {
                            lc = new LanguageColorizer(language);
                            LanguageRegistry.registerLanguageColorizer((String)language, (LanguageColorizer)lc);
                            LanguageRegistry.setPreferenceId((String)language, (String)colorizerId);
                        }
                        LanguageStructureProvider provider = new LanguageStructureProvider(language);
                        TextEditorPreferencePage.this.colorizer.setProvider(provider);
                        TextEditorPreferencePage.this.activeProviders.put(colorizerId, provider);
                    }
                }
                catch (Exception exception) {
                    TextEditorPreferencePage.this.colorizer.setProvider(null);
                }
            }
            TextEditorPreferencePage.this.remove.setEnabled(true);
        }
    };

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.changed = false;
        this.imagesToDispose = new ArrayList<Image>();
        this.mappings = new ArrayList<FileEditorMapping>();
        this.mappingsToGrammars = new HashMap<String, String>();
        this.activeProviders = new HashMap<String, LanguageStructureProvider>();
        this.displayArea = new Composite(parent, 0);
        final Composite buffer = new Composite(this.displayArea, 0);
        this.header = new PreferenceMastHead(buffer, Messages.TextEditorPreferencePage_Allows_Users_To_Create_Custom_Editors, 3, TextPlugin.getImageDescriptor("images/generic_file.png"));
        buffer.setLayoutData((Object)new GridData(4, 4, true, false));
        buffer.setBackground(PreferenceMastHead.HEADER_BG_COLOR);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 10;
        this.displayArea.setLayout((Layout)layout);
        buffer.setLayout((Layout)layout);
        buffer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = new GC((Drawable)buffer);
                gc.setBackground(PreferenceMastHead.FOOTER_BG_COLOR);
                if (buffer.getSize().y - 4 >= 0) {
                    gc.fillRectangle(0, buffer.getSize().y - 5, buffer.getSize().x, 5);
                }
            }
        });
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.description = new Label(this.displayArea, 16448);
        this.description.setText(Messages.TextEditorPreferencePage_ASSOCIATED_FILE_EXTENSIONS);
        Composite middle = new Composite(this.displayArea, 0);
        layout = new GridLayout(2, false);
        GridData middleData = new GridData(4, 4, true, false);
        middleData.heightHint = 120;
        middle.setLayout((Layout)layout);
        middle.setLayoutData((Object)middleData);
        this.typesTable = new Table(middle, 2564);
        this.typesTable.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 100;
        this.typesTable.setLayoutData((Object)data);
        this.typesTable.addSelectionListener((SelectionListener)this.tableSelectionListener);
        Composite buttons = new Composite(middle, 0);
        layout = new GridLayout(1, true);
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true));
        this.add = new Button(buttons, 8);
        this.add.setText(StringUtils.ellipsify((String)Messages.TextEditorPreferencePage_ADD));
        this.add.setLayoutData((Object)new GridData(4, 4, true, false));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileExtensionDialog dialog = new FileExtensionDialog(TextEditorPreferencePage.this.displayArea.getShell());
                if (dialog.open() == 0) {
                    IFileEditorMapping newMapping;
                    TextEditorPreferencePage.this.changed = true;
                    String newName = dialog.getName();
                    String newExtension = dialog.getExtension();
                    String newFilename = (String.valueOf(newName) + (newExtension == null || newExtension.length() == 0 ? "" : "." + newExtension)).toUpperCase();
                    TableItem[] items = TextEditorPreferencePage.this.typesTable.getItems();
                    boolean found = false;
                    int i = 0;
                    while (i < items.length && !found) {
                        newMapping = (IFileEditorMapping)items[i].getData();
                        int result = newFilename.compareToIgnoreCase(newMapping.getLabel());
                        if (result == 0) {
                            MessageDialog.openInformation((Shell)TextEditorPreferencePage.this.getControl().getShell(), (String)Messages.TextEditorPreferencePage_FILE_TYPE_EXISTS, (String)Messages.TextEditorPreferencePage_FILE_TYPE_EXISTS_TITLE);
                            return;
                        }
                        if (result < 0) {
                            found = true;
                            continue;
                        }
                        ++i;
                    }
                    newMapping = TextEditorPreferencePage.this.getFileEditorMapping(newName, newExtension);
                    TextEditorPreferencePage.this.addTypesTableItem(newMapping, i);
                    TextEditorPreferencePage.this.typesTable.setFocus();
                    TextEditorPreferencePage.this.typesTable.setSelection(i);
                    TextEditorPreferencePage.this.tableSelectionListener.widgetSelected(null);
                }
            }
        });
        this.remove = new Button(buttons, 8);
        this.remove.setText(Messages.TextEditorPreferencePage_REMOVE_ASSOCIATION);
        this.remove.setEnabled(false);
        this.remove.setLayoutData((Object)new GridData(4, 4, true, false));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextEditorPreferencePage.this.typesTable.getSelectionCount() == 1) {
                    TextEditorPreferencePage.this.changed = true;
                    TableItem item = TextEditorPreferencePage.this.typesTable.getSelection()[0];
                    FileEditorMapping data = (FileEditorMapping)item.getData();
                    TextEditorPreferencePage.this.mappings.remove(data);
                    TextEditorPreferencePage.this.browseGrammar.setEnabled(false);
                    TextEditorPreferencePage.this.grammarText.setText("");
                    TextEditorPreferencePage.this.remove.setEnabled(false);
                    String label = item.getText();
                    String prefId = TextPlugin.getColorizerPreference(label);
                    UnifiedEditorsPlugin.getDefault().getPreferenceStore().setValue(prefId, "");
                    LanguageStructureProvider provider = (LanguageStructureProvider)TextEditorPreferencePage.this.activeProviders.remove(prefId);
                    if (provider != null) {
                        LanguageRegistry.unregisterLanguageColorizer((String)provider.getLanguage());
                        TokenList tokenList = LanguageRegistry.getTokenList((String)provider.getLanguage());
                        if (tokenList != null) {
                            LanguageRegistry.unregisterTokenList((TokenList)tokenList);
                        }
                        UnifiedEditorsPlugin.getDefault().getPreferenceStore().firePropertyChangeEvent("Colorization removed", (Object)"Colorization removed", (Object)"Colorization removed");
                    }
                    TextEditorPreferencePage.this.colorizer.setProvider(null);
                    item.dispose();
                }
            }
        });
        IEditorRegistry registry = EclipseUIUtils.getWorkbenchEditorRegistry();
        this.descriptor = (EditorDescriptor)registry.findEditor("com.aptana.ide.editor.text");
        IFileEditorMapping[] array = registry.getFileEditorMappings();
        int count = 0;
        int i = 0;
        while (i < array.length) {
            FileEditorMapping mapping = (FileEditorMapping)array[i];
            mapping = (FileEditorMapping)mapping.clone();
            this.mappings.add(mapping);
            if (mapping.getDefaultEditor() != null && mapping.getDefaultEditor().getId().equals("com.aptana.ide.editor.text")) {
                String label = mapping.getLabel();
                String extension = mapping.getExtension();
                if (LanguageRegistry.getTokenListByExtension((String)extension) == null) {
                    String grammarFile = this.store.getString(TextPlugin.getGrammarPreference(label));
                    if (!grammarFile.equals("")) {
                        this.mappingsToGrammars.put(label, grammarFile);
                    }
                    this.addTypesTableItem((IFileEditorMapping)mapping, count);
                    ++count;
                }
            }
            ++i;
        }
        this.grammarGroup = new Group(this.displayArea, 0);
        this.grammarGroup.setLayout((Layout)new GridLayout(2, false));
        this.grammarGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.grammarGroup.setText(Messages.TextEditorPreferencePage_GRAMMAR_FILE);
        this.grammarText = new Text((Composite)this.grammarGroup, 18444);
        ModifyListener gListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TextEditorPreferencePage.this.typesTable.getSelectionCount() == 1) {
                    TableItem item = TextEditorPreferencePage.this.typesTable.getSelection()[0];
                    TextEditorPreferencePage.this.mappingsToGrammars.put(item.getText(), TextEditorPreferencePage.this.grammarText.getText());
                    TextEditorPreferencePage.this.changed = true;
                }
            }
        };
        this.grammarText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.grammarText.addModifyListener(gListener);
        this.browseGrammar = new Button((Composite)this.grammarGroup, 8);
        this.browseGrammar.setText(StringUtils.ellipsify((String)Messages.TextEditorPreferencePage_BROWSE));
        this.browseGrammar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(TextEditorPreferencePage.this.displayArea.getShell());
                fileDialog.setFilterExtensions(new String[]{"*.lxr"});
                String fileName = fileDialog.open();
                if (fileName != null) {
                    try {
                        AttributeSniffer sniffer = new AttributeSniffer("lexer", "language");
                        sniffer.read(fileName);
                        String newLanguage = sniffer.getMatchedValue();
                        if (newLanguage != null) {
                            if (!LanguageRegistry.hasTokenList((String)newLanguage)) {
                                TextEditorPreferencePage.this.grammarText.setText(fileName);
                                TextEditorPreferencePage.this.tableSelectionListener.widgetSelected(e);
                            } else {
                                UIJob errorJob = new UIJob(Messages.TextEditorPreferencePage_Error_Loading_Language){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        MessageDialog.openError((Shell)TextEditorPreferencePage.this.getShell(), (String)Messages.TextEditorPreferencePage_Error_Adding_Language, (String)Messages.TextEditorPreferencePage_Language_Already_Supported);
                                        return Status.OK_STATUS;
                                    }
                                };
                                errorJob.schedule();
                            }
                        }
                    }
                    catch (Exception e1) {
                        UIJob errorJob = new UIJob(Messages.TextEditorPreferencePage_Error_Loading_Lexer_File){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                MessageDialog.openError((Shell)TextEditorPreferencePage.this.getShell(), (String)Messages.TextEditorPreferencePage_Error_Loading_Lexer_File, (String)e1.getMessage());
                                return Status.OK_STATUS;
                            }
                        };
                        errorJob.schedule();
                    }
                }
            }
        });
        this.browseGrammar.setEnabled(false);
        this.colorizerGroup = new Group(this.displayArea, 0);
        this.colorizerGroup.setText(Messages.TextEditorPreferencePage_COLORIATION_FILE);
        this.colorizerGroup.setLayout((Layout)new GridLayout(1, false));
        this.colorizerGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.applyChanges = new Button((Composite)this.colorizerGroup, 8);
        this.applyChanges.setText(Messages.TextEditorPreferencePage_Apply_Changes);
        this.applyChanges.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextEditorPreferencePage.this.typesTable.getSelectionCount() == 1) {
                    TableItem item = TextEditorPreferencePage.this.typesTable.getSelection()[0];
                    String colorizerId = TextPlugin.getColorizerPreference(item.getText());
                    if (TextEditorPreferencePage.this.activeProviders.containsKey(colorizerId)) {
                        LanguageStructureProvider provider = (LanguageStructureProvider)TextEditorPreferencePage.this.activeProviders.get(colorizerId);
                        LanguageColorizer colorizer = LanguageRegistry.getLanguageColorizer((String)provider.getLanguage());
                        provider.buildLanguageColorizer(colorizer, colorizerId);
                    }
                }
            }
        });
        this.applyChanges.setEnabled(true);
        this.colorizer = new LanguageColorizationWidget();
        data = new GridData(4, 4, true, true);
        this.colorizer.createControl((Composite)this.colorizerGroup, data);
        this.colorizer.collapseAll();
        return this.displayArea;
    }

    private IFileEditorMapping getFileEditorMapping(String name, String extension) {
        FileEditorMapping mapping = null;
        String label = (String.valueOf(name) + (extension == null || extension.length() == 0 ? "" : "." + extension)).toUpperCase();
        int i = 0;
        while (i < this.mappings.size()) {
            FileEditorMapping curr = this.mappings.get(i);
            if (label.equalsIgnoreCase(curr.getLabel())) {
                mapping = curr;
                break;
            }
            ++i;
        }
        if (mapping == null) {
            mapping = new FileEditorMapping(name, extension);
            this.mappings.add(mapping);
        }
        mapping.setDefaultEditor(this.descriptor);
        return mapping;
    }

    private void addTypesTableItem(IFileEditorMapping mapping, int index) {
        Image image = mapping.getImageDescriptor().createImage(false);
        TableItem item = new TableItem(this.typesTable, 0, index);
        if (image != null) {
            this.imagesToDispose.add(image);
            item.setImage(image);
        }
        item.setText(mapping.getLabel());
        item.setData((Object)mapping);
    }

    public void dispose() {
        super.dispose();
        if (this.imagesToDispose != null) {
            Iterator<Image> e = this.imagesToDispose.iterator();
            while (e.hasNext()) {
                e.next().dispose();
            }
            this.imagesToDispose = null;
        }
    }

    public boolean performOk() {
        if (this.changed) {
            for (String label : this.mappingsToGrammars.keySet()) {
                String grammarFile = this.mappingsToGrammars.get(label);
                this.store.setValue(TextPlugin.getGrammarPreference(label), grammarFile);
            }
            FileEditorMapping[] _mappings = new FileEditorMapping[this.mappings.size()];
            int i = 0;
            while (i < _mappings.length) {
                _mappings[i] = this.mappings.get(i);
                ++i;
            }
            EditorRegistry registry = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
            registry.setFileEditorMappings(_mappings);
            registry.saveAssociations();
            PrefUtil.savePrefs();
        }
        for (String prefId : this.activeProviders.keySet()) {
            LanguageStructureProvider provider = this.activeProviders.get(prefId);
            LanguageColorizer colorizer = LanguageRegistry.getLanguageColorizer((String)provider.getLanguage());
            provider.buildLanguageColorizer(colorizer, prefId);
            provider.disposeImages();
        }
        return super.performOk();
    }

    public boolean performCancel() {
        for (String prefId : this.activeProviders.keySet()) {
            LanguageStructureProvider provider = this.activeProviders.get(prefId);
            provider.disposeImages();
        }
        return super.performCancel();
    }

    public void init(IWorkbench workbench) {
        this.store = TextPlugin.getDefault().getPreferenceStore();
    }

    public void setVisible(boolean visible) {
        if (this.header != null) {
            this.header.setVisible(visible);
        }
        super.setVisible(visible);
    }
}

