/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.pathtools;

import com.aptana.ide.pathtools.Activator;
import com.aptana.ide.pathtools.handlers.Utilities;
import com.aptana.ide.ui.io.FileSystemUtils;
import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class ExploreAction
implements IViewActionDelegate,
IObjectActionDelegate {
    private File fileObject;
    private static String fileExploreComand = null;
    private static String folderExploreComand = null;
    private IWorkbenchWindow window;

    public void dispose() {
    }

    public void init(IViewPart view) {
        this.window = view.getViewSite().getWorkbenchWindow();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        folderExploreComand = Activator.getDefault().getPreferenceStore().getString("folderExploreCommand");
        fileExploreComand = Activator.getDefault().getPreferenceStore().getString("fileExploreCommand");
        if (fileExploreComand == null || folderExploreComand == null) {
            return;
        }
        if (this.fileObject != null) {
            String commandFormat = this.fileObject.isDirectory() ? folderExploreComand : fileExploreComand;
            Utilities.launch(commandFormat, this.fileObject);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fileObject = null;
        action.setEnabled(false);
        try {
            IStructuredSelection structuredSelection;
            IPath location = null;
            if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement instanceof IResource) {
                    IResource resource = (IResource)firstElement;
                    location = resource.getLocation();
                } else if (firstElement instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)firstElement;
                    IResource resource = (IResource)adaptable.getAdapter(IResource.class);
                    if (resource != null) {
                        location = resource.getLocation();
                    } else {
                        IFileStore fileStore = FileSystemUtils.getFileStore((Object)adaptable);
                        try {
                            this.fileObject = fileStore.toLocalFile(0, null);
                        }
                        catch (CoreException coreException) {}
                    }
                }
            }
            if (this.fileObject == null) {
                IFileEditorInput fileEditorInput;
                IFile iFile;
                ITextEditor abstractTextEditor;
                IEditorInput editorInput;
                IWorkbenchPart activeEditor;
                IWorkbenchPage activePage;
                if (location != null) {
                    this.fileObject = location.toFile();
                } else if (this.window != null && (activePage = this.window.getActivePage()) != null && (activeEditor = activePage.getActivePart()) instanceof ITextEditor && (editorInput = (abstractTextEditor = (ITextEditor)activeEditor).getEditorInput()) instanceof IFileEditorInput && (iFile = (fileEditorInput = (IFileEditorInput)editorInput).getFile()) != null) {
                    location = iFile.getLocation();
                    this.fileObject = location.toFile();
                }
            }
        }
        catch (Throwable throwable) {
            action.setEnabled(this.fileObject != null);
            throw throwable;
        }
        action.setEnabled(this.fileObject != null);
    }
}

