/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.pathtools.handlers;

import com.aptana.ide.pathtools.Activator;
import com.aptana.ide.pathtools.CommandLauncher;
import com.aptana.ide.pathtools.handlers.Utilities;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenShellHandler
extends AbstractHandler {
    private File fileObject;
    private static String shellOnFileEditComand = null;
    private static String shellOnFolderComand = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        this.updateSelection(event, selection);
        shellOnFolderComand = Activator.getDefault().getPreferenceStore().getString("shellOnfolderCommand");
        shellOnFileEditComand = Activator.getDefault().getPreferenceStore().getString("shellOnFileCommand");
        if (shellOnFileEditComand == null || shellOnFolderComand == null) {
            return null;
        }
        if (this.fileObject != null) {
            String commandFormat = this.fileObject.isDirectory() ? shellOnFolderComand : shellOnFileEditComand;
            String command = Utilities.formatCommand(commandFormat, this.fileObject);
            CommandLauncher.launch(command);
        }
        return null;
    }

    private void updateSelection(ExecutionEvent event, ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection == null) {
            return;
        }
        this.fileObject = null;
        IPath location = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof IResource) {
                IResource resource = (IResource)firstElement;
                location = resource.getLocation();
            } else if (firstElement instanceof IAdaptable) {
                IResource resource;
                IAdaptable adaptable = (IAdaptable)firstElement;
                this.fileObject = (File)adaptable.getAdapter(File.class);
                if (this.fileObject == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null) {
                    location = resource.getLocation();
                }
            }
        }
        if (this.fileObject == null) {
            if (location != null) {
                this.fileObject = location.toFile();
            } else {
                IFileEditorInput fileEditorInput;
                IFile iFile;
                ITextEditor abstractTextEditor;
                IEditorInput editorInput;
                IWorkbenchPart activeEditor;
                IWorkbenchPage activePage;
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                if (window != null && (activePage = window.getActivePage()) != null && (activeEditor = activePage.getActivePart()) instanceof ITextEditor && (editorInput = (abstractTextEditor = (ITextEditor)activeEditor).getEditorInput()) instanceof IFileEditorInput && (iFile = (fileEditorInput = (IFileEditorInput)editorInput).getFile()) != null) {
                    location = iFile.getLocation();
                    this.fileObject = location.toFile();
                }
            }
        }
    }
}

