/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.profiles.ProfileManager;
import com.aptana.ide.editors.views.actions.ActionsManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UnifiedEditorsPlugin
extends AbstractUIPlugin {
    private static final String TEMPLATES = "com.aptana.ide.editors.templates";
    private static Hashtable<String, Image> images = new Hashtable();
    private static UnifiedEditorsPlugin plugin;
    private boolean enableThreading = true;
    ProfileManager profileManager;
    ActionsManager actionsManager;
    private HashMap<ContextTypeRegistry, ContributionTemplateStore> fTemplateStoreMap;
    public static final String ID = "com.aptana.ide.editors";
    public static final String BROWSER_ELEMENT = "browser";
    public static final String DECORATOR_ELEMENT = "decorator";
    public static final String CLASS_ATTR = "class";
    public static final String OUTLINE_ATTR = "outline";
    public static final String LABEL_NODE = "label";
    public static final String OS_ATTR = "os";
    public static final String VALUE_ATTR = "value";
    public static final String BROWSER_EXTENSION_POINT = "com.aptana.ide.editors.browser";
    public static final String COLORIZATION_EXTENSION_POINT = "com.aptana.ide.editors.colorization";
    public static final String FOLDING_EXTENSION_POINT = "com.aptana.ide.editors.folding";
    public static final String CONTENT_ASSISTANT_EXTENSION_POINT = "com.aptana.ide.editors.contentassistant";

    public static UnifiedEditorsPlugin getDefault() {
        return plugin;
    }

    public static Image getImage(String path) {
        if (images.get(path) == null) {
            ImageDescriptor id = UnifiedEditorsPlugin.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            Image i = id.createImage();
            images.put(path, i);
            return i;
        }
        return images.get(path);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public UnifiedEditorsPlugin() {
        plugin = this;
    }

    public ActionsManager getActionsManager() {
        if (this.actionsManager == null) {
            this.actionsManager = new ActionsManager();
        }
        return this.actionsManager;
    }

    public ProfileManager getProfileManager() {
        if (this.profileManager == null) {
            this.profileManager = new ProfileManager(this.enableThreading);
        }
        return this.profileManager;
    }

    public boolean isThreadingEnabled() {
        return this.enableThreading;
    }

    public void setEnableThreading(boolean enableThreading) {
        this.enableThreading = enableThreading;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public boolean useFastScan() {
        boolean result = true;
        try {
            IPreferenceStore prefStore = this.getPreferenceStore();
            result = prefStore.getBoolean("com.aptana.ide.editors.PARSER_OFF_UI");
        }
        catch (Exception exception) {}
        return result;
    }

    public ContributionTemplateStore getTemplateStore(ContextTypeRegistry contextTypeRegistry) {
        this.fTemplateStoreMap = new HashMap();
        ContributionTemplateStore store = this.fTemplateStoreMap.get(contextTypeRegistry);
        if (store == null) {
            store = new ContributionTemplateStore(contextTypeRegistry, UnifiedEditorsPlugin.getDefault().getPreferenceStore(), TEMPLATES);
            try {
                store.load();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
            this.fTemplateStoreMap.put(contextTypeRegistry, store);
        }
        return store;
    }
}

