/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.formatting;

import com.aptana.ide.editors.formatting.IUnifiedBracketInserter;
import com.aptana.ide.editors.formatting.UnifiedBracketInserterBase;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.UnifiedViewer;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.events.VerifyEvent;

public abstract class UnifiedBracketInserter
extends UnifiedBracketInserterBase
implements IUnifiedBracketInserter {
    protected ISourceViewer sourceViewer;
    protected IFileService context;

    public UnifiedBracketInserter(ISourceViewer sourceViewer, IFileService context) {
        super(sourceViewer);
        this.sourceViewer = sourceViewer;
        this.context = context;
    }

    protected LexemeList getLexemeList() {
        return this.context.getLexemeList();
    }

    protected boolean isAutoInsertEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        String abi = "com.aptana.ide.editor.AUTO_BRACKET_INSERTION";
        return store == null || !store.getString(abi).equals("NONE");
    }

    protected abstract IPreferenceStore getPreferenceStore();

    protected boolean isValidAutoInsertLocation(char character, int offset, int length) {
        LexemeList list = this.getLexemeList();
        Lexeme next = list.getLexemeFromOffset(offset + length);
        Lexeme previous = list.getLexemeFromOffset(offset - 1);
        return this.isValidAutoInsertLocation(character, previous, next);
    }

    protected boolean isValidAutoInsertLocation(char character, Lexeme previous, Lexeme next) {
        return !(next != null && next.getLength() > 1 || previous != null && previous.getLength() > 1 || character == '\'' && previous != null && previous.getText().equals("'")) && (character != '\"' || previous == null || !previous.getText().equals("\""));
    }

    protected void triggerContentAssistPopup(VerifyEvent event) {
        if (this.sourceViewer instanceof SourceViewer) {
            if (!this.autoTriggerAssist()) {
                return;
            }
            ((SourceViewer)this.sourceViewer).doOperation(13);
        }
    }

    protected void triggerContextAssistPopup(VerifyEvent event) {
        if (this.sourceViewer instanceof SourceViewer) {
            if (!this.autoTriggerAssist()) {
                return;
            }
            ((SourceViewer)this.sourceViewer).doOperation(14);
        }
    }

    protected void triggerAssistClose(VerifyEvent event) {
        if (this.sourceViewer instanceof UnifiedViewer) {
            ((UnifiedViewer)this.sourceViewer).closeContentAssist();
        }
    }

    protected boolean autoTriggerAssist() {
        return this.getPreferenceStore() != null && this.getPreferenceStore().getBoolean("com.aptana.ide.editors.CODE_ASSIST_AUTO_ACTIVATION");
    }
}

