/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.formatting;

import com.aptana.ide.editors.formatting.IUnifiedBracketInserter;
import java.util.HashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;

public class UnifiedBracketInserterManager
implements VerifyKeyListener {
    private String partitioning;
    private HashMap processors = new HashMap();
    private ISourceViewer sourceViewer;

    public UnifiedBracketInserterManager(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public void setDocumentPartitioning(String docPart) {
        this.partitioning = docPart;
    }

    public String getDocumentPartitioning() {
        return this.partitioning;
    }

    public void setBracketInserter(IUnifiedBracketInserter processor, String contentType) {
        if (this.processors == null) {
            this.processors = new HashMap();
        }
        if (processor == null) {
            this.processors.remove(contentType);
        } else {
            this.processors.put(contentType, processor);
        }
    }

    public IUnifiedBracketInserter getBracketInserter(String contentType) {
        if (this.processors == null) {
            return null;
        }
        return (IUnifiedBracketInserter)this.processors.get(contentType);
    }

    public void verifyKey(VerifyEvent event) {
        Point selection = this.sourceViewer.getSelectedRange();
        int offset = selection.x;
        IUnifiedBracketInserter inserter = this.getBracketInserterFromOffset(offset);
        if (inserter != null) {
            inserter.verifyKey(event);
        }
    }

    private IUnifiedBracketInserter getBracketInserterFromOffset(int offset) {
        try {
            IDocument document = this.sourceViewer.getDocument();
            String type = document != null ? TextUtilities.getContentType((IDocument)document, (String)this.getDocumentPartitioning(), (int)offset, (boolean)true) : "__dftl_partition_content_type";
            return this.getBracketInserter(type);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

