/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.preferences;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PlatformUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.SWTUtils;
import com.aptana.ide.core.ui.preferences.GeneralPreferencePage;
import com.aptana.ide.core.ui.preferences.TabbedFieldEditorPreferencePage;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.preferences.Messages;
import com.aptana.ide.epl.Activator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AdvancedPreferencePage
extends TabbedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String IE_PREVIEW_KEY = "HKLM\\SOFTWARE\\Microsoft\\Internet Explorer\\View Source Editor\\Editor Name";
    private static final String IE_PREVIEW_NOTEPAD_VALUE = "notepad.exe";
    private Button notepad;
    private Button otherButton;
    private Text text;
    private Button browse;
    private Scale debugSlider;
    private FieldEditor switchPerspectiveField;

    public AdvancedPreferencePage() {
        super(1);
        this.setPreferenceStore(UnifiedEditorsPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.AdvancedPreferencePage_DebuggingAndAdvanced);
    }

    public void createFieldEditors() {
        this.addTab(Messages.AdvancedPreferencePage_User);
        Composite appearanceComposite = this.getFieldEditorParent();
        this.addField((FieldEditor)new StringFieldEditor("com.aptana.ide.core.ui.PREF_USER_NAME", com.aptana.ide.core.ui.preferences.Messages.GeneralPreferencePage_EmailAddressForBugReports, appearanceComposite));
        this.switchPerspectiveField = new RadioGroupFieldEditor("com.aptana.ide.js.ui.WebPerspective.switch_to_perspective", Messages.AdvancedPreferencePage_switchToAptanaPerspective, 3, (String[][])new String[][]{{Messages.AdvancedPreferencePage_Always, "always"}, {Messages.AdvancedPreferencePage_Never, "never"}, {Messages.AdvancedPreferencePage_Prompt, "prompt"}}, appearanceComposite, true);
        this.addField(this.switchPerspectiveField);
        if ("win32".equals(Platform.getOS())) {
            Group ieGroup = new Group(appearanceComposite, 0);
            GridData ieData = new GridData(4, 4, true, true);
            ieData.horizontalSpan = 2;
            ieGroup.setLayoutData((Object)ieData);
            ieGroup.setLayout((Layout)new GridLayout(1, true));
            ieGroup.setText(Messages.AdvancedPreferencePage_IESettings);
            this.notepad = new Button((Composite)ieGroup, 16);
            this.notepad.setText(Messages.AdvancedPreferencePage_AssociateWithNotepad);
            this.notepad.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdvancedPreferencePage.this.setErrorMessage(null);
                    AdvancedPreferencePage.this.setValid(true);
                }
            });
            this.otherButton = new Button((Composite)ieGroup, 16);
            this.otherButton.setText(Messages.AdvancedPreferencePage_AssociateWithOther);
            Composite other = new Composite((Composite)ieGroup, 0);
            GridLayout otherLayout = new GridLayout(2, false);
            otherLayout.marginHeight = 0;
            other.setLayout((Layout)otherLayout);
            other.setLayoutData((Object)new GridData(4, 4, true, false));
            this.text = new Text(other, 2052);
            this.text.setLayoutData((Object)new GridData(4, 4, true, false));
            this.text.setEditable(false);
            this.text.setEnabled(false);
            this.browse = new Button(other, 8);
            this.browse.setEnabled(false);
            this.browse.setText(StringUtils.ellipsify((String)CoreStrings.BROWSE));
            this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(AdvancedPreferencePage.this.browse.getShell(), 4096);
                    String program = dialog.open();
                    if (program != null) {
                        AdvancedPreferencePage.this.text.setText(program);
                        AdvancedPreferencePage.this.setErrorMessage(null);
                        AdvancedPreferencePage.this.setValid(true);
                    }
                }
            });
            this.otherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selection = AdvancedPreferencePage.this.otherButton.getSelection();
                    AdvancedPreferencePage.this.browse.setEnabled(selection);
                    AdvancedPreferencePage.this.text.setEnabled(selection);
                    if (!selection) {
                        AdvancedPreferencePage.this.text.setText("");
                    } else if (AdvancedPreferencePage.this.text.getText().length() < 1) {
                        AdvancedPreferencePage.this.setErrorMessage(Messages.AdvancedPreferencePage_PleaseSpecifyApplication);
                        AdvancedPreferencePage.this.setValid(false);
                    }
                }
            });
            String current = null;
            try {
                current = PlatformUtils.queryRegestryStringValue((String)IE_PREVIEW_KEY, null);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.AdvancedPreferencePage_ERR_ErrorGettingRegistryValue, (Throwable)e);
            }
            if (current != null) {
                if (current.equalsIgnoreCase(IE_PREVIEW_NOTEPAD_VALUE) || current.endsWith(IE_PREVIEW_NOTEPAD_VALUE)) {
                    this.notepad.setSelection(true);
                } else {
                    this.otherButton.setSelection(true);
                    this.browse.setEnabled(true);
                    this.text.setEnabled(true);
                    this.text.setText(current);
                }
            }
        }
        this.addTab(Messages.AdvancedPreferencePage_Debugging);
        appearanceComposite = this.getFieldEditorParent();
        Composite group = GeneralPreferencePage.createGroup((Composite)appearanceComposite, (String)Messages.AdvancedPreferencePage_LBL_AdvancedFunctionality);
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.ide.editors.SHOW_DEBUG_HOVER", Messages.AdvancedPreferencePage_ShowDebugInformation, group));
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.ide.editors.PARSER_OFF_UI", Messages.AdvancedPreferencePage_LBL_ParserOffUI, group));
        group = GeneralPreferencePage.createGroup((Composite)appearanceComposite, (String)Messages.AdvancedPreferencePage_LBL_DebuggingOutputLevel);
        Composite debugComp = new Composite(group, 0);
        GridLayout pkcLayout = new GridLayout(3, false);
        pkcLayout.marginWidth = 0;
        pkcLayout.marginHeight = 0;
        debugComp.setLayout((Layout)pkcLayout);
        debugComp.setLayoutData((Object)new GridData(4, 4, true, false));
        Label pianoKeyLabel = new Label(debugComp, 16384);
        pianoKeyLabel.setText(Messages.AdvancedPreferencePage_LBL_ControlDebugInformationAmountHelp);
        GridData pklData = new GridData(4, 4, true, false);
        pklData.horizontalSpan = 3;
        pianoKeyLabel.setLayoutData((Object)pklData);
        Label less = new Label(debugComp, 16384);
        less.setText(Messages.AdvancedPreferencePage_LBL_Errors);
        this.debugSlider = new Scale(debugComp, 256);
        this.debugSlider.setIncrement(1);
        this.debugSlider.setMinimum(1);
        this.debugSlider.setMaximum(3);
        Preferences p = AptanaCorePlugin.getDefault().getPluginPreferences();
        this.debugSlider.setSelection(p.getInt("com.aptana.ide.core.PREF_DEBUG_LEVEL"));
        Label more = new Label(debugComp, 16384);
        more.setText(Messages.AdvancedPreferencePage_LBL_All);
        final Label currentValue = new Label(debugComp, 16384);
        currentValue.setText(this.getValueLabel(this.debugSlider.getSelection()));
        currentValue.setFont(SWTUtils.getDefaultSmallFont());
        pklData = new GridData(4, 4, true, false);
        pklData.horizontalSpan = 3;
        currentValue.setLayoutData((Object)pklData);
        this.debugSlider.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                currentValue.setText(AdvancedPreferencePage.this.getValueLabel(AdvancedPreferencePage.this.debugSlider.getSelection()));
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                currentValue.setText(AdvancedPreferencePage.this.getValueLabel(AdvancedPreferencePage.this.debugSlider.getSelection()));
            }
        });
    }

    protected void initialize() {
        super.initialize();
        this.switchPerspectiveField.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.switchPerspectiveField.load();
    }

    private String getValueLabel(int selection) {
        switch (selection) {
            case 0: {
                return Messages.AdvancedPreferencePage_LBL_NoDebuggingOutput;
            }
            case 1: {
                return Messages.AdvancedPreferencePage_LBL_OnlyError;
            }
            case 2: {
                return Messages.AdvancedPreferencePage_LBL_ErrorsAndImportant;
            }
            case 3: {
                return Messages.AdvancedPreferencePage_LBL_AllDebuggingInformation;
            }
        }
        return Messages.AdvancedPreferencePage_LBL_UnknownLoggingLevel;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.debugSlider.setSelection(this.getPreferenceStore().getDefaultInt("com.aptana.ide.core.PREF_DEBUG_LEVEL"));
        super.performDefaults();
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        boolean saved = false;
        boolean optionSelected = false;
        if (ok) {
            if ("win32".equals(Platform.getOS())) {
                try {
                    if (this.notepad.getSelection()) {
                        saved = PlatformUtils.setRegestryStringValue((String)IE_PREVIEW_KEY, null, (String)IE_PREVIEW_NOTEPAD_VALUE);
                        optionSelected = true;
                    } else if (this.otherButton.getSelection()) {
                        saved = PlatformUtils.setRegestryStringValue((String)IE_PREVIEW_KEY, null, (String)this.text.getText());
                        optionSelected = true;
                    }
                    if (!saved && optionSelected) {
                        throw new Exception("Registry value not saved");
                    }
                }
                catch (Exception exception) {
                    MessageBox error = new MessageBox(this.getShell(), 33);
                    error.setMessage(String.valueOf(Messages.AdvancedPreferencePage_ErrorSettingRegistry) + Messages.AdvancedPreferencePage_CheckPrivileges);
                    error.open();
                }
            }
            IPreferenceStore unified = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
            boolean value = unified.getBoolean("com.aptana.ide.core.PREF_ENABLE_DEBUGGING");
            Preferences p = AptanaCorePlugin.getDefault().getPluginPreferences();
            p.setValue("com.aptana.ide.core.PREF_ENABLE_DEBUGGING", value);
            p.setValue("com.aptana.ide.core.PREF_DEBUG_LEVEL", this.debugSlider.getSelection());
            AptanaCorePlugin.getDefault().savePluginPreferences();
        }
        return ok;
    }
}

