/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.preferences.TabbedFieldEditorPreferencePage;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.preferences.Messages;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class GeneralPreferencePage
extends TabbedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Scale pianoKeySlider;
    protected ColorSelector occurrenceColor;
    protected Button enableOccurrences;
    private Button spaces;
    private Button tabs;
    private IPropertyChangeListener tabWidthListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (GeneralPreferencePage.this.spaces != null && !GeneralPreferencePage.this.spaces.isDisposed()) {
                GeneralPreferencePage.this.spaces.setText(StringUtils.format((String)Messages.GeneralPreferencePage_UseSpaces, (Object)event.getNewValue()));
            }
        }
    };

    public GeneralPreferencePage() {
        super(1);
        this.setPreferenceStore(UnifiedEditorsPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.GeneralPreferencePage_PreferenceDescription);
    }

    public void createFieldEditors() {
        this.addTab(Messages.GeneralPreferencePage_General);
        Composite appearanceComposite = this.getFieldEditorParent();
        Composite group = com.aptana.ide.core.ui.preferences.GeneralPreferencePage.createGroup((Composite)appearanceComposite, (String)Messages.GeneralPreferencePage_Formatting);
        Composite occurrenceComp = new Composite(group, 0);
        GridLayout occLayout = new GridLayout(2, false);
        occLayout.marginWidth = 0;
        occLayout.marginHeight = 0;
        occurrenceComp.setLayout((Layout)occLayout);
        occurrenceComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.enableOccurrences = new Button(occurrenceComp, 32);
        this.enableOccurrences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPreferencePage.this.occurrenceColor.setEnabled(GeneralPreferencePage.this.enableOccurrences.getSelection());
            }
        });
        this.enableOccurrences.setSelection(this.getPreferenceStore().getBoolean("com.aptana.ide.editors.COLORIZER_TEXT_HIGHLIGHT_ENABLED"));
        this.enableOccurrences.setText(Messages.GeneralPreferencePage_MarkOccurrences);
        this.occurrenceColor = new ColorSelector(occurrenceComp);
        this.occurrenceColor.setEnabled(this.enableOccurrences.getSelection());
        this.occurrenceColor.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.editors.COLORIZER_TEXT_HIGHLIGHT_BACKGROUND_COLOR"));
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.ide.editors.INSERT_ON_TAB", Messages.GeneralPreferencePage_InsertSelectedProposal, group));
        this.addField((FieldEditor)new RadioGroupFieldEditor("AbstractTextEditor.Navigation.SmartHomeEnd", Messages.GeneralPreferencePage_HomeEndBehavior, 1, (String[][])new String[][]{{Messages.GeneralPreferencePage_ToggleBetween, "true"}, {Messages.GeneralPreferencePage_JumpsStartEnd, "false"}}, appearanceComposite, true));
        group = com.aptana.ide.core.ui.preferences.GeneralPreferencePage.createGroup((Composite)appearanceComposite, (String)Messages.GeneralPreferencePage_LBL_Colorization);
        Composite pianoKeyComp = new Composite(group, 0);
        GridLayout pkcLayout = new GridLayout(3, false);
        pkcLayout.marginWidth = 0;
        pkcLayout.marginHeight = 0;
        pianoKeyComp.setLayout((Layout)pkcLayout);
        pianoKeyComp.setLayoutData((Object)new GridData(4, 4, true, false));
        Label pianoKeyLabel = new Label(pianoKeyComp, 16384);
        pianoKeyLabel.setText(Messages.GeneralPreferencePage_LBL_PianoKeyColorDifference);
        GridData pklData = new GridData(4, 4, true, false);
        pklData.horizontalSpan = 3;
        pianoKeyLabel.setLayoutData((Object)pklData);
        Label less = new Label(pianoKeyComp, 16384);
        less.setText(Messages.GeneralPreferencePage_LBL_Less);
        this.pianoKeySlider = new Scale(pianoKeyComp, 256);
        this.pianoKeySlider.setIncrement(5);
        this.pianoKeySlider.setMinimum(1);
        this.pianoKeySlider.setMaximum(50);
        this.pianoKeySlider.setSelection(this.getPreferenceStore().getInt("com.aptana.ide.editors.PIANO_KEY_DIFFERENCE"));
        Label more = new Label(pianoKeyComp, 16384);
        more.setText(Messages.GeneralPreferencePage_LBL_More);
        Composite wsGroup = com.aptana.ide.core.ui.preferences.GeneralPreferencePage.createGroup((Composite)appearanceComposite, (String)Messages.GeneralPreferencePage_TabInsertion);
        Composite wsComp = new Composite(wsGroup, 0);
        GridLayout wsLayout = new GridLayout(3, false);
        wsLayout.marginWidth = 0;
        wsLayout.marginHeight = 0;
        wsComp.setLayout((Layout)wsLayout);
        wsComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tabs = new Button(wsComp, 16);
        Composite spaceComp = new Composite(wsComp, 0);
        wsLayout = new GridLayout(2, false);
        wsLayout.marginWidth = 0;
        wsLayout.marginHeight = 0;
        wsLayout.horizontalSpacing = 0;
        spaceComp.setLayout((Layout)wsLayout);
        spaceComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.spaces = new Button(spaceComp, 16);
        Link currentTabSize = new Link(spaceComp, 0);
        IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
        int size = store.getInt("tabWidth");
        this.spaces.setText(StringUtils.format((String)Messages.GeneralPreferencePage_UseSpaces, (int)size));
        this.tabs.setText(Messages.GeneralPreferencePage_UseTabs);
        store.addPropertyChangeListener(this.tabWidthListener);
        currentTabSize.setText(Messages.GeneralPreferencePage_EditLink);
        currentTabSize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IWorkbenchPreferenceContainer)GeneralPreferencePage.this.getContainer()).openPage("org.eclipse.ui.preferencePages.GeneralTextEditor", null);
            }
        });
        boolean useSpaces = this.getPreferenceStore().getBoolean("com.aptana.ide.editor.INSERT_SPACES_FOR_TABS");
        this.spaces.setSelection(useSpaces);
        this.tabs.setSelection(!useSpaces);
        this.tabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPreferencePage.this.spaces.setSelection(!GeneralPreferencePage.this.tabs.getSelection());
            }
        });
        this.spaces.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPreferencePage.this.tabs.setSelection(!GeneralPreferencePage.this.spaces.getSelection());
            }
        });
        Link link = new Link(appearanceComposite, 0);
        link.setText(Messages.GeneralPreferencePage_GeneralTextEditorPrefLink);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IWorkbenchPreferenceContainer)GeneralPreferencePage.this.getContainer()).openPage("org.eclipse.ui.preferencePages.GeneralTextEditor", null);
            }
        });
        this.addTab(Messages.GeneralPreferencePage_Advanced);
        appearanceComposite = this.getFieldEditorParent();
        this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.ide.editor.ENABLE_WORD_WRAP", Messages.GeneralPreferencePage_EnableWordWrap, appearanceComposite));
        appearanceComposite = this.getFieldEditorParent();
        this.addField((FieldEditor)new IntegerFieldEditor("com.aptana.ide.editor.COLORIZER_MAXCOLUMNS", Messages.GeneralPreferencePage_MaxColorizeColumns, appearanceComposite, 4));
        group = com.aptana.ide.core.ui.preferences.GeneralPreferencePage.createGroup((Composite)appearanceComposite, (String)Messages.GeneralPreferencePage_CodeAssist);
        this.addField((FieldEditor)new IntegerFieldEditor("com.aptana.ide.editor.CONTENT_ASSIST_DELAY", Messages.GeneralPreferencePage_DelayBeforeShowing, group, 4));
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
        store.removePropertyChangeListener(this.tabWidthListener);
        super.dispose();
    }

    protected void performDefaults() {
        this.enableOccurrences.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.ide.editors.COLORIZER_TEXT_HIGHLIGHT_ENABLED"));
        this.occurrenceColor.setColorValue(PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.editors.COLORIZER_TEXT_HIGHLIGHT_BACKGROUND_COLOR"));
        this.occurrenceColor.setEnabled(this.enableOccurrences.getSelection());
        boolean useSpaces = this.getPreferenceStore().getDefaultBoolean("com.aptana.ide.editor.INSERT_SPACES_FOR_TABS");
        this.spaces.setSelection(useSpaces);
        this.tabs.setSelection(!useSpaces);
        this.pianoKeySlider.setSelection(this.getPreferenceStore().getDefaultInt("com.aptana.ide.editors.PIANO_KEY_DIFFERENCE"));
        super.performDefaults();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("com.aptana.ide.editors.COLORIZER_TEXT_HIGHLIGHT_ENABLED", this.enableOccurrences.getSelection());
        this.getPreferenceStore().setValue("com.aptana.ide.editor.INSERT_SPACES_FOR_TABS", this.spaces.getSelection());
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.editors.COLORIZER_TEXT_HIGHLIGHT_BACKGROUND_COLOR", (RGB)this.occurrenceColor.getColorValue());
        this.getPreferenceStore().setValue("com.aptana.ide.editors.PIANO_KEY_DIFFERENCE", this.pianoKeySlider.getSelection());
        LanguageColorizer.fireColorizationEvent();
        return super.performOk();
    }
}

