/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.tasks;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.builder.BuildContext;
import com.aptana.ide.core.builder.BuildParticipant;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.tasks.TaskParser;
import com.aptana.ide.editors.tasks.TaskTag;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskBuildParticipant
extends BuildParticipant {
    private static final String TASK_MARKER_ID = "com.aptana.ide.editors.task";
    private TaskParser parser;

    public void buildStarting(List<BuildContext> contexts, boolean isBatch, IProgressMonitor monitor) {
        this.parser = new TaskParser();
    }

    public void build(BuildContext buildContext, IProgressMonitor monitor) {
        try {
            this.removeExistingTasks(buildContext);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
        }
        List<TaskTag> tasks = this.parser.parse(buildContext);
        for (TaskTag task : tasks) {
            this.recordNewProblems(buildContext, task);
        }
    }

    public void buildFinishing(IProgressMonitor monitor) {
    }

    private void removeExistingTasks(BuildContext buildContext) throws CoreException {
        if (buildContext != null && buildContext.getFile() != null) {
            buildContext.getFile().deleteMarkers(TASK_MARKER_ID, false, 1);
        }
    }

    private void recordNewProblems(BuildContext buildContext, TaskTag task) {
        try {
            IMarker marker = buildContext.getFile().createMarker(TASK_MARKER_ID);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("priority", new Integer(task.getPriority()));
            map.put("message", task.getMessage());
            map.put("lineNumber", new Integer(task.getLineNumber()));
            map.put("severity", new Integer(0));
            map.put("userEditable", new Boolean(false));
            map.put("transient", new Boolean(false));
            map.put("charStart", new Integer(task.getStartOffset()));
            map.put("charEnd", new Integer(task.getEndOffset()));
            marker.setAttributes(map);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
        }
    }

    public void cleanStarting(IProject project) {
        try {
            if (project != null) {
                project.deleteMarkers(TASK_MARKER_ID, false, 2);
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isActive(IProject project) {
        return true;
    }
}

