/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.tasks;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.builder.BuildContext;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.tasks.TaskTag;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskParser {
    private boolean fCaseSensitive = Platform.getPreferencesService().getBoolean("com.aptana.ide.editors", "com.aptana.ide.editors.tasks.caseSensitive", false, null);
    private String[] fTags = this.tokenize(Platform.getPreferencesService().getString("com.aptana.ide.editors", "com.aptana.ide.editors.tasks.tags", "", null), ",");
    private int[] fPriorities = this.convertPriorities(this.tokenize(Platform.getPreferencesService().getString("com.aptana.ide.editors", "com.aptana.ide.editors.tasks.priorities", "", null), ","));

    private int[] convertPriorities(String[] stringPriorities) {
        int[] priorities = new int[stringPriorities.length];
        int i = 0;
        while (i < stringPriorities.length) {
            String priority = stringPriorities[i];
            priorities[i] = priority.equals("LOW") ? 0 : (priority.equals("HIGH") ? 2 : 1);
            ++i;
        }
        return priorities;
    }

    private String[] tokenize(String tags, String delim) {
        return tags.split(delim);
    }

    public List<TaskTag> parse(BuildContext buildContext) {
        if (this.fTags.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<TaskTag> tasks = new ArrayList<TaskTag>();
        try {
            LexemeList ll = buildContext.getLexemeList();
            if (ll == null) {
                return tasks;
            }
            Lexeme[] lexemeArray = ll.toArray();
            int n = lexemeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Lexeme lexeme = lexemeArray[n2];
                if (lexeme.getType().equalsIgnoreCase("COMMENT") || lexeme.getLanguage().equals("text/jscomment")) {
                    String[] lines;
                    String[] stringArray = lines = lexeme.getText().split("[\\r|\\n]");
                    int n3 = lines.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String line = stringArray[n4];
                        tasks.addAll(this.processLine(buildContext, line, lexeme.offset));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            IdeLog.log((Plugin)UnifiedEditorsPlugin.getDefault(), (int)4, (String)e.getMessage(), (Throwable)e);
        }
        return tasks;
    }

    private String trimComment(String text) {
        if (text.endsWith("-->")) {
            return text.substring(0, text.length() - 3);
        }
        if (text.endsWith("*/")) {
            return text.substring(0, text.length() - 2);
        }
        return text;
    }

    private int getLineNumber(BuildContext buildContext, int offset) {
        return buildContext.getContents().substring(0, offset).split("\\r|\\n").length;
    }

    private List<TaskTag> processLine(BuildContext buildContext, String line, int offset) throws CoreException {
        ArrayList<TaskTag> tasks = new ArrayList<TaskTag>();
        if (!this.fCaseSensitive) {
            line = line.toLowerCase();
        }
        int i = 0;
        while (i < this.fTags.length) {
            int index;
            String tag = this.fTags[i];
            int priority = this.fPriorities[i];
            if (!this.fCaseSensitive) {
                tag = tag.toLowerCase();
            }
            if ((index = line.indexOf(tag)) != -1) {
                int newOffset = offset + index;
                String message = line.substring(index).trim();
                message = this.trimComment(message);
                tasks.add(new TaskTag(priority, message, this.getLineNumber(buildContext, newOffset), newOffset, newOffset + message.length()));
            }
            ++i;
        }
        return tasks;
    }
}

