/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;

public class DocumentSourceProvider
implements IFileSourceProvider {
    private IDocument document;
    private IEditorInput editorInput;

    public DocumentSourceProvider(IDocument doc, IEditorInput editorInput) {
        this.document = doc;
        this.editorInput = editorInput;
    }

    public String getSource() {
        return this.document.get();
    }

    public int getSourceLength() {
        return this.document.getLength();
    }

    public int getLineOfOffset(int offset) {
        try {
            return this.document.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.DocumentSourceProvider_Error, (Throwable)e);
            return 0;
        }
    }

    public int getLineOffset(int line) {
        try {
            return this.document.getLineOffset(line);
        }
        catch (BadLocationException e) {
            String message = MessageFormat.format(Messages.DocumentSourceProvider_Error, Integer.toString(line));
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)message, (Throwable)e);
            return 0;
        }
    }

    public String getSourceURI() {
        return CoreUIUtils.getURI((IEditorInput)this.editorInput);
    }

    public boolean equals(Object o) {
        if (o instanceof DocumentSourceProvider) {
            DocumentSourceProvider dsp = (DocumentSourceProvider)o;
            return this.document == dsp.document && this.editorInput == dsp.editorInput;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

