/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.Messages;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;

public class DocumentationHelper {
    protected DocumentationHelper() {
    }

    public static String generateLexemeDebugInfo(IFileService fileContext, Lexeme lexeme) {
        LexemeList ll;
        StringBuffer sb = new StringBuffer();
        IToken t = lexeme.getToken();
        sb.append(Messages.DocumentationHelper_DebugInformation);
        sb.append(StringUtils.format((String)Messages.DocumentationHelper_Language, (String)t.getLanguage()));
        sb.append(StringUtils.format((String)Messages.DocumentationHelper_Text, (String)lexeme.getText()));
        sb.append(StringUtils.format((String)Messages.DocumentationHelper_Category, (Object[])new Object[]{lexeme.getType(), lexeme.getCategory()}));
        sb.append(StringUtils.format((String)Messages.DocumentationHelper_Offset, (Object[])new Object[]{Integer.toString(lexeme.getStartingOffset()), Integer.toString(lexeme.getEndingOffset()), Integer.toString(lexeme.getLength())}));
        if (fileContext instanceof FileService) {
            IFileSourceProvider provider = ((FileService)fileContext).getSourceProvider();
            sb.append(StringUtils.format((String)Messages.DocumentationHelper_SourceLength, (int)provider.getSourceLength()));
            sb.append(StringUtils.format((String)Messages.DocumentationHelper_SourcePath, (String)provider.getSourceURI()));
        }
        if ((ll = fileContext.getLexemeList()) != null) {
            sb.append(StringUtils.format((String)Messages.DocumentationHelper_Total, (int)ll.size()));
        }
        return sb.toString();
    }
}

