/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.managers.FileContextManager;
import com.aptana.ide.editors.unified.FileContextContentEvent;
import com.aptana.ide.editors.unified.IFileContextListener;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.IPartitionScanner;
import com.aptana.ide.editors.unified.IRedrawRangeListener;
import com.aptana.ide.editors.unified.IdleFileChangedNotifier;
import com.aptana.ide.editors.unified.LongIdleFileChangedNotifier;
import com.aptana.ide.editors.unified.Messages;
import com.aptana.ide.editors.unified.UnifiedPartitionScanner;
import com.aptana.ide.editors.unified.errors.IErrorManager;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.IFileErrorListener;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.ILanguageChangeListener;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.ITypedRegion;

public class FileService
implements IFileService {
    private Object _parserLock;
    private Map<String, IFileLanguageService> _languageServices;
    private IParseState _parseState;
    private IFileSourceProvider _connectedSourceProvider;
    private IFileSourceProvider _defaultSourceProvider;
    private IParser _parser;
    private IParser _scanner;
    private IPartitionScanner _partitionScanner;
    private List<IFileContextListener> _listeners;
    private List<IFileContextListener> _delayedListeners;
    private List<IFileContextListener> _longDelayedListeners;
    private String _defaultLanguage;
    private ILanguageChangeListener _languageChangeListener;
    private IErrorManager _errorManager;
    private IRedrawRangeListener _redrawListener;
    private IFileError[] _errorMarkers;
    private List<IFileErrorListener> _errorListeners;
    private ITypedRegion[] _partitions;

    public FileService(IParser parser, IParseState parseState, IFileSourceProvider defaultSourceProvider, String defaultLanguage) {
        this._parseState = parseState;
        this._defaultSourceProvider = defaultSourceProvider;
        this._defaultLanguage = defaultLanguage;
        this._parserLock = new Object();
        this._languageServices = new HashMap<String, IFileLanguageService>();
        this._listeners = new ArrayList<IFileContextListener>();
        this._delayedListeners = new ArrayList<IFileContextListener>();
        this._longDelayedListeners = new ArrayList<IFileContextListener>();
        this._errorMarkers = new IFileError[0];
        this._errorListeners = new ArrayList<IFileErrorListener>();
        this.setParser(parser);
        this.addDelayedFileListener(new IFileContextListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onContentChanged(FileContextContentEvent evt) {
                if (FileService.this._scanner != null && FileService.this._parser != null) {
                    FileService fileService = FileService.this;
                    synchronized (fileService) {
                        Object object = FileService.this._parserLock;
                        synchronized (object) {
                            IParseState parseState = FileService.this.getParseState();
                            if (parseState != null) {
                                FileService.this.doParse(parseState);
                                IRange[] iRangeArray = parseState.getUpdateRegions();
                                int n = iRangeArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IRange range = iRangeArray[n2];
                                    FileService.this._redrawListener.redrawRange(range);
                                    ++n2;
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    public void addLanguageService(String mimeType, IFileLanguageService service) {
        if (this._languageServices.containsKey(mimeType)) {
            throw new IllegalStateException(Messages.FileService_LanguageServiceRegistered);
        }
        this._languageServices.put(mimeType, service);
    }

    public void setRedrawRangeListener(IRedrawRangeListener listener) {
        this._redrawListener = listener;
    }

    public void setScanner(IParser parser) {
        this._scanner = parser;
    }

    public void setParser(IParser parser) {
        this._parser = parser;
    }

    public IFileLanguageService getLanguageService(String mimeType) {
        return this._languageServices.get(mimeType);
    }

    public void connectSourceProvider(final IFileSourceProvider sourceProvider) {
        if (this._connectedSourceProvider != null) {
            throw new IllegalStateException(StringUtils.format((String)Messages.FileService_CantConnetSourceProvider, (Object[])new String[]{sourceProvider.getSourceURI(), this._connectedSourceProvider.getSourceURI()}));
        }
        this._connectedSourceProvider = sourceProvider;
        this.visitLanguageServices(new IFileLanguageServiceVisitor(){

            public void visit(IFileLanguageService service) {
                service.connectSourceProvider(sourceProvider);
            }
        });
        this.doFullParse();
    }

    public void disconnectSourceProvider(final IFileSourceProvider sourceProvider) {
        if (sourceProvider != null && this._connectedSourceProvider != sourceProvider) {
            if (this._connectedSourceProvider != null && sourceProvider != null) {
                throw new IllegalStateException(StringUtils.format((String)Messages.FileService_SourceProviderAlreadyConnected, (Object[])new String[]{sourceProvider.getSourceURI(), this._connectedSourceProvider.getSourceURI()}));
            }
            throw new IllegalStateException(Messages.FileService_SourceProviderNotConnected);
        }
        if (this.getSourceProvider() != null) {
            FileContextManager.remove(this.getSourceProvider().getSourceURI());
        }
        IdleFileChangedNotifier.instance().removeContentChangedEvent(this);
        LongIdleFileChangedNotifier.instance().removeContentChangedEvent(this);
        this._listeners.clear();
        this._delayedListeners.clear();
        this._longDelayedListeners.clear();
        this._errorListeners.clear();
        Object[] vals = this._languageServices.values().toArray();
        int i = 0;
        while (i < vals.length) {
            IFileLanguageService element = (IFileLanguageService)vals[i];
            element.disconnectSourceProvider(sourceProvider);
            ++i;
        }
        this._languageServices.clear();
        this.visitLanguageServices(new IFileLanguageServiceVisitor(){

            public void visit(IFileLanguageService service) {
                service.disconnectSourceProvider(sourceProvider);
            }
        });
        if (this._errorManager != null) {
            this.removeLongDelayedFileListener(this._errorManager);
            this._errorManager = null;
        }
        this._partitionScanner = null;
        this._defaultSourceProvider = null;
        this._connectedSourceProvider = null;
        this._parseState = null;
        this._parser = null;
        this._parserLock = null;
        this._partitions = null;
        this._errorMarkers = null;
    }

    public IFileSourceProvider getSourceProvider() {
        return this._connectedSourceProvider != null ? this._connectedSourceProvider : this._defaultSourceProvider;
    }

    public boolean isConnected() {
        return this._connectedSourceProvider != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContent(String insertedSource, int offset, int removeLength) {
        IFileSourceProvider sourceProvider = this.getSourceProvider();
        try {
            IParseState parseState = this.getParseState();
            if (parseState != null) {
                String fullSource = sourceProvider.getSource();
                parseState.setEditState(fullSource, insertedSource, offset, removeLength);
            }
            FileService fileService = this;
            synchronized (fileService) {
                Object object = this._parserLock;
                synchronized (object) {
                    IPartitionScanner partitionScanner = this.getPartitioner();
                    if (partitionScanner != null) {
                        partitionScanner.startPartitionScan();
                    }
                    if (parseState != null) {
                        if (this._scanner != null) {
                            this.doFastParse(parseState);
                        } else {
                            this.doParse(parseState);
                        }
                    }
                    if (partitionScanner != null) {
                        this._partitions = partitionScanner.endPartitionScan();
                    }
                }
            }
            this.fireContentChangedEvent(insertedSource, offset, removeLength);
        }
        catch (IOException e) {
            IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.FileService_UpdateContentFailed, (Throwable)e);
        }
    }

    public LexemeList getLexemeList() {
        if (this._parseState == null) {
            return null;
        }
        return this._parseState.getLexemeList();
    }

    protected IPartitionScanner getPartitioner() {
        if (this._partitionScanner == null) {
            this._partitionScanner = new UnifiedPartitionScanner(this, this.getDefaultLanguage());
        }
        return this._partitionScanner;
    }

    public ITypedRegion[] getPartitions() {
        return this._partitions;
    }

    public void setPartitions(ITypedRegion[] partitions) {
        this._partitions = partitions;
    }

    public ITypedRegion getPartitionAtOffset(int offset) {
        ITypedRegion result = null;
        int i = 0;
        while (i < this._partitions.length) {
            ITypedRegion p = this._partitions[i];
            if (p.getOffset() <= offset && p.getOffset() + p.getLength() >= offset) {
                result = p;
                break;
            }
            ++i;
        }
        return result;
    }

    public IParseState getParseState() {
        return this._parseState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFullParse() {
        IFileSourceProvider sourceProvider = this.getSourceProvider();
        try {
            String fullSource = sourceProvider.getSource();
            FileService fileService = this;
            synchronized (fileService) {
                Object object = this._parserLock;
                synchronized (object) {
                    IPartitionScanner partitionScanner = this.getPartitioner();
                    IParseState parseState = this.getParseState();
                    if (partitionScanner != null) {
                        partitionScanner.startPartitionScan();
                    }
                    if (parseState != null) {
                        LexemeList lexemes;
                        LexemeList lexemeList = lexemes = parseState.getLexemeList();
                        synchronized (lexemeList) {
                            lexemes.clear();
                            parseState.setEditState(fullSource, fullSource, 0, 0);
                            this.doParse(parseState);
                            parseState.clearEditState();
                        }
                    }
                    if (partitionScanner != null) {
                        this._partitions = partitionScanner.endPartitionScan();
                    }
                }
            }
            this.forceContentChangedEvent();
        }
        catch (IOException e) {
            IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.FileService_DoFullParseFailed, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doParse(IParseState parseState) {
        LexemeList lexemeList;
        LexemeList lexemeList2 = lexemeList = parseState.getLexemeList();
        synchronized (lexemeList2) {
            if (this._parser != null) {
                try {
                    ILanguageChangeListener oldEventHandler = this._parser.getLanguageChangeListener();
                    this._parser.setLanguageChangeListener(this._languageChangeListener);
                    this._parser.parse(parseState);
                    this._parser.setLanguageChangeListener(oldEventHandler);
                }
                catch (LexerException e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.FileService_DoParseFailedLexer, (Throwable)e);
                }
                catch (ParseException e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.FileService_DoParseFailedParse, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFastParse(IParseState parseState) {
        LexemeList lexemeList;
        LexemeList lexemeList2 = lexemeList = parseState.getLexemeList();
        synchronized (lexemeList2) {
            if (this._scanner != null) {
                try {
                    ILanguageChangeListener oldEventHandler = this._scanner.getLanguageChangeListener();
                    this._scanner.setLanguageChangeListener(this._languageChangeListener);
                    this._scanner.parse(parseState);
                    this._scanner.setLanguageChangeListener(oldEventHandler);
                }
                catch (LexerException e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.FileService_DoParseFailedLexer, (Throwable)e);
                }
                catch (ParseException e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.FileService_DoParseFailedParse, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileListener(IFileContextListener fileListener) {
        List<IFileContextListener> list = this._listeners;
        synchronized (list) {
            this._listeners.add(fileListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileListener(IFileContextListener fileListener) {
        List<IFileContextListener> list = this._listeners;
        synchronized (list) {
            this._listeners.remove(fileListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelayedFileListener(IFileContextListener fileListener) {
        List<IFileContextListener> list = this._delayedListeners;
        synchronized (list) {
            this._delayedListeners.add(fileListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDelayedFileListener(IFileContextListener fileListener) {
        List<IFileContextListener> list = this._delayedListeners;
        synchronized (list) {
            this._delayedListeners.remove(fileListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLongDelayedFileListener(IFileContextListener fileListener) {
        List<IFileContextListener> list = this._longDelayedListeners;
        synchronized (list) {
            this._longDelayedListeners.add(fileListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLongDelayedFileListener(IFileContextListener fileListener) {
        List<IFileContextListener> list = this._longDelayedListeners;
        synchronized (list) {
            this._longDelayedListeners.remove(fileListener);
        }
    }

    public void fireContentChangedEvent(String insertedSource, int offset, int removeLength) {
        FileContextContentEvent evt = this.createContentChangedEventAndFire(insertedSource, offset, removeLength);
        IdleFileChangedNotifier.instance().queueContentChangedEvent(this, evt);
        LongIdleFileChangedNotifier.instance().queueContentChangedEvent(this, evt);
    }

    public void forceContentChangedEvent() {
        this.fireContentChangedEvent("", 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileContextContentEvent createContentChangedEventAndFire(String insertedSource, int offset, int removeLength) {
        IFileContextListener[] listenerArray;
        List<IFileContextListener> list = this._listeners;
        synchronized (list) {
            listenerArray = this._listeners.toArray(new IFileContextListener[this._listeners.size()]);
        }
        int srcLen = insertedSource == null ? 0 : insertedSource.length();
        int finalOffset = offset + srcLen - removeLength;
        FileContextContentEvent evt = new FileContextContentEvent(this, finalOffset);
        this.fireContentChangedEvent(listenerArray, evt);
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDelayedContentChangedEvent(FileContextContentEvent evt) {
        IFileContextListener[] listenerArray;
        List<IFileContextListener> list = this._delayedListeners;
        synchronized (list) {
            listenerArray = this._delayedListeners.toArray(new IFileContextListener[this._delayedListeners.size()]);
        }
        this.fireContentChangedEvent(listenerArray, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireLongDelayedContentChangedEvent(FileContextContentEvent evt) {
        IFileContextListener[] listenerArray;
        List<IFileContextListener> list = this._longDelayedListeners;
        synchronized (list) {
            listenerArray = this._longDelayedListeners.toArray(new IFileContextListener[this._longDelayedListeners.size()]);
        }
        this.fireContentChangedEvent(listenerArray, evt);
    }

    private void fireContentChangedEvent(IFileContextListener[] listenerArray, FileContextContentEvent evt) {
        IFileContextListener[] iFileContextListenerArray = listenerArray;
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFileContextListener listener = iFileContextListenerArray[n2];
            try {
                listener.onContentChanged(evt);
            }
            catch (Exception e) {
                IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.FileService_ErrorOnFireChangedEvent, (Throwable)e);
            }
            ++n2;
        }
    }

    public String getSource() {
        try {
            return this.getSourceProvider().getSource();
        }
        catch (IOException e) {
            IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.FileService_GetSourceFailed, (Throwable)e);
            return "";
        }
    }

    public String getDefaultLanguage() {
        return this._defaultLanguage;
    }

    public void setLanguageChangeListener(IPartitionScanner languageChangeListener) {
        this._languageChangeListener = languageChangeListener;
    }

    public void setFileErrors(IFileError[] markers) {
        this._errorMarkers = markers;
        this.fireErrorsChanged();
    }

    public IFileError[] getFileErrors() {
        return this._errorMarkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorListener(IFileErrorListener listener) {
        List<IFileErrorListener> list = this._errorListeners;
        synchronized (list) {
            this._errorListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorListener(IFileErrorListener listener) {
        List<IFileErrorListener> list = this._errorListeners;
        synchronized (list) {
            this._errorListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireErrorsChanged() {
        IFileErrorListener[] listeners = null;
        List<IFileErrorListener> list = this._errorListeners;
        synchronized (list) {
            listeners = this._errorListeners.toArray(new IFileErrorListener[this._errorListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            IFileErrorListener element = listeners[i];
            element.onErrorsChanged(this._errorMarkers);
            ++i;
        }
    }

    public void setErrorManager(IErrorManager errorManager) {
        if (this._errorManager != null) {
            this.removeLongDelayedFileListener(this._errorManager);
        }
        this._errorManager = errorManager;
        if (this._errorManager != null) {
            this.addLongDelayedFileListener(this._errorManager);
        }
    }

    public void activateForEditing() {
        this.visitLanguageServices(new IFileLanguageServiceVisitor(){

            public void visit(IFileLanguageService service) {
                service.activateForEditing();
            }
        });
    }

    public void deactivateForEditing() {
        this.visitLanguageServices(new IFileLanguageServiceVisitor(){

            public void visit(IFileLanguageService service) {
                service.deactivateForEditing();
            }
        });
    }

    private void visitLanguageServices(IFileLanguageServiceVisitor v) {
        for (IFileLanguageService fls : this._languageServices.values()) {
            v.visit(fls);
        }
    }

    public IFileContextListener[] getFileListeners() {
        return this._listeners.toArray(new IFileContextListener[this._listeners.size()]);
    }

    public IFileContextListener[] getDelayedFileListeners() {
        return this._delayedListeners.toArray(new IFileContextListener[this._delayedListeners.size()]);
    }

    public IFileContextListener[] getLongDelayedFileListeners() {
        return this._longDelayedListeners.toArray(new IFileContextListener[this._longDelayedListeners.size()]);
    }

    public boolean hasFileListenerAdded(IFileContextListener listener) {
        return this._listeners.contains(listener);
    }

    public boolean hasDelayedFileListenerAdded(IFileContextListener listener) {
        return this._delayedListeners.contains(listener);
    }

    public boolean hasLongDelayedFileListenerAdded(IFileContextListener listener) {
        return this._longDelayedListeners.contains(listener);
    }

    static interface IFileLanguageServiceVisitor {
        public void visit(IFileLanguageService var1);
    }
}

