/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.ICodeFormatter;
import com.aptana.ide.editors.unified.IPairFinder;
import com.aptana.ide.editors.unified.InstanceCreator;
import com.aptana.ide.editors.unified.colorizer.ColorizerReader;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.colorizer.Messages;
import com.aptana.ide.lexer.TokenList;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.eclipse.ParsingRegistry;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IdentifierEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LanguageRegistry {
    private static final String PAIRFINDER_ID = "com.aptana.ide.editors.pairfinder";
    private static final String FORMATTER_ID = "com.aptana.ide.editors.formatter";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_LANGUAGE = "language";
    private static final String TAG_PAIR_FINDER = "pairFinder";
    private static final String TAG_FORMATTER = "formatter";
    private static Map<String, LanguageColorizer> languageColorizers = new HashMap<String, LanguageColorizer>();
    private static Map<String, InstanceCreator> pairFinders = new HashMap<String, InstanceCreator>();
    private static Map<String, InstanceCreator> formatters = new HashMap<String, InstanceCreator>();
    private static ColorizerReader colorizerReader;
    private static final IActivityManager activityManager;
    private static IIdentifierListener identifierListener;

    static {
        activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        identifierListener = new IIdentifierListener(){

            public void identifierChanged(IdentifierEvent identifierEvent) {
                IIdentifier identifier;
                if (identifierEvent.hasEnabledChanged() && (identifier = identifierEvent.getIdentifier()).isEnabled()) {
                    LanguageRegistry.reloadAll();
                }
            }
        };
        LanguageRegistry.loadAll();
    }

    private LanguageRegistry() {
    }

    public static void clearAll() {
        languageColorizers.clear();
        pairFinders.clear();
        formatters.clear();
    }

    public static void loadAll() {
        LanguageRegistry.loadColorizations();
        LanguageRegistry.loadPairFinders();
        LanguageRegistry.loadCodeFormatters();
    }

    public static void reloadAll() {
        LanguageRegistry.clearAll();
        LanguageRegistry.loadAll();
    }

    public static LanguageColorizer getLanguageColorizer(String language) {
        LanguageColorizer original = null;
        if (languageColorizers.containsKey(language)) {
            original = languageColorizers.get(language);
        } else if (colorizerReader.getInstanceCreator(language) != null) {
            InstanceCreator creator = colorizerReader.getInstanceCreator(language);
            original = (LanguageColorizer)creator.getCachedInstance();
        } else {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.LanguageRegistry_NO_COLORIZER, (String)language));
        }
        return original;
    }

    public static LanguageColorizer getLanguageColorizer(String language, ColorizerReader reader) {
        LanguageColorizer original = null;
        if (languageColorizers.containsKey(language)) {
            original = languageColorizers.get(language);
        } else if (reader.getInstanceCreator(language) != null) {
            InstanceCreator creator = reader.getInstanceCreator(language);
            original = (LanguageColorizer)creator.getCachedInstance();
        } else {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.LanguageRegistry_NO_COLORIZER, (String)language));
        }
        return original;
    }

    public static List<LanguageColorizer> getLanguageColorizers() {
        return new ArrayList<LanguageColorizer>(languageColorizers.values());
    }

    public static String getPreferenceId(String language) {
        return colorizerReader.getPreferenceId(language);
    }

    public static IParser getParser(String language) {
        return ParsingRegistry.getParser((String)language);
    }

    public static IParser getScanner(String language) {
        return ParsingRegistry.getScanner((String)language);
    }

    public static IPairFinder getPairFinder(String language) {
        IPairFinder result = null;
        if (pairFinders.containsKey(language)) {
            InstanceCreator creator = pairFinders.get(language);
            result = (IPairFinder)creator.getCachedInstance();
        } else {
            String message = MessageFormat.format(Messages.LanguageRegistry_No_Associated_Finder, language);
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)message);
        }
        return result;
    }

    public static ICodeFormatter getCodeFormatter(String language) {
        ICodeFormatter result = null;
        if (formatters.containsKey(language)) {
            InstanceCreator creator = formatters.get(language);
            result = (ICodeFormatter)creator.getCachedInstance();
        } else {
            String message = MessageFormat.format(Messages.LanguageRegistry_No_Associated_Formatter, language);
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)message);
        }
        return result;
    }

    public static TokenList getTokenList(String language) {
        return ParsingRegistry.getTokenList((String)language);
    }

    public static TokenList getTokenListByExtension(String extension) {
        return ParsingRegistry.getTokenListByExtension((String)extension);
    }

    public static IParser createParser(String language) {
        return ParsingRegistry.createParser((String)language);
    }

    public static IParser createScanner(String language) {
        return ParsingRegistry.createScanner((String)language);
    }

    public static TokenList createTokenList(InputStream input) {
        try {
            return ParsingRegistry.createTokenList((InputStream)input);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.LanguageRegistry_Cannot_Create_Token_List, (Throwable)e);
            return null;
        }
    }

    public static TokenList createTokenList(String language) {
        return ParsingRegistry.createTokenList((String)language);
    }

    public static boolean hasLanguageColorizer(String language) {
        return languageColorizers.containsKey(language);
    }

    public static boolean hasParser(String language) {
        return ParsingRegistry.hasParser((String)language);
    }

    public static boolean hasScanner(String language) {
        return ParsingRegistry.hasScanner((String)language);
    }

    public static boolean hasTokenList(String language) {
        return ParsingRegistry.hasTokenList((String)language);
    }

    public static void importColorization(File file, String language) {
        colorizerReader.importColorization(file, language);
    }

    private static void loadColorizations() {
        colorizerReader = new ColorizerReader();
        colorizerReader.loadExtensionPointColorizers();
    }

    public static final boolean isActivityEnabled(IConfigurationElement element) {
        IIdentifier id;
        String extensionId = element.getAttribute("id");
        String extensionPluginId = element.getNamespaceIdentifier();
        String extensionString = null;
        if (extensionPluginId != null && extensionId != null && extensionPluginId.length() > 0 && extensionId.length() > 0) {
            extensionString = String.valueOf(extensionPluginId) + "/" + extensionId;
        } else if (extensionPluginId != null && extensionPluginId.length() > 0) {
            extensionString = String.valueOf(extensionPluginId) + "/.*";
        }
        if (extensionString != null && (id = activityManager.getIdentifier(extensionString)) != null) {
            boolean enabled = id.isEnabled();
            if (!id.isEnabled()) {
                id.addIdentifierListener(identifierListener);
            }
            return enabled;
        }
        return true;
    }

    private static void loadPairFinders() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(PAIRFINDER_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (LanguageRegistry.isActivityEnabled(element) && elementName.equals(TAG_PAIR_FINDER)) {
                        String finderClass = element.getAttribute(ATTR_CLASS);
                        String language = element.getAttribute(ATTR_LANGUAGE);
                        if (finderClass != null && language != null && language.length() > 0) {
                            InstanceCreator creator = new InstanceCreator(element, ATTR_CLASS);
                            pairFinders.put(language, creator);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void loadCodeFormatters() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(FORMATTER_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (LanguageRegistry.isActivityEnabled(element) && elementName.equals(TAG_FORMATTER)) {
                        String finderClass = element.getAttribute(ATTR_CLASS);
                        String language = element.getAttribute(ATTR_LANGUAGE);
                        if (finderClass != null && language != null && language.length() > 0) {
                            InstanceCreator creator = new InstanceCreator(element, ATTR_CLASS);
                            formatters.put(language, creator);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static void registerLanguageColorizer(String language, LanguageColorizer colorizer) {
        if (!languageColorizers.containsKey(language)) {
            languageColorizers.put(language, colorizer);
        } else {
            LanguageColorizer curr = languageColorizers.get(language);
            curr.setCategoryColorizers(colorizer);
            curr.setTokenColorizers(colorizer);
            curr.setBackground(colorizer.getBackground());
            curr.setCaretColor(colorizer.getCaretColor());
            curr.setLineHighlightColor(colorizer.getLineHighlightColor());
            curr.setSelectionBackground(colorizer.getSelectionBackground());
            curr.setSelectionForeground(colorizer.getSelectionForeground());
            curr.setFoldingBg(colorizer.getFoldingBg());
            curr.setFoldingFg(colorizer.getFoldingFg());
        }
    }

    public static void registerParser(String language, IParser parser) {
        ParsingRegistry.registerParser((String)language, (IParser)parser);
    }

    public static void registerScanner(String language, IParser parser) {
        ParsingRegistry.registerScanner((String)language, (IParser)parser);
    }

    public static void registerTokenList(TokenList tokenList) {
        ParsingRegistry.registerTokenList((TokenList)tokenList);
    }

    public static void registerTokenList(TokenList tokenList, String fileExtension) {
        ParsingRegistry.registerTokenList((TokenList)tokenList, (String)fileExtension);
    }

    public static void restoreDefaultColorization(String language) {
        colorizerReader.restoreDefault(language);
    }

    public static void setPreferenceId(String language, String preferenceId) {
        colorizerReader.setPreferenceId(language, preferenceId);
    }

    public static void unregisterLanguageColorizer(String language) {
        LanguageColorizer curr = languageColorizers.remove(language);
        if (curr != null) {
            LanguageColorizer colorizer = new LanguageColorizer(curr.getLanguage());
            curr.setCategoryColorizers(colorizer);
            curr.setTokenColorizers(colorizer);
            curr.setBackground(colorizer.getBackground());
            curr.setCaretColor(colorizer.getCaretColor());
            curr.setLineHighlightColor(colorizer.getLineHighlightColor());
            curr.setSelectionBackground(colorizer.getSelectionBackground());
            curr.setSelectionForeground(colorizer.getSelectionForeground());
        }
    }

    public static void unregisterParser(String language) {
        ParsingRegistry.unregisterParser((String)language);
    }

    public static void unregisterScanner(String language) {
        ParsingRegistry.unregisterScanner((String)language);
    }

    public static void clearTokenList(String language) {
        ParsingRegistry.clearTokenList((String)language);
    }

    public static void unregisterTokenList(TokenList tokenList) {
        ParsingRegistry.unregisterTokenList((TokenList)tokenList);
    }
}

