/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.unified.FileContextContentEvent;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IChildOffsetMapper;
import com.aptana.ide.editors.unified.IFileContextListener;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.Messages;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.ICodeLocation;
import java.util.HashMap;
import java.util.Map;

public final class ParentOffsetMapper
implements IParentOffsetMapper,
IFileContextListener {
    private FileService _fileService;
    private int _currentLexemeIndex;
    private Lexeme _currentLexeme;
    private Map<String, IChildOffsetMapper> _children;
    private boolean _isDisposing = false;

    public ParentOffsetMapper(FileService fileService) {
        if (fileService == null) {
            throw new NullPointerException(Messages.ParentOffsetMapper_IFileContentNotNull);
        }
        this._fileService = fileService;
        this._children = new HashMap<String, IChildOffsetMapper>();
        fileService.addFileListener(this);
    }

    public FileService getFileService() {
        return this._fileService;
    }

    public void addChildMapper(String mimeType, IChildOffsetMapper child) {
        this._children.put(mimeType, child);
    }

    public IChildOffsetMapper getChild(String mimeType) {
        if (this._children.containsKey(mimeType)) {
            return this._children.get(mimeType);
        }
        throw new IllegalStateException(String.valueOf(mimeType) + Messages.ParentOffsetMapper_LanguageNotSupported);
    }

    public LexemeList getLexemeList() {
        return this._fileService.getLexemeList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateCurrentLexeme(int offset) {
        LexemeList lexemeList = this.getLexemeList();
        if (lexemeList != null) {
            LexemeList lexemeList2 = lexemeList;
            synchronized (lexemeList2) {
                this._currentLexemeIndex = this.getLexemeIndexFromDocumentOffset(offset);
                this._currentLexeme = this._currentLexemeIndex > -1 ? this.getLexemeList().get(this._currentLexemeIndex) : null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lexeme getLexemeAtIndex(int index) {
        LexemeList ll;
        Lexeme result = null;
        if (index >= 0 && (ll = this._fileService.getLexemeList()) != null) {
            LexemeList lexemeList = ll;
            synchronized (lexemeList) {
                if (index < ll.size()) {
                    result = ll.get(index);
                }
            }
        }
        return result;
    }

    public Lexeme getCurrentLexeme() {
        return this._currentLexeme;
    }

    public int getCurrentLexemeIndex() {
        return this._currentLexemeIndex;
    }

    public int getLexemeIndexFromDocumentOffset(int offset) {
        return ParentOffsetMapper.getLexemeIndexFromDocumentOffset(offset, this.getLexemeList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLexemeIndexFromDocumentOffset(int offset, LexemeList ll) {
        int index = -1;
        if (offset >= 0 && ll != null) {
            LexemeList lexemeList = ll;
            synchronized (lexemeList) {
                if (ll.size() > 0 && (index = ll.getLexemeIndex(offset - 1)) < 1) {
                    index = index < -1 ? -index - 2 : 0;
                }
            }
        }
        return index;
    }

    public void onContentChanged(FileContextContentEvent evt) {
        this.calculateCurrentLexeme(evt.getOffset());
    }

    public ICodeLocation findTarget(Lexeme lexeme) {
        return null;
    }

    public void dispose() {
        if (this._isDisposing) {
            return;
        }
        this._isDisposing = true;
        this._fileService.removeFileListener(this);
        if (this._children != null) {
            Object[] objs = this._children.values().toArray();
            int i = 0;
            while (i < objs.length) {
                IChildOffsetMapper child = (IChildOffsetMapper)objs[i];
                child.dispose();
                ++i;
            }
            this._children.clear();
            this._children = null;
        }
        this._fileService = null;
        this._currentLexeme = null;
    }
}

