/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;

public class UnifiedAnnotationHover
implements IAnnotationHover {
    private int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            int xmlAnnotationLine;
            block5: {
                try {
                    xmlAnnotationLine = document.getLineOfOffset(position.getOffset());
                    if (line != xmlAnnotationLine) break block5;
                    return 1;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (xmlAnnotationLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                return 2;
            }
        }
        return 0;
    }

    private List getXMLAnnotationsForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<Annotation> exact = new ArrayList<Annotation>();
        Iterator e = model.getAnnotationIterator();
        HashMap messagesAtPosition = new HashMap();
        while (e.hasNext()) {
            Annotation a;
            Position position;
            Object o = e.next();
            if (!(o instanceof Annotation) || (position = model.getPosition(a = (Annotation)o)) == null || this.isDuplicateXMLAnnotation(messagesAtPosition, position, a.getText())) continue;
            switch (this.compareRulerLine(position, document, line)) {
                case 1: {
                    exact.add(a);
                    break;
                }
            }
        }
        return exact;
    }

    private boolean isDuplicateXMLAnnotation(Map messagesAtPosition, Position position, String message) {
        if (messagesAtPosition.containsKey(position)) {
            Object value = messagesAtPosition.get(position);
            if (message.equals(value)) {
                return true;
            }
            if (value instanceof List) {
                List messages = (List)value;
                if (messages.contains(message)) {
                    return true;
                }
                messages.add(message);
            } else {
                ArrayList<Object> messages = new ArrayList<Object>();
                messages.add(value);
                messages.add(message);
                messagesAtPosition.put(position, messages);
            }
        } else {
            messagesAtPosition.put(position, message);
        }
        return false;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List xmlAnnotations = this.getXMLAnnotationsForLine(sourceViewer, lineNumber);
        if (xmlAnnotations != null) {
            if (xmlAnnotations.size() == 1) {
                Annotation xmlAnnotation = (Annotation)xmlAnnotations.get(0);
                String message = xmlAnnotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return this.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>(xmlAnnotations.size());
                for (Annotation xmlAnnotation : xmlAnnotations) {
                    String message = xmlAnnotation.getText();
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return this.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return this.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    private String formatSingleMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    private String formatMultipleMessages(List messages) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent("Multiple items at this position:"));
        HTMLPrinter.startBulletList(buffer);
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            HTMLPrinter.addBullet(buffer, HTMLPrinter.convertToHTMLContent((String)e.next()));
        }
        HTMLPrinter.endBulletList(buffer);
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    static final class HTMLPrinter {
        private HTMLPrinter() {
        }

        private static String replace(String text, char c, String s) {
            int previous = 0;
            int current = text.indexOf(c, previous);
            if (current == -1) {
                return text;
            }
            StringBuffer buffer = new StringBuffer();
            while (current > -1) {
                buffer.append(text.substring(previous, current));
                buffer.append(s);
                previous = current + 1;
                current = text.indexOf(c, previous);
            }
            buffer.append(text.substring(previous));
            return buffer.toString();
        }

        public static String convertToHTMLContent(String content) {
            content = HTMLPrinter.replace(content, '<', "&lt;");
            return HTMLPrinter.replace(content, '>', "&gt;");
        }

        public static String read(Reader rd) {
            StringBuffer buffer = new StringBuffer();
            char[] readBuffer = new char[2048];
            try {
                int n = rd.read(readBuffer);
                while (n > 0) {
                    buffer.append(readBuffer, 0, n);
                    n = rd.read(readBuffer);
                }
                return buffer.toString();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public static void insertPageProlog(StringBuffer buffer, int position) {
            buffer.insert(position, "<html><body text=\"#000000\" bgcolor=\"#FFFF88\"><font size=-1>");
        }

        public static void addPageProlog(StringBuffer buffer) {
            HTMLPrinter.insertPageProlog(buffer, buffer.length());
        }

        public static void addPageEpilog(StringBuffer buffer) {
            buffer.append("</font></body></html>");
        }

        public static void startBulletList(StringBuffer buffer) {
            buffer.append("<ul>");
        }

        public static void endBulletList(StringBuffer buffer) {
            buffer.append("</ul>");
        }

        public static void addBullet(StringBuffer buffer, String bullet) {
            if (bullet != null) {
                buffer.append("<li>");
                buffer.append(bullet);
                buffer.append("</li>");
            }
        }

        public static void addSmallHeader(StringBuffer buffer, String header) {
            if (header != null) {
                buffer.append("<h5>");
                buffer.append(header);
                buffer.append("</h5>");
            }
        }

        public static void addParagraph(StringBuffer buffer, String paragraph) {
            if (paragraph != null) {
                buffer.append("<p>");
                buffer.append(paragraph);
            }
        }

        public static void addParagraph(StringBuffer buffer, Reader paragraphReader) {
            if (paragraphReader != null) {
                HTMLPrinter.addParagraph(buffer, HTMLPrinter.read(paragraphReader));
            }
        }
    }
}

