/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.managers.FileContextManager;
import com.aptana.ide.editors.unified.FileService;
import java.util.ArrayList;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.IDocumentPartitionerExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;

public class UnifiedDocumentPartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IDocumentPartitionerExtension2,
IDocumentPartitionerExtension3 {
    private ITypedRegion[] _partitions;
    private String[] _legalContentTypes;
    private String _sourceURI;
    private IDocument _document;

    public UnifiedDocumentPartitioner(String sourceURI) {
        this._sourceURI = sourceURI;
    }

    public void connect(IDocument document) {
        this.connect(document, false);
    }

    public void connect(IDocument document, boolean delayInitialization) {
        FileService fs;
        this._document = document;
        if (this._partitions != null && this._partitions.length == 0 && (fs = FileContextManager.get(this._sourceURI)) != null) {
            fs.doFullParse();
        }
        this.setPartitions();
    }

    public void setPartitions() {
        FileService fs = FileContextManager.get(this._sourceURI);
        if (fs != null) {
            this._partitions = fs.getPartitions();
        }
    }

    public void disconnect() {
        this._partitions = new TypedRegion[0];
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        this.documentChanged2(event);
        return true;
    }

    public String[] getLegalContentTypes() {
        return this._legalContentTypes;
    }

    public void setLegalContentTypes(String[] partitions) {
        this._legalContentTypes = partitions;
    }

    public String getContentType(int offset) {
        return this.getContentType(offset, false);
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        return this.computePartitioning(offset, length, false);
    }

    public ITypedRegion getPartition(int offset) {
        return this.getPartition(offset, false);
    }

    public IRegion documentChanged2(DocumentEvent event) {
        FileService fs = FileContextManager.get(this._sourceURI);
        if (fs != null) {
            fs.updateContent(event.getText(), event.fOffset, event.getLength());
            this._partitions = fs.getPartitions();
        }
        return null;
    }

    public String[] getManagingPositionCategories() {
        return null;
    }

    public String getContentType(int offset, boolean preferOpenPartitions) {
        String result = "__dflt_position_category";
        if (this._partitions != null) {
            int i = 0;
            while (i < this._partitions.length) {
                ITypedRegion p = this._partitions[i];
                if (p.getOffset() + p.getLength() >= offset) {
                    result = p.getType();
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public ITypedRegion getPartition(int offset, boolean preferOpenPartitions) {
        if (this._partitions != null) {
            int i = 0;
            while (i < this._partitions.length) {
                ITypedRegion p = this._partitions[i];
                if (p.getOffset() + p.getLength() >= offset) {
                    return p;
                }
                ++i;
            }
        }
        int length = 0;
        if (this._document != null) {
            length = this._document.getLength();
        }
        return new TypedRegion(0, length, "__dflt_position_category");
    }

    public ITypedRegion[] computePartitioning(int offset, int length, boolean includeZeroLengthPartitions) {
        ArrayList<TypedRegion> pts = new ArrayList<TypedRegion>();
        int i = 0;
        while (i < this._partitions.length) {
            ITypedRegion p = this._partitions[i];
            int poffset = p.getOffset();
            int plen = p.getLength();
            int pend = poffset + plen;
            int start = poffset;
            int len = plen;
            if (pend >= offset) {
                if (poffset > offset + length) break;
                if (pend > offset + length) {
                    len = offset + length - poffset;
                }
                if (poffset < offset) {
                    start = offset;
                    len = pend - offset;
                }
                if (poffset < offset && pend > offset + length) {
                    start = offset;
                    len = length;
                }
                if (includeZeroLengthPartitions) {
                    pts.add(new TypedRegion(start, len, p.getType()));
                } else if (len > 0) {
                    pts.add(new TypedRegion(start, len, p.getType()));
                }
            }
            ++i;
        }
        return pts.toArray(new ITypedRegion[pts.size()]);
    }

    public void startRewriteSession(DocumentRewriteSession session) throws IllegalStateException {
    }

    public void stopRewriteSession(DocumentRewriteSession session) {
    }

    public DocumentRewriteSession getActiveRewriteSession() {
        return null;
    }
}

