/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IPartitionScanner;
import com.aptana.ide.editors.unified.Messages;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;

public class UnifiedPartitionScanner
implements IPartitionScanner {
    private FileService _fileService;
    private List<TypedRegion> _partitions;
    private int _currentOffset;
    private String _defaultLanguage;
    private String _currentLanguage;

    public UnifiedPartitionScanner(FileService service, String defaultLanguage) {
        if (service == null) {
            throw new IllegalArgumentException(Messages.UnifiedPartitionScanner_ServiceNotNull);
        }
        if (defaultLanguage == null || defaultLanguage.length() == 0) {
            throw new IllegalArgumentException(Messages.UnifiedPartitionScanner_DefaultLanguageMustBeDefined);
        }
        this._fileService = service;
        this._partitions = new ArrayList<TypedRegion>();
        this._defaultLanguage = defaultLanguage;
    }

    public void startPartitionScan() {
        this._partitions.clear();
        this._currentOffset = 0;
        this._currentLanguage = this._defaultLanguage;
        this._fileService.setLanguageChangeListener(this);
    }

    public ITypedRegion[] endPartitionScan() {
        ITypedRegion[] result;
        this._fileService.setLanguageChangeListener(null);
        int sourceLength = this._fileService.getSourceProvider().getSourceLength();
        LexemeList lexemes = this._fileService.getLexemeList();
        if (lexemes != null && lexemes.size() > 0) {
            Lexeme lastLexeme = lexemes.get(lexemes.size() - 1);
            int endingOffset = lastLexeme.offset + lastLexeme.length;
            if (this._currentLanguage.equals(this._defaultLanguage)) {
                int length = sourceLength - this._currentOffset;
                this._partitions.add(new TypedRegion(this._currentOffset, length, this._defaultLanguage));
            } else {
                int length = endingOffset - this._currentOffset;
                int whitespaceLength = sourceLength - endingOffset;
                this._partitions.add(new TypedRegion(this._currentOffset, length, this._currentLanguage));
                this._partitions.add(new TypedRegion(endingOffset, whitespaceLength, this._defaultLanguage));
            }
            result = this._partitions.toArray(new ITypedRegion[this._partitions.size()]);
        } else {
            result = new ITypedRegion[]{new TypedRegion(0, sourceLength, this._defaultLanguage)};
        }
        return result;
    }

    public void startNewLanguage(String type, int offset) {
        if (!this._currentLanguage.equals(type)) {
            int length = offset - this._currentOffset;
            TypedRegion typedRegion = new TypedRegion(this._currentOffset, length, this._currentLanguage);
            this._partitions.add(typedRegion);
            this._currentOffset = offset;
            this._currentLanguage = type;
        }
    }
}

