/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.ICodeFormatter;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.actions.Messages;
import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CodeFormatAction
extends Action
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    private static final String TEXT_HTML = "text/html";
    private IUnifiedEditor part = null;
    private String lineSeparator = System.getProperty("line.separator");
    private int tabWitdh = 4;
    private String tabChar = "";

    public CodeFormatAction() {
        this.setText(Messages.CodeFormatAction_CodeFormatTitle);
        this.setActionDefinitionId("com.aptana.ide.editors.unified.format");
    }

    public void run() {
        int endOffset;
        int initialOffset;
        Lexeme lexeme;
        IDocument document;
        ISelectionProvider selectionProvider = this.part.getViewer().getSelectionProvider();
        TextSelection selection = (TextSelection)selectionProvider.getSelection();
        LexemeList list = this.part.getFileContext().getParseState().getLexemeList();
        StyledText textWidget = this.part.getViewer().getTextWidget();
        int caretOffset = textWidget.getCaretOffset();
        int lsIndex = list.getLexemeFloorIndex(caretOffset);
        int offsetFromLex = 0;
        if (lsIndex != -1) {
            offsetFromLex = caretOffset - list.get(lsIndex).getEndingOffset();
        }
        int lineOffset = textWidget.getOffsetAtLine(textWidget.getTopIndex());
        int lineIndex = list.getLexemeFloorIndex(lineOffset);
        int lineOffsetFromLex = 0;
        if (lineIndex != -1) {
            lineOffsetFromLex = lineOffset - list.get(lineIndex).getEndingOffset();
        }
        if ((document = this.part.getViewer().getDocument()) instanceof IDocumentExtension4) {
            IDocumentExtension4 ext = (IDocumentExtension4)document;
            this.lineSeparator = ext.getDefaultLineDelimiter();
        }
        try {
            this.lineSeparator = document.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        this.adjustTabwidthAndTabChar();
        IEditorInput editorInput = this.part.getEditorInput();
        IProject project = null;
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fl = (IFileEditorInput)editorInput;
            project = fl.getFile().getProject();
        }
        if (selection.getLength() == 0 || selection.getLength() == document.getLength()) {
            this.formatWhole(selection, document, project);
        } else {
            this.formatSelection(selection, document, project);
        }
        super.run();
        LexemeList lexemeList = this.part.getFileContext().getParseState().getLexemeList();
        if (lexemeList.size() > lsIndex && lsIndex != -1) {
            lexeme = lexemeList.get(lsIndex);
            endOffset = initialOffset = lexeme.getEndingOffset();
            if (lsIndex < lexemeList.size() - 1) {
                endOffset = lexemeList.get(lsIndex + 1).getStartingOffset();
            }
            initialOffset = Math.min(initialOffset + offsetFromLex, endOffset);
            if (this.lineSeparator != null && this.lineSeparator.length() > 1) {
                try {
                    char charAtOffset = document.getChar(initialOffset);
                    if (charAtOffset == this.lineSeparator.charAt(1)) {
                        initialOffset = initialOffset > 0 ? --initialOffset : ++initialOffset;
                    }
                }
                catch (BadLocationException e) {
                    IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
                }
            }
            textWidget.setCaretOffset(initialOffset);
        }
        if (lineIndex > -1 && lineIndex < lexemeList.size()) {
            lexeme = lexemeList.get(lineIndex);
            endOffset = initialOffset = lexeme.getEndingOffset();
            if (lineIndex < lexemeList.size() - 1) {
                endOffset = lexemeList.get(lineIndex + 1).getStartingOffset();
            }
            initialOffset = Math.min(initialOffset + lineOffsetFromLex, endOffset);
            textWidget.setTopIndex(textWidget.getLineAtOffset(initialOffset));
        }
        this.part.getViewer().getTextWidget().redraw();
    }

    private void adjustTabwidthAndTabChar() {
        String defaultLanguage = this.part.getFileContext().getDefaultLanguage();
        String pluginId = null;
        if (defaultLanguage.equals(TEXT_HTML)) {
            pluginId = "com.aptana.ide.editor.html";
        } else if (defaultLanguage.equals("text/javascript")) {
            pluginId = "com.aptana.ide.editor.js";
        } else if (defaultLanguage.equals("text/css")) {
            pluginId = "com.aptana.ide.editor.css";
        } else if (defaultLanguage.equals("text/php")) {
            pluginId = "com.aptana.ide.editor.php";
        }
        if (pluginId != null) {
            this.tabWitdh = Platform.getPreferencesService().getInt(pluginId, "com.aptana.ide.editors.codeassist.formatter.tabulation.size", 4, null);
            this.tabChar = Platform.getPreferencesService().getString(pluginId, "com.aptana.ide.editors.codeassist.formatter.tabulation.char", "", null);
        }
    }

    private void formatWhole(TextSelection selection, IDocument document, IProject project) {
        IParseNode parseResults = this.part.getFileContext().getParseState().getParseResults();
        if (parseResults == null) {
            return;
        }
        String language = parseResults.getLanguage();
        ICodeFormatter codeFormatter = LanguageRegistry.getCodeFormatter(language);
        if (codeFormatter == null) {
            return;
        }
        String content = document.get();
        if (!codeFormatter.handlesNested()) {
            ArrayList languageList = new ArrayList();
            this.checkNodes(languageList, parseResults);
            boolean hasPHP = false;
            int a = 0;
            while (a < languageList.size()) {
                IParseNode object = (IParseNode)languageList.get(a);
                if (object.getLanguage().equals("text/php")) {
                    hasPHP = true;
                    break;
                }
                ++a;
            }
            StringBuffer clearedContent = new StringBuffer();
            int prev = 0;
            String nestedMark = codeFormatter.createNestedMark();
            int a2 = 0;
            while (a2 < languageList.size()) {
                IParseNode pnode = (IParseNode)languageList.get(a2);
                if (pnode.getStartingOffset() <= prev) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)"Nodes seems to have wrong offset while formatting following content: {0} Node offset:{1} Prev offset:{2}", (Object[])new String[]{content, String.valueOf(pnode.getStartingOffset()), String.valueOf(prev)}));
                    return;
                }
                clearedContent.append(content.substring(prev, pnode.getStartingOffset()));
                prev = pnode.getEndingOffset();
                clearedContent.append(nestedMark);
                ++a2;
            }
            if (prev < content.length()) {
                clearedContent.append(content.substring(prev));
            }
            String formattedContentNotMixed = codeFormatter.format(clearedContent.toString(), hasPHP, null, project, this.lineSeparator);
            int a3 = 0;
            while (a3 < languageList.size()) {
                IParseNode pnode = (IParseNode)languageList.get(a3);
                int indexOf = formattedContentNotMixed.indexOf(nestedMark);
                int iLevel = this.calcindent(formattedContentNotMixed, indexOf);
                if (indexOf == -1) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)"Nested mark not found, during formatting nested language Old:{0} New:{1}", (Object[])new String[]{content, formattedContentNotMixed}));
                    return;
                }
                String languageContent = this.formatNode(content, pnode, null, project);
                languageContent = this.indent(iLevel + 2, languageContent, this.lineSeparator);
                formattedContentNotMixed = String.valueOf(formattedContentNotMixed.substring(0, indexOf)) + languageContent + formattedContentNotMixed.substring(indexOf + nestedMark.length());
                ++a3;
            }
            this.actualReplace(selection, content, formattedContentNotMixed);
        } else {
            String formattedContent = codeFormatter.format(content, false, null, project, this.lineSeparator);
            this.actualReplace(selection, content, formattedContent);
        }
    }

    private void formatSelection(TextSelection selection, IDocument document, IProject project) {
        int selectionEnd;
        int selectionStart;
        IParseNode parseResults = this.part.getFileContext().getParseState().getParseResults();
        LexemeList lexemeList = this.part.getFileContext().getLexemeList();
        if (!this.checkSplitting(lexemeList, selectionStart = selection.getOffset(), selectionEnd = selection.getOffset() + selection.getLength())) {
            return;
        }
        IParseNode old = parseResults;
        if ((parseResults = this.getSmallestNode(parseResults, selection.getOffset(), selection.getLength())) == null) {
            parseResults = old;
        }
        String language = this.determineLanguage(selection, document, parseResults, lexemeList);
        ICodeFormatter codeFormatter = LanguageRegistry.getCodeFormatter(language);
        try {
            String content;
            IRegion lineInformationOfOffset = document.getLineInformationOfOffset(selection.getOffset());
            int offset = lineInformationOfOffset.getOffset();
            String string = document.get(offset, lineInformationOfOffset.getLength());
            int internalOffset = selection.getOffset() - offset;
            int indentLevel = 0;
            int lineOffset = this.calcLineOffset(string);
            int lineOfOffset = document.getLineOfOffset(selection.getOffset());
            boolean isLeading = false;
            boolean isHtml = language.equals(TEXT_HTML);
            indentLevel = this.calculateIndentation(document, isHtml ? lineOfOffset - 1 : lineOfOffset - 1, isHtml);
            if (lineOffset >= internalOffset) {
                int length = selection.getLength() + (selection.getOffset() - offset);
                if (document.getLength() <= offset + length) {
                    length = document.getLength() - offset;
                }
                selection = new TextSelection(offset, length);
                isLeading = true;
            }
            if ((content = document.get(selection.getOffset(), selection.getLength())).trim().length() == 0) {
                return;
            }
            if (!codeFormatter.handlesNested()) {
                ArrayList languageList = new ArrayList();
                this.checkNodes(languageList, parseResults);
                StringBuffer clearedContent = new StringBuffer();
                int prev = 0;
                String nestedMark = codeFormatter.createNestedMark();
                int a = 0;
                while (a < languageList.size()) {
                    IParseNode pnode = (IParseNode)languageList.get(a);
                    int i = pnode.getStartingOffset() - selection.getOffset();
                    if (i < 0 || i < prev) {
                        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)"Format failed bad ast positions {0},", (Object[])new String[]{content, pnode.toString()}));
                        return;
                    }
                    clearedContent.append(content.substring(prev, i));
                    prev = pnode.getEndingOffset() - selection.getOffset();
                    clearedContent.append(nestedMark);
                    ++a;
                }
                if (prev < content.length()) {
                    clearedContent.append(content.substring(prev));
                }
                String formattedContentNotMixed = this.doActualFormat(selection, project, codeFormatter, content, languageList, clearedContent, nestedMark);
                formattedContentNotMixed = this.indent(indentLevel, formattedContentNotMixed, this.lineSeparator);
                this.actualReplace(selection, content, formattedContentNotMixed);
            } else if (content.length() > 0) {
                String formattedContent = codeFormatter.format(content, true, null, project, this.lineSeparator);
                if (formattedContent.equals(content)) {
                    return;
                }
                formattedContent = this.indent(indentLevel, formattedContent, this.lineSeparator);
                formattedContent = this.removeTrailingReturnsIfNeeded(content, formattedContent);
                if (!isLeading) {
                    formattedContent = this.removeLeadingWhiteSpaces(content, formattedContent);
                }
                this.actualReplace(selection, content, formattedContent);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private String removeLeadingWhiteSpaces(String content, String formattedContent) {
        int pos = 0;
        int a = 0;
        while (a < content.length()) {
            char c = content.charAt(a);
            if (!Character.isWhitespace(c)) break;
            ++pos;
            ++a;
        }
        if (pos > 0) {
            content = content.substring(pos);
        }
        return content;
    }

    private String doActualFormat(TextSelection selection, IProject project, ICodeFormatter codeFormatter, String content, ArrayList languageList, StringBuffer clearedContent, String nestedMark) {
        String formattedContentNotMixed = codeFormatter.format(clearedContent.toString(), true, null, project, this.lineSeparator);
        int a = 0;
        while (a < languageList.size()) {
            IParseNode pnode = (IParseNode)languageList.get(a);
            int indexOf = formattedContentNotMixed.indexOf(nestedMark);
            int iLevel = this.calcindent(formattedContentNotMixed, indexOf);
            String languageContent = this.formatNode(content, pnode, selection, project);
            languageContent = this.indent(iLevel + 2, languageContent, this.lineSeparator);
            formattedContentNotMixed = String.valueOf(formattedContentNotMixed.substring(0, indexOf)) + languageContent + formattedContentNotMixed.substring(indexOf + nestedMark.length());
            ++a;
        }
        return formattedContentNotMixed;
    }

    public String removeTrailingReturnsIfNeeded(String content, String formattedContent) {
        char charAt1;
        boolean isTrailingOriginal = false;
        char charAt = content.charAt(content.length() - 1);
        if (charAt == '\r' || charAt == '\n') {
            isTrailingOriginal = true;
        }
        boolean isTrailingFormatted = false;
        if (formattedContent.length() > 0 && ((charAt1 = formattedContent.charAt(formattedContent.length() - 1)) == '\r' || charAt1 == '\n')) {
            isTrailingFormatted = true;
        }
        if (isTrailingOriginal && !isTrailingFormatted) {
            formattedContent = String.valueOf(formattedContent) + this.lineSeparator;
        }
        if (!isTrailingOriginal && isTrailingFormatted) {
            int pos = formattedContent.length();
            int a = formattedContent.length() - 1;
            while (a > 0) {
                char charAt12 = formattedContent.charAt(a);
                if (charAt12 != '\r' && charAt12 != '\n') break;
                --pos;
                --a;
            }
            if (pos != formattedContent.length()) {
                formattedContent = formattedContent.substring(0, pos);
            }
        }
        return formattedContent;
    }

    private int calcLineOffset(String string) {
        int lineOffset = 0;
        int a = 0;
        while (a < string.length()) {
            char c = string.charAt(a);
            if (!Character.isWhitespace(c)) break;
            ++lineOffset;
            ++a;
        }
        return lineOffset;
    }

    public int calculateIndentation(IDocument document, int lineOfOffset, boolean isHtml) throws BadLocationException {
        String string = this.determineCorrectString(document, lineOfOffset);
        int indentLevel = 0;
        boolean isInLeadingCode = true;
        int braceCount = 0;
        boolean leading = true;
        int a = 0;
        while (a < string.length()) {
            char c = string.charAt(a);
            if (isInLeadingCode && Character.isWhitespace(c)) {
                if (c == ' ') {
                    ++indentLevel;
                }
                if (c == '\t') {
                    indentLevel += this.tabWitdh;
                }
            } else {
                if (c == '{' && !isHtml) {
                    ++braceCount;
                    indentLevel += this.tabWitdh;
                    leading = false;
                } else if (c == '}' && !isHtml) {
                    if (!leading && braceCount > 0) {
                        indentLevel -= this.tabWitdh;
                        --braceCount;
                    }
                } else {
                    leading = false;
                }
                isInLeadingCode = false;
            }
            ++a;
        }
        return indentLevel;
    }

    public String determineCorrectString(IDocument document, int lineOfOffset) throws BadLocationException {
        String string = "";
        boolean inComment = false;
        while (lineOfOffset >= 0) {
            IRegion lineInformation = document.getLineInformation(lineOfOffset);
            string = document.get(lineInformation.getOffset(), lineInformation.getLength());
            if (string.trim().length() == 0) {
                --lineOfOffset;
                continue;
            }
            if (string.trim().endsWith("*/") && !string.contains("/*")) {
                inComment = true;
                --lineOfOffset;
                continue;
            }
            if (!inComment) break;
            if (string.contains("/*")) {
                inComment = false;
            }
            --lineOfOffset;
        }
        if (inComment) {
            string = "";
        }
        return string;
    }

    private boolean checkSplitting(LexemeList lexemeList, int selectionStart, int selectionEnd) {
        Lexeme lexemeFromOffset = lexemeList.getLexemeFromOffset(selectionStart);
        Lexeme lexemeFromSelection = lexemeList.getLexemeFromOffset(selectionEnd);
        if (lexemeFromOffset != null || lexemeFromSelection != null) {
            boolean startSplit = this.lexemeSplitByOffset(lexemeFromOffset, selectionStart);
            boolean endSplit = this.lexemeSplitByOffset(lexemeFromSelection, selectionEnd);
            if (startSplit || endSplit) {
                return false;
            }
        }
        return true;
    }

    private String determineLanguage(TextSelection selection, IDocument document, IParseNode parseResults, LexemeList lexemeList) {
        String language = parseResults.getLanguage();
        Lexeme lexemeFromOffsetStart = lexemeList.getCeilingLexeme(selection.getOffset());
        if (lexemeFromOffsetStart != null && !lexemeFromOffsetStart.getLanguage().equals(language) && language.equals(TEXT_HTML)) {
            language = lexemeFromOffsetStart.getLanguage();
        }
        if (language.equals("text/php") && selection.getOffset() <= parseResults.getStartingOffset()) {
            String string;
            try {
                string = document.get(parseResults.getStartingOffset(), 3);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
            if (string.startsWith("<?")) {
                language = TEXT_HTML;
            }
        }
        return language;
    }

    private boolean lexemeSplitByOffset(Lexeme lexeme, int offset) {
        if (lexeme == null) {
            return false;
        }
        if (lexeme != null && lexeme.containsOffset(offset) && lexeme.getLanguage().equals(TEXT_HTML)) {
            return false;
        }
        boolean condition = lexeme != null && lexeme.containsOffset(offset) && offset != lexeme.getStartingOffset();
        return condition;
    }

    private boolean verifyContentPreserved(String oldContent, String newContent) {
        Pattern pattern = Pattern.compile("\\S");
        Matcher oldMatcher = pattern.matcher(oldContent);
        Matcher newMatcher = pattern.matcher(newContent);
        boolean condition = oldMatcher.find() && !newMatcher.find();
        return !condition;
    }

    private IParseNode getSmallestNode(IParseNode parseResults, int offset, int length) {
        if (parseResults.getStartingOffset() <= offset && parseResults.getEndingOffset() >= offset + length) {
            int a = 0;
            while (a < parseResults.getChildCount()) {
                IParseNode child = parseResults.getChild(a);
                IParseNode smallestNode = this.getSmallestNode(child, offset, length);
                if (smallestNode != null) {
                    return smallestNode;
                }
                ++a;
            }
            return parseResults;
        }
        return null;
    }

    private int calcindent(String formattedContentNotMixed, int indexOf) {
        int pos = 0;
        int a = indexOf - 1;
        while (a >= 0) {
            ++pos;
            char charAt = formattedContentNotMixed.charAt(a);
            if (charAt == '\n' || charAt == '\r') break;
            --a;
        }
        return pos;
    }

    public String indent(int level, String languageContent, String lineSeparator) {
        if (lineSeparator == null) {
            return languageContent;
        }
        String[] split = languageContent.split(lineSeparator);
        SourceWriter result = new SourceWriter(level, this.tabChar, this.tabWitdh);
        if (split.length == 1) {
            result.printIndent();
            result.print(split[0]);
            return result.toString();
        }
        int a = 0;
        while (a < split.length) {
            result.printlnWithIndent(split[a]);
            ++a;
        }
        return result.toString();
    }

    private String formatNode(String content, IParseNode pnode, TextSelection selection, IProject project) {
        int start = selection == null ? pnode.getStartingOffset() : pnode.getStartingOffset() - selection.getOffset();
        int end = selection == null ? pnode.getEndingOffset() : pnode.getEndingOffset() - selection.getOffset();
        String nodeContent = content.substring(start, end);
        ICodeFormatter codeFormatter = LanguageRegistry.getCodeFormatter(pnode.getLanguage());
        if (codeFormatter != null) {
            String formattedContent = codeFormatter.format(nodeContent, false, null, project, this.lineSeparator).trim();
            return formattedContent;
        }
        return nodeContent;
    }

    private void actualReplace(TextSelection selection, String content, String formattedContent) {
        try {
            IDocument document;
            if (!this.verifyContentPreserved(content, formattedContent)) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)"Format failed and removed non-whitespace content. old \"{0}\", new \"{1}\"", (Object[])new String[]{content, formattedContent}));
                return;
            }
            int offset = 0;
            if (selection.getLength() != 0) {
                offset = selection.getOffset();
            }
            if ((document = this.part.getViewer().getDocument()).get(offset, content.length()).equals(formattedContent)) {
                return;
            }
            this.part.getViewer().getTextWidget().setRedraw(false);
            document.replace(offset, content.length(), formattedContent);
            this.part.getViewer().setSelectedRange(selection.getOffset(), 0);
            this.part.getViewer().getTextWidget().setRedraw(true);
        }
        catch (BadLocationException badLocationException) {}
    }

    private void checkNodes(ArrayList languageList, IParseNode parseResults) {
        int a = 0;
        while (a < parseResults.getChildCount()) {
            IParseNode child = parseResults.getChild(a);
            if (child.getLanguage().equals(parseResults.getLanguage())) {
                this.checkNodes(languageList, child);
            } else if (child.getStartingOffset() != -1 && child.getEndingOffset() != -1) {
                languageList.add(child);
            }
            ++a;
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        String[] legalLineDelimiters;
        this.part = (IUnifiedEditor)targetEditor;
        if (this.part != null && this.part.getViewer() != null && this.part.getViewer().getDocument() != null && (legalLineDelimiters = this.part.getViewer().getDocument().getLegalLineDelimiters()) != null && legalLineDelimiters.length > 0) {
            this.lineSeparator = legalLineDelimiters[0];
        }
    }

    public void run(IAction action) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

