/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.colorizer;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.colorizer.CategoryColorizer;
import com.aptana.ide.editors.unified.colorizer.ColorizationStyle;
import com.aptana.ide.editors.unified.colorizer.ColorizerWriter;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.colorizer.Region;
import com.aptana.ide.editors.unified.colorizer.TokenColorizer;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.TokenList;
import com.aptana.sax.AttributeSniffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class LanguageStructureProvider
implements ITreeContentProvider,
ITableLabelProvider {
    private Map categories;
    private Map regions;
    private Map imageMap;
    private Color backgroundColor;
    private Color lineHighlightColor;
    private Color caretColor;
    private Color selectionForegroundColor;
    private Color selectionBackgroundColor;
    private Color foldingBackgroundColor;
    private Color foldingForegroundColor;
    private String language;

    private String hashToken(IToken token) {
        return String.valueOf(token.getLanguage()) + "::" + token.getCategory() + "::" + token.getType();
    }

    public LanguageStructureProvider(String language) {
        this.language = language;
        this.categories = new HashMap();
        this.imageMap = new HashMap();
        this.regions = new HashMap();
        this.backgroundColor = null;
        this.lineHighlightColor = null;
        this.caretColor = null;
        this.selectionForegroundColor = null;
        this.selectionBackgroundColor = null;
        this.loadProvider();
    }

    public void loadProvider() {
        LanguageColorizer lc;
        TokenList tl = LanguageRegistry.getTokenList(this.language);
        if (tl != null) {
            int i = 0;
            while (i < tl.size()) {
                IToken curr = tl.get(i);
                this.addToken(curr);
                ++i;
            }
        }
        if ((lc = LanguageRegistry.getLanguageColorizer(this.language)) != null) {
            for (Object curr : lc.getTokenColorizers()) {
                ColorizationStyle currStyle = ((TokenColorizer)curr).getBaseColorization();
                ColorizationStyle clone = new ColorizationStyle(currStyle);
                this.addStyle(((TokenColorizer)curr).getToken(), clone);
                Iterator regions = ((TokenColorizer)curr).getRegions().iterator();
                HashMap<String, Region> regionMap = new HashMap<String, Region>();
                while (regions.hasNext()) {
                    Region region = (Region)regions.next();
                    Region cloneRegion = new Region(region);
                    ColorizationStyle regionStyle = region.getStyle();
                    ColorizationStyle regionCloneStyle = new ColorizationStyle(regionStyle);
                    cloneRegion.setStyle(regionCloneStyle);
                    cloneRegion.setName(region.getName());
                    regionMap.put(cloneRegion.getName(), cloneRegion);
                    this.addRegion(((TokenColorizer)curr).getToken(), cloneRegion);
                }
            }
            for (Object curr : lc.getCategoryColorizers()) {
                ColorizationStyle clone = new ColorizationStyle(((CategoryColorizer)curr).getStyle());
                Category category = this.getCategory(((CategoryColorizer)curr).getName());
                category.setStyle(clone);
            }
            this.setBackgroundColor(lc.getBackground());
            this.setCaretColor(lc.getCaretColor());
            this.setLineHighlightColor(lc.getLineHighlightColor());
            this.setSelectionForegroundColor(lc.getSelectionForeground());
            this.setSelectionBackgroundColor(lc.getSelectionBackground());
            this.setFoldingBackgroundColor(lc.getFoldingBg());
            this.setFoldingForegroundColor(lc.getFoldingFg());
        }
    }

    public void clearStyles() {
        for (Category cat : this.categories.values()) {
            cat.setStyle(null);
            cat.getStyles().clear();
        }
        for (Map map : this.regions.values()) {
            map.clear();
        }
    }

    public void addStyle(IToken token, ColorizationStyle style) {
        Category cat = this.getCategory(token.getCategory());
        cat.addTokenStyle(token, style);
    }

    public void removeStyle(IToken token) {
        Category cat = this.getCategory(token.getCategory());
        cat.removeTokenStyle(token);
        Map regionMap = (Map)this.regions.get(token);
        regionMap.clear();
    }

    public void removeRegion(IToken token, String name) {
        Map regionMap = (Map)this.regions.get(token);
        regionMap.remove(name);
    }

    public void addRegion(IToken token, Region region) {
        Map regionMap = (Map)this.regions.get(token);
        regionMap.put(region.getName(), region);
    }

    public Map getRegions(IToken token) {
        return (Map)this.regions.get(token);
    }

    public Map getTokenStyles() {
        HashMap all = new HashMap();
        for (Category cat : this.categories.values()) {
            all.putAll(cat.getStyles());
        }
        return all;
    }

    public Collection getTokens() {
        ArrayList all = new ArrayList();
        for (Category cat : this.categories.values()) {
            all.addAll(cat.getTokens());
        }
        return all;
    }

    public Map getCategoryStyles() {
        HashMap<Category, ColorizationStyle> all = new HashMap<Category, ColorizationStyle>();
        for (Category cat : this.categories.values()) {
            all.put(cat, cat.getStyle());
        }
        return all;
    }

    public ColorizationStyle getStyle(IToken token) {
        Category cat = this.getCategory(token.getCategory());
        return cat.getTokenStyle(token);
    }

    public Category getCategory(String category) {
        Category cat = null;
        if (this.categories.containsKey(category)) {
            cat = (Category)this.categories.get(category);
        }
        return cat;
    }

    public void addToken(IToken token) {
        Category category = null;
        if (!this.categories.containsKey(token.getCategory())) {
            category = new Category(token.getCategory());
            ColorizationStyle style = new ColorizationStyle();
            style.setForegroundColor(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 0)));
            style.setName(category.getName());
            category.setStyle(style);
            this.categories.put(token.getCategory(), category);
        } else {
            category = (Category)this.categories.get(token.getCategory());
        }
        if (category.getToken(this.hashToken(token)) == null) {
            category.addToken(token);
        }
        this.regions.put(token, new HashMap());
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Category) {
            ArrayList list = new ArrayList(((Category)parentElement).getTokens());
            Collections.sort(list, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = ((IToken)o1).getDisplayName();
                    String s2 = ((IToken)o2).getDisplayName();
                    return s1.compareTo(s2);
                }
            });
            return list.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IToken) {
            IToken token = (IToken)element;
            return this.getCategory(token.getCategory());
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof Category;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList list = new ArrayList(this.categories.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((Category)o1).getDisplayName();
                String s2 = ((Category)o2).getDisplayName();
                return s1.compareTo(s2);
            }
        });
        return list.toArray();
    }

    public void dispose() {
    }

    public void disposeImages() {
        Iterator iter = this.imageMap.values().iterator();
        while (iter.hasNext()) {
            ((Image)iter.next()).dispose();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ColorizationStyle style = null;
        if (element instanceof IToken) {
            style = this.getStyle((IToken)element);
        } else if (element instanceof Category) {
            style = ((Category)element).getStyle();
        }
        if (style != null) {
            if (columnIndex == 1 && element instanceof IToken) {
                return UnifiedEditorsPlugin.getImage("icons/checked.gif");
            }
            if (columnIndex == 3 && element instanceof IToken) {
                if (!this.getRegions((IToken)element).isEmpty()) {
                    return UnifiedEditorsPlugin.getImage("icons/region.gif");
                }
            } else if (columnIndex == 4) {
                if (style != null) {
                    Color fg = style.getForegroundColor();
                    Image img = null;
                    if (!this.imageMap.containsKey(fg.getRGB())) {
                        img = new Image((Device)Display.getCurrent(), 16, 16);
                        GC gc = new GC((Drawable)img);
                        gc.setBackground(fg);
                        gc.fillRectangle(1, 1, 13, 13);
                        gc.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 0)));
                        gc.drawRectangle(1, 1, 13, 13);
                        gc.dispose();
                        this.imageMap.put(fg.getRGB(), img);
                    } else {
                        img = (Image)this.imageMap.get(fg.getRGB());
                    }
                    return img;
                }
            } else {
                if (columnIndex == 5) {
                    if (style != null && style.isBold()) {
                        return UnifiedEditorsPlugin.getImage("icons/bold_on.gif");
                    }
                    return UnifiedEditorsPlugin.getImage("icons/bold_off.gif");
                }
                if (columnIndex == 6) {
                    if (style != null && style.isItalic()) {
                        return UnifiedEditorsPlugin.getImage("icons/italic_on.gif");
                    }
                    return UnifiedEditorsPlugin.getImage("icons/italic_off.gif");
                }
                if (columnIndex == 7) {
                    if (style != null && style.isUnderline()) {
                        return UnifiedEditorsPlugin.getImage("icons/underline_on.gif");
                    }
                    return UnifiedEditorsPlugin.getImage("icons/underline_off.gif");
                }
            }
        } else if (columnIndex == 1 && element instanceof IToken) {
            return UnifiedEditorsPlugin.getImage("icons/unchecked.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof Category) {
                return ((Category)element).getDisplayName();
            }
        } else if (columnIndex == 2 && element instanceof IToken) {
            return ((IToken)element).getDisplayName();
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeAll() {
        this.categories.clear();
        this.imageMap.clear();
        this.regions.clear();
        this.backgroundColor = null;
        this.lineHighlightColor = null;
        this.caretColor = null;
        this.selectionForegroundColor = null;
        this.selectionBackgroundColor = null;
    }

    public void buildLanguageColorizer(LanguageColorizer lc, String prefId) {
        Map tokenStyles = this.getTokenStyles();
        for (IToken curr : this.getTokens()) {
            ColorizationStyle cloneStyle = (ColorizationStyle)tokenStyles.get(this.hashToken(curr));
            if (cloneStyle == null) continue;
            ColorizationStyle newStyle = new ColorizationStyle(cloneStyle);
            TokenColorizer colorizer = lc.getTokenColorizer(curr);
            if (colorizer == null) {
                colorizer = new TokenColorizer();
                colorizer.setToken(curr);
                lc.addTokenColorizer(colorizer);
            }
            colorizer.setBaseColorization(newStyle);
            Map regionMap = this.getRegions(curr);
            for (Region region : regionMap.values()) {
                Region cloneRegion = new Region(region);
                cloneRegion.setName(region.getName());
                ColorizationStyle newRegionStyle = new ColorizationStyle(region.getStyle());
                newRegionStyle.setName(String.valueOf(curr.getCategory()) + "_" + curr.getType() + "_" + region.getName());
                cloneRegion.setStyle(newRegionStyle);
                colorizer.addColorization(cloneRegion);
            }
            Iterator existingRegions = colorizer.getRegions().iterator();
            while (existingRegions.hasNext()) {
                Region currRegion = (Region)existingRegions.next();
                if (regionMap.containsKey(currRegion.getName())) continue;
                existingRegions.remove();
            }
        }
        Iterator colorizers = lc.getTokenColorizers().iterator();
        while (colorizers.hasNext()) {
            TokenColorizer curr = (TokenColorizer)colorizers.next();
            if (tokenStyles.containsKey(this.hashToken(curr.getToken()))) continue;
            colorizers.remove();
        }
        Map categoryStyles = this.getCategoryStyles();
        for (Category category : categoryStyles.keySet()) {
            ColorizationStyle curr = (ColorizationStyle)categoryStyles.get(category);
            ColorizationStyle newStyle = new ColorizationStyle(curr);
            CategoryColorizer colorizer = lc.getCategoryColorizer(category.getName());
            if (colorizer == null) {
                colorizer = new CategoryColorizer();
                colorizer.setName(category.getName());
                lc.addCategoryColorizer(colorizer);
            }
            colorizer.setStyle(newStyle);
        }
        colorizers = lc.getCategoryColorizers().iterator();
        while (colorizers.hasNext()) {
            CategoryColorizer curr = (CategoryColorizer)colorizers.next();
            Category cat = this.getCategory(curr.getName());
            if (categoryStyles.containsKey(cat)) continue;
            colorizers.remove();
        }
        lc.setBackground(this.getBackgroundColor());
        lc.setCaretColor(this.getCaretColor());
        lc.setLineHighlightColor(this.getLineHighlightColor());
        lc.setSelectionBackground(this.getSelectionBackgroundColor());
        lc.setSelectionForeground(this.getSelectionForegroundColor());
        lc.setFoldingBg(this.getFoldingBackgroundColor());
        lc.setFoldingFg(this.getFoldingForegroundColor());
        try {
            new ColorizerWriter().buildColorizationPreference(lc, lc.getLanguage(), prefId);
            UnifiedEditorsPlugin.getDefault().getPreferenceStore().firePropertyChangeEvent("Colorization saved", (Object)"Colorization saved", (Object)"Colorization saved");
        }
        catch (LexerException e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage());
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color caretColor) {
        this.caretColor = caretColor;
    }

    public Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public void setLineHighlightColor(Color lineHighlightColor) {
        this.lineHighlightColor = lineHighlightColor;
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color selectionBackgroundColor) {
        this.selectionBackgroundColor = selectionBackgroundColor;
    }

    public Color getSelectionForegroundColor() {
        return this.selectionForegroundColor;
    }

    public void setSelectionForegroundColor(Color selectionForegroundColor) {
        this.selectionForegroundColor = selectionForegroundColor;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void buildColorizationFile(File file) throws LexerException {
        if (this.getLanguage() == null) {
            return;
        }
        LanguageColorizer colorizer = LanguageRegistry.getLanguageColorizer(this.getLanguage());
        new ColorizerWriter().buildColorizationFile(colorizer, this.getLanguage(), file);
    }

    public void importColorization(File file) {
        AttributeSniffer sniffer = new AttributeSniffer("colorizer", "language");
        try {
            sniffer.read((InputStream)new FileInputStream(file));
            if (this.getLanguage() != null && this.getLanguage().equals(sniffer.getMatchedValue())) {
                LanguageRegistry.importColorization(file, this.getLanguage());
                this.clearStyles();
                this.loadProvider();
            }
        }
        catch (Exception exception) {}
    }

    public void resetToLanguageDefaults() {
        if (this.getLanguage() != null) {
            this.clearStyles();
            LanguageRegistry.restoreDefaultColorization(this.getLanguage());
            this.loadProvider();
        }
    }

    public void refreshTokens() {
        TokenList tl = LanguageRegistry.getTokenList(this.language);
        if (tl != null) {
            int i = 0;
            while (i < tl.size()) {
                IToken curr = tl.get(i);
                Category category = this.getCategory(curr.getCategory());
                if (category == null || category.getToken(curr.getType()) == null) {
                    this.addToken(curr);
                }
                ++i;
            }
        }
    }

    public Color getFoldingBackgroundColor() {
        return this.foldingBackgroundColor;
    }

    public void setFoldingBackgroundColor(Color foldingBackgroundColor) {
        this.foldingBackgroundColor = foldingBackgroundColor;
    }

    public Color getFoldingForegroundColor() {
        return this.foldingForegroundColor;
    }

    public void setFoldingForegroundColor(Color foldingForegroundColor) {
        this.foldingForegroundColor = foldingForegroundColor;
    }

    public class Category {
        private Map tokens;
        private Map styles;
        private String name;
        private ColorizationStyle style;

        public Category(String name) {
            this.name = name;
            this.tokens = new HashMap();
            this.styles = new HashMap();
            this.style = null;
        }

        public void setStyle(ColorizationStyle style) {
            this.style = style;
        }

        public ColorizationStyle getStyle() {
            return this.style;
        }

        public void addTokenStyle(IToken token, ColorizationStyle style) {
            if (token != null) {
                this.styles.put(LanguageStructureProvider.this.hashToken(token), style);
            }
        }

        public void removeTokenStyle(IToken token) {
            if (token != null) {
                this.styles.remove(LanguageStructureProvider.this.hashToken(token));
            }
        }

        public ColorizationStyle getTokenStyle(IToken token) {
            ColorizationStyle style = null;
            if (token != null) {
                style = (ColorizationStyle)this.styles.get(LanguageStructureProvider.this.hashToken(token));
            }
            return style;
        }

        public void addToken(IToken token) {
            this.tokens.put(LanguageStructureProvider.this.hashToken(token), token);
        }

        public IToken getToken(String hash) {
            if (this.tokens.containsKey(hash)) {
                return (IToken)this.tokens.get(hash);
            }
            return null;
        }

        public Collection getTokens() {
            return this.tokens.values();
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            String display = this.name.toLowerCase();
            display = String.valueOf(display.substring(0, 1).toUpperCase()) + display.substring(1, display.length());
            return display;
        }

        public Map getStyles() {
            return this.styles;
        }
    }
}

